/*
 * Decompiled with CFR 0.152.
 */
package io.relution.jenkins.scmsqs;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.TaskListener;
import hudson.util.StreamTaskListener;
import io.relution.jenkins.scmsqs.SQSTrigger;
import io.relution.jenkins.scmsqs.logging.Log;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;

public class SQSTriggerBuilder
implements Runnable {
    private final SQSTrigger trigger;
    private final AbstractProject<?, ?> job;
    private final DateFormat formatter = DateFormat.getDateTimeInstance();

    public SQSTriggerBuilder(SQSTrigger trigger, AbstractProject<?, ?> job) {
        this.trigger = trigger;
        this.job = job;
    }

    @Override
    public void run() {
        File log = this.trigger.getLogFile();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (StreamTaskListener listener = new StreamTaskListener(log);){
                this.buildIfChanged(listener);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Log.severe(e, "Failed to record SCM polling", new Object[0]);
        }
    }

    private void buildIfChanged(StreamTaskListener listener) {
        PrintStream logger = listener.getLogger();
        long now = System.currentTimeMillis();
        logger.format("Started on %s", this.toDateTime(now));
        boolean hasChanges = this.job.poll((TaskListener)listener).hasChanges();
        logger.println("Done. Took " + this.toTimeSpan(now));
        if (!hasChanges) {
            logger.println("No changes");
        } else {
            logger.println("Changes found");
            this.build(logger, now);
        }
    }

    private void build(PrintStream logger, long now) {
        String note = "SQS poll initiated on " + this.toDateTime(now);
        Cause.RemoteCause cause = new Cause.RemoteCause("SQS trigger", note);
        if (this.job.scheduleBuild((Cause)cause)) {
            logger.println("Job queued");
        } else {
            logger.println("Job NOT queued - it was determined that this job has been queued already.");
        }
    }

    private String toDateTime(long timestamp) {
        Date date = new Date(timestamp);
        return this.formatter.format(date);
    }

    private String toTimeSpan(long timestamp) {
        long now = System.currentTimeMillis();
        return Util.getTimeSpanString((long)(now - timestamp));
    }
}

