/*
 * Decompiled with CFR 0.152.
 */
package io.relution.jenkins.scmsqs;

import com.amazonaws.services.sqs.model.Message;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import hudson.Extension;
import hudson.Util;
import hudson.console.AnnotatedLargeText;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.relution.jenkins.scmsqs.Context;
import io.relution.jenkins.scmsqs.SQSTriggerBuilder;
import io.relution.jenkins.scmsqs.SQSTriggerQueue;
import io.relution.jenkins.scmsqs.interfaces.Event;
import io.relution.jenkins.scmsqs.interfaces.EventTriggerMatcher;
import io.relution.jenkins.scmsqs.interfaces.MessageParser;
import io.relution.jenkins.scmsqs.interfaces.MessageParserFactory;
import io.relution.jenkins.scmsqs.interfaces.SQSQueue;
import io.relution.jenkins.scmsqs.interfaces.SQSQueueListener;
import io.relution.jenkins.scmsqs.interfaces.SQSQueueMonitorScheduler;
import io.relution.jenkins.scmsqs.interfaces.SQSQueueProvider;
import io.relution.jenkins.scmsqs.logging.Log;
import io.relution.jenkins.scmsqs.sqstrigger.Messages;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import net.sf.json.JSONObject;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class SQSTrigger
extends Trigger<AbstractProject<?, ?>>
implements SQSQueueListener,
Runnable {
    private final String queueUuid;
    private transient SQSQueueMonitorScheduler scheduler;
    private transient MessageParserFactory messageParserFactory;
    private transient EventTriggerMatcher eventTriggerMatcher;
    private transient ExecutorService executor;

    @DataBoundConstructor
    public SQSTrigger(String queueUuid) {
        this.queueUuid = queueUuid;
    }

    public File getLogFile() {
        return new File(((AbstractProject)this.job).getRootDir(), "sqs-polling.log");
    }

    public void start(AbstractProject<?, ?> project, boolean newInstance) {
        Log.info("Start trigger for project %s", project);
        this.getScheduler().register(this);
        super.start(project, newInstance);
    }

    @Override
    public void run() {
        SQSTriggerBuilder builder = new SQSTriggerBuilder(this, (AbstractProject)this.job);
        builder.run();
    }

    public void stop() {
        Log.info("Stop trigger (%s)", this);
        this.getScheduler().unregister(this);
        super.stop();
    }

    public Collection<? extends Action> getProjectActions() {
        return Collections.singleton(new SQSTriggerPollingAction());
    }

    @Override
    public void handleMessages(List<Message> messages) {
        for (Message message : messages) {
            this.handleMessage(message);
        }
    }

    @Override
    public String getQueueUuid() {
        return this.queueUuid;
    }

    @Inject
    public void setScheduler(SQSQueueMonitorScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public SQSQueueMonitorScheduler getScheduler() {
        if (this.scheduler == null) {
            Context.injector().injectMembers((Object)this);
        }
        return this.scheduler;
    }

    @Inject
    public void setMessageParserFactory(MessageParserFactory factory) {
        this.messageParserFactory = factory;
    }

    public MessageParserFactory getMessageParserFactory() {
        if (this.messageParserFactory == null) {
            Context.injector().injectMembers((Object)this);
        }
        return this.messageParserFactory;
    }

    @Inject
    public void setEventTriggerMatcher(EventTriggerMatcher matcher) {
        this.eventTriggerMatcher = matcher;
    }

    public EventTriggerMatcher getEventTriggerMatcher() {
        if (this.eventTriggerMatcher == null) {
            Context.injector().injectMembers((Object)this);
        }
        return this.eventTriggerMatcher;
    }

    @Inject
    public void setExecutorService(ExecutorService executor) {
        this.executor = executor;
    }

    public ExecutorService getExecutorService() {
        if (this.executor == null) {
            Context.injector().injectMembers((Object)this);
        }
        return this.executor;
    }

    private void handleMessage(Message message) {
        List<Event> events;
        MessageParser parser = this.messageParserFactory.createParser(message);
        EventTriggerMatcher matcher = this.getEventTriggerMatcher();
        if (matcher.matches(events = parser.parseMessage(message), ((AbstractProject)this.job).getScm())) {
            this.execute();
        }
    }

    private void execute() {
        Log.info("SQS event triggered build of %s", ((AbstractProject)this.job).getFullDisplayName());
        this.executor.execute(this);
    }

    @Extension
    public static class DescriptorImpl
    extends TriggerDescriptor
    implements SQSQueueProvider {
        private static final String KEY_SQS_QUEUES = "sqsQueues";
        private volatile List<SQSTriggerQueue> sqsQueues;
        private volatile transient Map<String, SQSTriggerQueue> sqsQueueMap;
        private volatile transient SQSQueueMonitorScheduler scheduler;

        public static DescriptorImpl get() {
            return (DescriptorImpl)Trigger.all().get(DescriptorImpl.class);
        }

        public DescriptorImpl() {
            this.load();
        }

        public synchronized void load() {
            super.load();
            this.initQueueMap();
        }

        public boolean isApplicable(Item item) {
            return item instanceof AbstractProject;
        }

        public String getDisplayName() {
            return Messages.displayName();
        }

        public ListBoxModel doFillQueueUuidItems() {
            List<SQSTriggerQueue> queues = this.getSqsQueues();
            ListBoxModel items = new ListBoxModel();
            for (SQSTriggerQueue queue : queues) {
                items.add(queue.getName(), queue.getUuid());
            }
            return items;
        }

        public FormValidation doCheckQueueUuid(@QueryParameter String value) {
            if (this.getSqsQueues().size() == 0) {
                return FormValidation.error((String)Messages.errorQueueUnavailable());
            }
            if (StringUtils.isEmpty((CharSequence)value)) {
                return FormValidation.ok((String)Messages.infoQueueDefault());
            }
            SQSQueue queue = this.getSqsQueue(value);
            if (queue == null) {
                return FormValidation.error((String)Messages.errorQueueUuidUnknown());
            }
            return FormValidation.ok();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            Object sqsQueues = json.get(KEY_SQS_QUEUES);
            this.sqsQueues = req.bindJSONToList(SQSTriggerQueue.class, sqsQueues);
            this.initQueueMap();
            this.save();
            this.scheduler.onConfigurationChanged();
            return true;
        }

        public List<SQSTriggerQueue> getSqsQueues() {
            if (this.sqsQueues == null) {
                this.load();
            }
            if (this.sqsQueues == null) {
                return Collections.emptyList();
            }
            return this.sqsQueues;
        }

        @Override
        public SQSQueue getSqsQueue(String uuid) {
            if (this.sqsQueueMap == null) {
                return null;
            }
            return this.sqsQueueMap.get(uuid);
        }

        @Inject
        public void setScheduler(SQSQueueMonitorScheduler sQSQueueMonitorScheduler) {
            this.scheduler = sQSQueueMonitorScheduler;
        }

        public SQSQueueMonitorScheduler getScheduler() {
            if (this.scheduler == null) {
                Context.injector().injectMembers((Object)this);
            }
            return this.scheduler;
        }

        private void initQueueMap() {
            if (this.sqsQueues == null) {
                return;
            }
            this.sqsQueueMap = Maps.newHashMapWithExpectedSize((int)this.sqsQueues.size());
            for (SQSTriggerQueue queue : this.sqsQueues) {
                this.sqsQueueMap.put(queue.getUuid(), queue);
            }
        }
    }

    public final class SQSTriggerPollingAction
    implements Action {
        public AbstractProject<?, ?> getOwner() {
            return (AbstractProject)SQSTrigger.this.job;
        }

        public String getIconFileName() {
            return "clipboard.png";
        }

        public String getDisplayName() {
            return "SQS Activity Log";
        }

        public String getUrlName() {
            return "SQSActivityLog";
        }

        public String getLog() throws IOException {
            return Util.loadFile((File)SQSTrigger.this.getLogFile());
        }

        public void writeLogTo(XMLOutput out) throws IOException {
            AnnotatedLargeText log = new AnnotatedLargeText(SQSTrigger.this.getLogFile(), Charset.defaultCharset(), true, (Object)this);
            log.writeHtmlTo(0L, out.asWriter());
        }
    }
}

