/*
 * Decompiled with CFR 0.152.
 */
package com.zimperium.plugins.zDevJenkinsUploadPlugin;

import hudson.ProxyConfiguration;
import hudson.util.Secret;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import okhttp3.Authenticator;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.apache.commons.lang.StringUtils;

public class ZDevHTTPClient {
    public OkHttpClient getHttpClient(Boolean useProxy, int connectionTimeoutMillis, int writeTimeoutMillis, int readTimeoutMillis) {
        ProxyConfiguration proxyConfig;
        OkHttpClient.Builder okClientBuilder = new OkHttpClient.Builder().connectTimeout((long)connectionTimeoutMillis, TimeUnit.MILLISECONDS).writeTimeout((long)writeTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout((long)readTimeoutMillis, TimeUnit.MILLISECONDS);
        if (useProxy.booleanValue() && (proxyConfig = Jenkins.get().getProxy()) != null) {
            Proxy _httpProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyConfig.getName(), proxyConfig.getPort()));
            if (proxyConfig.getUserName() != null && StringUtils.isNotBlank((String)proxyConfig.getUserName())) {
                String proxyUserInfo = proxyConfig.getUserName() + ":" + Secret.toString((Secret)proxyConfig.getSecretPassword());
                final String basicAuth = new String(Base64.getEncoder().encode(proxyUserInfo.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
                Authenticator _httpProxyAuth = new Authenticator(){

                    public Request authenticate(Route route, Response response) throws IOException {
                        return response.request().newBuilder().addHeader("Proxy-Authorization", "Basic " + basicAuth).build();
                    }
                };
                if (_httpProxyAuth != null) {
                    return okClientBuilder.proxyAuthenticator(_httpProxyAuth).proxy(_httpProxy).build();
                }
            }
            return okClientBuilder.proxy(_httpProxy).build();
        }
        return okClientBuilder.build();
    }
}

