/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.zerobug;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import io.jenkins.plugins.zerobug.Messages;
import io.jenkins.plugins.zerobug.ZeroBugAction;
import io.jenkins.plugins.zerobug.commons.Property;
import java.io.IOException;
import java.time.LocalDate;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;

public class ZeroBugPublisher
extends Recorder
implements SimpleBuildStep {
    private Secret token = this.getToken();
    private final String webSite;
    private final boolean onlyBuildSuccess;

    @DataBoundConstructor
    public ZeroBugPublisher(String webSite, boolean onlyBuildSuccess) {
        this.webSite = webSite;
        this.onlyBuildSuccess = onlyBuildSuccess;
    }

    public Secret getToken() {
        if (this.token == null) {
            this.token = this.getDescriptor().getToken();
        }
        return this.token;
    }

    public String getWebSite() {
        return this.webSite;
    }

    public boolean isOnlyBuildSuccess() {
        return this.onlyBuildSuccess;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private String generateBuildId(String token, String webSite) {
        String password = token + webSite + LocalDate.now();
        return DigestUtils.md5Hex((String)password).toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        if (StringUtils.isBlank((String)Secret.toString((Secret)this.token))) {
            listener.getLogger().println(Messages.ZeroBugPublisher_DescriptorImpl_errors_missingToken());
            run.setResult(Result.FAILURE);
        }
        if (StringUtils.isBlank((String)this.webSite)) {
            listener.getLogger().println(Messages.ZeroBugPublisher_DescriptorImpl_errors_missingWebsite());
            run.setResult(Result.FAILURE);
        }
        if (this.onlyBuildSuccess && Result.SUCCESS == run.getResult() || !this.onlyBuildSuccess) {
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                String buildId = this.generateBuildId(Secret.toString((Secret)this.token), this.webSite);
                HttpGet request = new HttpGet(Property.getByKey("url.request"));
                httpClient.execute((HttpUriRequest)request);
                run.addAction((Action)new ZeroBugAction(this.token, this.webSite, buildId, run));
                listener.getLogger().println("token " + this.token);
                listener.getLogger().println("webSite " + this.webSite);
                listener.getLogger().println("buildId " + buildId);
                listener.getLogger().println("onlyBuildSuccess " + this.onlyBuildSuccess);
            }
        }
    }

    @Symbol(value={"ZeroBugPublisher"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private Secret token;
        private String webSite;

        public DescriptorImpl() {
            super(ZeroBugPublisher.class);
            this.load();
        }

        public Secret getToken() {
            return this.token;
        }

        public void setToken(Secret token) {
            this.token = token;
        }

        public String getWebSite() {
            return this.webSite;
        }

        public void setWebSite(String webSite) {
            this.webSite = webSite;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListBoxModel doFillWebSiteItems() throws IOException {
            ListBoxModel items = new ListBoxModel();
            if (!StringUtils.isBlank((String)Secret.toString((Secret)this.token))) {
                try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                    HttpGet request = new HttpGet(Property.getByKey("url.get.list.site"));
                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        String result = EntityUtils.toString((HttpEntity)entity);
                        items.add(result, "0");
                    }
                    items.add("http://www.google.com", "1");
                    items.add("http://www.globo.com", "2");
                    items.add("http://www.jenkins.com", "3");
                    items.add("http://www.java.com", "4");
                }
            }
            return items;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindParameters((Object)this);
            this.token = Secret.fromString((String)formData.getString("token"));
            this.save();
            return super.configure(req, formData);
        }

        public FormValidation doCheckToken(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.ZeroBugPublisher_DescriptorImpl_errors_missingToken());
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doValidateConnection(@QueryParameter String token) throws IOException {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (StringUtils.isBlank((String)token)) {
                return FormValidation.error((String)Messages.ZeroBugPublisher_DescriptorImpl_Validate_Connect_Error());
            }
            return this.validateConnection(token);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FormValidation validateConnection(String token) throws IOException {
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                HttpGet request = new HttpGet(Property.getByKey("url.get.list.site"));
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
                if (response.getStatusLine().getStatusCode() == 200) {
                    FormValidation formValidation = FormValidation.ok((String)Messages.ZeroBugPublisher_DescriptorImpl_Validate_Connect_Success());
                    return formValidation;
                }
                FormValidation formValidation = FormValidation.error((String)(Messages.ZeroBugPublisher_DescriptorImpl_Validate_Connect_Reject() + response.getStatusLine().getStatusCode()));
                return formValidation;
            }
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.ZeroBugPublisher_DescriptorImpl_DisplayName();
        }
    }
}

