/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.worktile.resolver;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogSet;
import io.jenkins.plugins.worktile.WTHelper;
import io.jenkins.plugins.worktile.WTLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.MasterToSlaveFileCallable;
import jenkins.scm.RunWithSCM;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class WorkItemResolver {
    public static final Logger logger = Logger.getLogger(WorkItemResolver.class.getName());
    public static final Pattern pattern = Pattern.compile("#[^(\\s|/)]*[A-Za-z0-9_-]{0,15}-[0-9]+");
    public static final String VCSFolder = ".git";
    private final Set<String> collection = new HashSet<String>();
    private final WTLogger wtLogger;
    private final Run<?, ?> run;
    private final FilePath workspace;
    private final TaskListener listener;
    private final boolean isTagged;
    private boolean isChangeSetsExisted = false;

    public WorkItemResolver(Run<?, ?> run, FilePath workspace, TaskListener listener) {
        this(run, workspace, listener, false);
    }

    public WorkItemResolver(Run<?, ?> run, FilePath workspace, TaskListener listener, boolean isTagged) {
        this.run = run;
        this.workspace = workspace;
        this.listener = listener;
        this.wtLogger = new WTLogger(this.listener);
        this.isTagged = isTagged;
    }

    public List<String> resolve() {
        this.collection.clear();
        this.fromChangeLog();
        this.fromEnvironment();
        try {
            this.setMessages();
        }
        catch (Exception e) {
            this.wtLogger.info("Extract work items error from message body " + e.getMessage());
        }
        HashSet sets = new HashSet();
        this.collection.forEach(item -> {
            Matcher matcher = pattern.matcher((CharSequence)item);
            while (matcher.find()) {
                sets.add(matcher.group().toUpperCase());
            }
        });
        return WTHelper.formatWorkItems(new ArrayList<String>(sets));
    }

    public void fromChangeLog() {
        RunWithSCM<?, ?> scm = this.toSCMRun();
        if (scm == null) {
            this.wtLogger.info("Ignore scm change-sets");
            return;
        }
        List changeLogSets = scm.getChangeSets();
        this.wtLogger.info("SCM change-sets:");
        for (Object changeLogSet : changeLogSets) {
            for (Object set : (ChangeLogSet)changeLogSet) {
                String msg = ((ChangeLogSet.Entry)set).getMsg();
                if (msg == null) continue;
                this.wtLogger.info(msg);
                this.isChangeSetsExisted = true;
                this.collection.add(msg);
            }
        }
        this.wtLogger.info("");
    }

    public void fromEnvironment() {
        EnvVars envVars = WTHelper.safeEnvVars(this.run);
        if (envVars.get((Object)"GIT_BRANCH") != null) {
            this.collection.add((String)envVars.get((Object)"GIT_BRANCH"));
        }
        if (envVars.get((Object)"ghprbSourceBranch") != null) {
            this.collection.add((String)envVars.get((Object)"ghprbSourceBranch"));
        }
        if (envVars.get((Object)"ghprbPullTitle") != null) {
            this.collection.add((String)envVars.get((Object)"ghprbPullTitle"));
        }
        if (envVars.get((Object)"ghprbCommentBody") != null) {
            this.collection.add((String)envVars.get((Object)"ghprbCommentBody"));
        }
    }

    public void setMessages() throws IOException, InterruptedException, GitAPIException {
        if (this.run == null || this.workspace == null) {
            return;
        }
        boolean isGit = this.workspace.child(VCSFolder).exists();
        if (!isGit) {
            this.wtLogger.info("unsupported vcs, current git only");
        }
        FilePath gitStoreDir = this.workspace.child(VCSFolder);
        String prActualCommit = (String)this.run.getEnvironment(TaskListener.NULL).get((Object)"ghprbActualCommit");
        String branchName = (String)this.run.getEnvironment(TaskListener.NULL).get((Object)"BRANCH_NAME");
        if (prActualCommit != null) {
            this.wtLogger.info("PR rule hit");
            List messages = (List)gitStoreDir.act((FilePath.FileCallable)new GitCommitMessageCallback(this.listener, ObjectId.fromString((String)prActualCommit)));
            this.collection.addAll(messages);
        } else if (this.isTagged) {
            this.wtLogger.info("Tag rule hit");
            List messages = (List)gitStoreDir.act((FilePath.FileCallable)new GitTagsCallback(this.listener));
            this.collection.addAll(messages);
        } else if (branchName != null) {
            this.wtLogger.info("Branch rule hit");
            List messages = (List)gitStoreDir.act((FilePath.FileCallable)new GitBranchCallback(this.listener, branchName, this.isChangeSetsExisted));
            this.collection.addAll(messages);
        } else {
            this.wtLogger.info("None message logic hit");
        }
    }

    private RunWithSCM<?, ?> toSCMRun() {
        AbstractBuild runWithScm = null;
        if (this.run instanceof AbstractBuild) {
            runWithScm = (AbstractBuild)this.run;
        } else if (this.run instanceof WorkflowRun) {
            runWithScm = (WorkflowRun)this.run;
        } else if (this.run instanceof RunWithSCM) {
            runWithScm = (RunWithSCM)this.run;
        }
        return runWithScm;
    }

    private static final class GitBranchCallback
    extends MasterToSlaveFileCallable<List<String>> {
        private static final long serialVersionUID = -247109644349075954L;
        private final TaskListener listener;
        private final String branchName;
        private final boolean isChangeSetsExisted;

        public GitBranchCallback(TaskListener listener, String branchName, boolean isChangeSetsExisted) {
            this.listener = listener;
            this.branchName = branchName;
            this.isChangeSetsExisted = isChangeSetsExisted;
        }

        public List<String> invoke(File file, VirtualChannel virtualChannel) throws IOException, InterruptedException {
            ArrayList<String> messages = new ArrayList<String>();
            WTLogger wtLogger = new WTLogger(this.listener);
            if (!file.exists() || !file.isDirectory()) {
                return messages;
            }
            if (this.isChangeSetsExisted) {
                wtLogger.info("Ignore branch commits");
            }
            return messages;
        }
    }

    private static final class GitTagsCallback
    extends MasterToSlaveFileCallable<List<String>> {
        private static final long serialVersionUID = -247109644349075954L;
        private final TaskListener listener;

        public GitTagsCallback(TaskListener listener) {
            this.listener = listener;
        }

        public List<String> invoke(File file, VirtualChannel virtualChannel) throws IOException, InterruptedException {
            ArrayList<String> messages = new ArrayList<String>();
            WTLogger wtLogger = new WTLogger(this.listener);
            if (!file.exists() || !file.isDirectory()) {
                return messages;
            }
            try (FileRepository fileRepository = new FileRepository(file.getAbsolutePath());){
                List tags = null;
                Git git = new Git((Repository)fileRepository);
                try {
                    tags = git.tagList().call();
                    this.sort(tags, new RevWalk((Repository)fileRepository));
                    if (!tags.isEmpty()) {
                        Ref tag0 = (Ref)tags.get(0);
                        Ref peeledRef0 = fileRepository.getRefDatabase().peel(tag0);
                        wtLogger.info("current tag = " + tag0.getName());
                        ObjectId utilId = peeledRef0.getPeeledObjectId() != null ? peeledRef0.getPeeledObjectId() : tag0.getObjectId();
                        Ref tag1 = (Ref)tags.get(1);
                        ObjectId startId = null;
                        if (tag1 != null) {
                            wtLogger.info("previous tag = " + tag1.getName());
                            Ref peeledRef1 = fileRepository.getRefDatabase().peel(tag1);
                            startId = peeledRef1.getPeeledObjectId() != null ? peeledRef1.getPeeledObjectId() : tag1.getObjectId();
                        }
                        LogCommand log = git.log().addRange(startId, (AnyObjectId)utilId);
                        Iterable logs = log.call();
                        for (RevCommit commit : logs) {
                            String message;
                            if (commit == null || (message = commit.getFullMessage()) == null) continue;
                            messages.add(message);
                        }
                    }
                }
                catch (Exception exception) {
                    wtLogger.error("get commit message in tag error");
                }
                git.close();
            }
            return messages;
        }

        private void sort(List<Ref> tags, RevWalk walk) {
            tags.sort((t1, t2) -> {
                try {
                    Date d1 = walk.parseCommit((AnyObjectId)t1.getObjectId()).getCommitterIdent().getWhen();
                    Date d2 = walk.parseCommit((AnyObjectId)t2.getObjectId()).getCommitterIdent().getWhen();
                    return d2.compareTo(d1);
                }
                catch (Exception e) {
                    logger.info("sort tags error: " + e.getMessage());
                    return 0;
                }
            });
        }
    }

    private static final class GitCommitMessageCallback
    extends MasterToSlaveFileCallable<List<String>> {
        private static final long serialVersionUID = 8799047890954988521L;
        private final TaskListener listener;
        private final ObjectId prHeadCommitId;

        public GitCommitMessageCallback(TaskListener listener, ObjectId prHeadCommitId) {
            this.listener = listener;
            this.prHeadCommitId = prHeadCommitId;
        }

        public List<String> invoke(File file, VirtualChannel virtualChannel) throws IOException, InterruptedException {
            ArrayList<String> messages = new ArrayList<String>();
            if (!file.exists() || !file.isDirectory()) {
                return messages;
            }
            try (FileRepository fileRepository = new FileRepository(file.getAbsolutePath());){
                ObjectId currentHeadId = fileRepository.resolve("HEAD~^{commit}");
                if (currentHeadId == null) {
                    ArrayList<String> arrayList = messages;
                    return arrayList;
                }
                Git git = new Git((Repository)fileRepository);
                try {
                    Iterable items = git.log().addRange((AnyObjectId)currentHeadId, (AnyObjectId)this.prHeadCommitId).call();
                    for (RevCommit commit : items) {
                        if (commit == null) continue;
                        messages.add(commit.getFullMessage());
                    }
                }
                catch (Exception e) {
                    this.listener.getLogger().println("collection message error: " + e.getMessage());
                }
                git.close();
                ArrayList<String> arrayList = messages;
                return arrayList;
            }
        }
    }
}

