/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.worktile.pipeline;

import com.google.common.collect.ImmutableSet;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.worktile.WTLogger;
import io.jenkins.plugins.worktile.model.WTDeployEntity;
import io.jenkins.plugins.worktile.model.WTEnvironmentEntity;
import io.jenkins.plugins.worktile.model.WTEnvironmentSchema;
import io.jenkins.plugins.worktile.model.WTRestException;
import io.jenkins.plugins.worktile.service.WTRestService;
import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.jetbrains.annotations.NotNull;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class WTSendDeployStep
extends Step
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String releaseName;
    private final String environmentName;
    @DataBoundSetter
    private String releaseURL;
    @DataBoundSetter
    private String specifiedWorkItems;
    @DataBoundSetter
    private boolean failOnError;
    @DataBoundSetter
    private String status;
    @DataBoundSetter
    private boolean isTagged;

    @DataBoundConstructor
    public WTSendDeployStep(String releaseName, String environmentName) {
        this.releaseName = releaseName;
        this.environmentName = environmentName;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new WTSendDeployStepExecution(context, this);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, EnvVars.class, TaskListener.class, FilePath.class);
        }

        public String getFunctionName() {
            return "worktileDeployRecord";
        }

        @NotNull
        public String getDisplayName() {
            return "Send deploy result to worktile";
        }
    }

    public static class WTSendDeployStepExecution
    extends SynchronousNonBlockingStepExecution<Boolean> {
        private static final long serialVersionUID = 1L;
        private final WTSendDeployStep step;

        public WTSendDeployStepExecution(StepContext context, WTSendDeployStep step) {
            super(context);
            this.step = step;
        }

        public Boolean run() throws Exception {
            block5: {
                String envId;
                WTRestService service;
                WTLogger wtLogger;
                TaskListener listener;
                FilePath workspace;
                WorkflowRun run;
                block4: {
                    run = (WorkflowRun)this.getContext().get(WorkflowRun.class);
                    workspace = (FilePath)this.getContext().get(FilePath.class);
                    listener = (TaskListener)this.getContext().get(TaskListener.class);
                    wtLogger = new WTLogger(listener);
                    service = new WTRestService();
                    envId = null;
                    try {
                        envId = this.handleEnvName(this.step.environmentName, service);
                    }
                    catch (Exception exception) {
                        wtLogger.error(exception.getMessage());
                        if (!(exception instanceof WTRestException ? !((WTRestException)exception).getCode().equals("100105") && this.step.failOnError : this.step.failOnError)) break block4;
                        throw new AbortException(exception.getMessage());
                    }
                }
                WTDeployEntity entity = WTDeployEntity.from(run, workspace, listener, this.step.status, this.step.releaseName, this.step.releaseURL, this.step.specifiedWorkItems, envId, this.step.isTagged);
                wtLogger.info("Will send data to worktile: " + entity.toString());
                try {
                    service.createDeploy(entity);
                    wtLogger.info("Create worktile deploy record successfully.");
                }
                catch (Exception exception) {
                    wtLogger.error(exception.getMessage());
                    if (!this.step.failOnError) break block5;
                    throw new AbortException(exception.getMessage());
                }
            }
            return true;
        }

        public String handleEnvName(String name, WTRestService service) throws IOException, WTRestException {
            WTEnvironmentSchema schema = service.getEnvironmentByName(name);
            if (schema == null) {
                schema = service.createEnvironment(new WTEnvironmentEntity(name));
            }
            return schema.id;
        }
    }
}

