/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.worktile.pipeline;

import com.google.common.collect.ImmutableSet;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.worktile.WTLogger;
import io.jenkins.plugins.worktile.model.WTBuildEntity;
import io.jenkins.plugins.worktile.service.WTRestService;
import java.io.Serializable;
import java.util.Set;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.jetbrains.annotations.NotNull;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class PCSendBuildStep
extends Step
implements Serializable {
    private static final long serialVersionUID = 1L;
    @DataBoundSetter
    private String overviewPattern;
    @DataBoundSetter
    private String defaultSummary;
    @DataBoundSetter
    private boolean failOnError;
    @DataBoundSetter
    private String status;
    @DataBoundSetter
    private String resultURL;
    @DataBoundSetter
    private String specifiedWorkItems;

    @DataBoundConstructor
    public PCSendBuildStep() {
    }

    public StepExecution start(StepContext context) throws Exception {
        return new WTSendBuildStepExecution(context, this);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, EnvVars.class, TaskListener.class, FilePath.class, Launcher.class);
        }

        public String getFunctionName() {
            return "pingcodeBuildRecord";
        }

        @NotNull
        public String getDisplayName() {
            return "Send build result to pingcode";
        }
    }

    public static class WTSendBuildStepExecution
    extends SynchronousNonBlockingStepExecution<Boolean> {
        private static final long serialVersionUID = 1L;
        private final PCSendBuildStep step;

        public WTSendBuildStepExecution(StepContext context, PCSendBuildStep step) {
            super(context);
            this.step = step;
        }

        public Boolean run() throws Exception {
            block2: {
                WorkflowRun run = (WorkflowRun)this.getContext().get(WorkflowRun.class);
                TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
                FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
                WTLogger logger = new WTLogger(listener);
                WTBuildEntity entity = WTBuildEntity.from(run, workspace, listener, this.step.status, this.step.overviewPattern, this.step.defaultSummary, this.step.resultURL, this.step.specifiedWorkItems);
                WTRestService service = new WTRestService();
                logger.info("Will send data to pingcode: " + entity.toString());
                try {
                    service.createBuild(entity);
                    logger.info("Create pingcode build record successfully.");
                }
                catch (Exception exception) {
                    logger.error(exception.getMessage());
                    if (!this.step.failOnError) break block2;
                    throw new AbortException(exception.getMessage());
                }
            }
            return true;
        }
    }
}

