/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.worktile.client;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.jenkins.plugins.worktile.model.WTErrorEntity;
import io.jenkins.plugins.worktile.model.WTRestException;
import java.io.IOException;
import java.util.Objects;
import java.util.logging.Logger;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class ApiConnection {
    private final transient String accessToken;
    private final Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    private final Logger logger = Logger.getLogger(ApiConnection.class.getName());
    private final OkHttpClient httpClient;

    public ApiConnection(OkHttpClient client) {
        this(null, client);
    }

    public ApiConnection(String accessToken, OkHttpClient client) {
        this.accessToken = accessToken;
        this.httpClient = client;
    }

    public ApiConnection() {
        this(null, new OkHttpClient());
    }

    public String executeGet(String url) throws IOException, WTRestException {
        Request.Builder requestBuilder = new Request.Builder().url(url).get();
        return this.execute(requestBuilder);
    }

    private String execute(Request.Builder requestBuilder) throws IOException, WTRestException {
        if (this.accessToken != null) {
            requestBuilder.addHeader("Authorization", "Bearer " + this.accessToken);
        }
        requestBuilder.addHeader("Content-Type", "application/json");
        try (Response response = this.httpClient.newCall(requestBuilder.build()).execute();){
            if (!response.isSuccessful()) {
                WTErrorEntity error = (WTErrorEntity)this.gson.fromJson(Objects.requireNonNull(response.body()).string(), WTErrorEntity.class);
                throw new WTRestException(error.getCode(), error.getMessage());
            }
            String string = Objects.requireNonNull(response.body()).string();
            return string;
        }
    }

    public String executePost(String url, Object body) throws IOException, WTRestException {
        MediaType JSONMedia = MediaType.get((String)"application/json; charset=utf-8");
        String json = this.gson.toJson(body);
        RequestBody reqBody = RequestBody.create((String)json, (MediaType)JSONMedia);
        Request.Builder requestBuilder = new Request.Builder().url(url).post(reqBody);
        return this.execute(requestBuilder);
    }

    public <TBody> String executeDelete(String url, Class<TBody> body) throws IOException, WTRestException {
        MediaType JSONMedia = MediaType.get((String)"application/json; charset=utf-8");
        String json = this.gson.toJson(body);
        RequestBody reqBody = RequestBody.create((String)json, (MediaType)JSONMedia);
        Request.Builder requestBuilder = new Request.Builder().url(url).delete(reqBody);
        return this.execute(requestBuilder);
    }

    public String executeDelete(String url) throws IOException, WTRestException {
        Request.Builder requestBuilder = new Request.Builder().url(url).delete();
        return this.execute(requestBuilder);
    }
}

