/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.worktile;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.worktile.Messages;
import io.jenkins.plugins.worktile.WTHelper;
import io.jenkins.plugins.worktile.model.WTRestException;
import io.jenkins.plugins.worktile.resolver.SecretResolver;
import io.jenkins.plugins.worktile.service.WTRestService;
import java.io.IOException;
import java.util.Optional;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;

@Extension
public class WTGlobalConfiguration
extends GlobalConfiguration {
    public static final String DEFAULT_ENDPOINT = "https://open.pingcode.com";
    public static final String PINGCODE_GLOBAL_CONFIG_ID = "worktile-global-configuration";
    public static final Logger logger = Logger.getLogger(WTGlobalConfiguration.class.getName());
    private String endpoint;
    private String clientId;
    private String credentialsId;

    public WTGlobalConfiguration() {
        this.load();
    }

    @Nonnull
    public static WTGlobalConfiguration get() {
        return (WTGlobalConfiguration)Jenkins.get().getDescriptorOrDie(WTGlobalConfiguration.class);
    }

    public String getDefaultEndpoint() {
        return DEFAULT_ENDPOINT;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = Util.fixEmptyAndTrim((String)credentialsId);
    }

    public String getClientId() {
        return this.clientId;
    }

    @DataBoundSetter
    public void setClientId(String clientId) {
        this.clientId = Util.fixEmptyAndTrim((String)clientId);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    @DataBoundSetter
    public void setEndpoint(String endpoint) {
        this.endpoint = Util.fixEmptyAndTrim((String)endpoint);
    }

    public String getId() {
        return PINGCODE_GLOBAL_CONFIG_ID;
    }

    public boolean configure(StaplerRequest req, JSONObject formatData) throws Descriptor.FormException {
        try {
            req.bindJSON((Object)this, formatData);
        }
        catch (Exception e) {
            throw new Descriptor.FormException(e.getMessage(), (Throwable)e, Messages.WTGlobalConfig_GlobalConfigError());
        }
        this.save();
        return true;
    }

    public FormValidation doCheckEndpoint(@QueryParameter(value="endpoint", fixEmpty=true) String endpoint) {
        if (WTHelper.isNotBlank(endpoint) && !WTHelper.isURL(endpoint)) {
            return FormValidation.error((String)Messages.WTGlobalConfig_OpenApiEndpointError());
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckClientId(@QueryParameter(value="clientId", fixEmpty=true) String clientId) {
        return WTHelper.isNotBlank(clientId) ? FormValidation.ok() : FormValidation.error((String)Messages.WTGlobalConfig_ClientIdError());
    }

    public FormValidation doCheckCredentialsId(@QueryParameter(value="credentialsId", fixEmpty=true) String credentialsId) {
        return WTHelper.isNotBlank(credentialsId) ? FormValidation.ok() : FormValidation.error((String)Messages.WTGlobalConfig_CredentialsIdEmpty());
    }

    @POST
    @Restricted(value={DoNotUse.class})
    public FormValidation doTestConnection(@QueryParameter(value="endpoint", fixEmpty=true) String endpoint, @QueryParameter(value="clientId", fixEmpty=true) String clientId, @QueryParameter(value="credentialsId", fixEmpty=true) String credentialsId) throws IOException {
        Jenkins.get().hasPermission(Jenkins.ADMINISTER);
        if (StringUtils.isEmpty((String)credentialsId) || StringUtils.isEmpty((String)endpoint) || StringUtils.isEmpty((String)clientId)) {
            return FormValidation.error((String)Messages.WTGlobalConfig_AnyOfIdError());
        }
        Optional<String> secret = SecretResolver.getSecretOf(credentialsId);
        if (!secret.isPresent()) {
            return FormValidation.error((String)Messages.WTGlobalConfig_CredentialsIdNotSelectOrError());
        }
        WTRestService service = new WTRestService(WTHelper.apiV1(endpoint), clientId, secret.get());
        try {
            service.doConnectTest();
            return FormValidation.ok((String)Messages.WTGlobalConfig_DoTestConnectionSuccessfully());
        }
        catch (WTRestException e) {
            return FormValidation.error((String)(Messages.WTGlobalConfig_DoTestConnectionFailure() + ": " + Messages.WTGlobalConfig_ClientIdOrClientSecretError()));
        }
        catch (Exception e) {
            return FormValidation.error((String)(Messages.WTGlobalConfig_DoTestConnectionFailure() + ": " + e.getMessage()));
        }
    }

    public ListBoxModel doFillCredentialsIdItems(@QueryParameter String endpoint, @QueryParameter String clientId, @QueryParameter String credentialsId) {
        Jenkins jenkins = Jenkins.get();
        if (!jenkins.hasPermission(Jenkins.ADMINISTER)) {
            return new StandardListBoxModel().includeCurrentValue(credentialsId);
        }
        return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)Jenkins.get(), StringCredentials.class, URIRequirementBuilder.fromUri((String)StringUtils.defaultIfBlank((String)endpoint, (String)DEFAULT_ENDPOINT)).build(), CredentialsMatchers.always());
    }
}

