/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.worktile;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import io.jenkins.plugins.worktile.Messages;
import io.jenkins.plugins.worktile.WTLogger;
import io.jenkins.plugins.worktile.model.WTBuildEntity;
import io.jenkins.plugins.worktile.service.WTRestService;
import java.io.IOException;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.jetbrains.annotations.NotNull;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class WTBuildNotifier
extends Notifier
implements SimpleBuildStep {
    private String overview;
    private String defaultSummary;
    private String resultURL;
    private String specifiedWorkItems;

    @DataBoundConstructor
    public WTBuildNotifier(String overview, String defaultSummary, String resultURL, String specifiedWorkItems) {
        this.setOverview(overview);
        this.setDefaultSummary(defaultSummary);
        this.setResultURL(resultURL);
        this.setSpecifiedWorkItems(specifiedWorkItems);
    }

    public String getResultURL() {
        return this.resultURL;
    }

    @DataBoundSetter
    public void setResultURL(String resultURL) {
        this.resultURL = resultURL;
    }

    public String getSpecifiedWorkItems() {
        return this.specifiedWorkItems;
    }

    @DataBoundSetter
    public void setSpecifiedWorkItems(String specifiedWorkItems) {
        this.specifiedWorkItems = specifiedWorkItems;
    }

    public String getDefaultSummary() {
        return this.defaultSummary;
    }

    @DataBoundSetter
    public void setDefaultSummary(String defaultSummary) {
        this.defaultSummary = Util.fixEmptyAndTrim((String)defaultSummary);
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws IOException, InternalError {
        this.createBuild(run, workspace, listener);
    }

    private void createBuild(Run<?, ?> run, FilePath workspace, @Nonnull TaskListener listener) throws IOException {
        WTLogger logger = new WTLogger(listener);
        WTBuildEntity entity = WTBuildEntity.from(run, workspace, listener, this.getOverview(), this.getDefaultSummary(), this.getResultURL(), this.getSpecifiedWorkItems());
        WTRestService service = new WTRestService();
        logger.info("Will send data to pingcode: " + entity.toString());
        try {
            service.createBuild(entity);
            logger.info("Create pingcode build record successfully.");
        }
        catch (Exception error) {
            logger.error(error.getMessage());
        }
    }

    public String getOverview() {
        return this.overview;
    }

    @DataBoundSetter
    public void setOverview(String overview) {
        this.overview = Util.fixEmptyAndTrim((String)overview);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    public static class Descriptor
    extends BuildStepDescriptor<Publisher> {
        public Descriptor() {
            super(WTBuildNotifier.class);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        @NotNull
        public String getDisplayName() {
            return Messages.WTBuildNotifier_DisplayName();
        }

        public WTBuildNotifier newInstance(StaplerRequest request, @NotNull JSONObject formData) throws Descriptor.FormException {
            assert (request != null);
            return (WTBuildNotifier)((Object)request.bindJSON(WTBuildNotifier.class, formData));
        }
    }
}

