/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.worktile;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import io.jenkins.plugins.worktile.Messages;
import io.jenkins.plugins.worktile.WTHelper;
import io.jenkins.plugins.worktile.WTLogger;
import io.jenkins.plugins.worktile.model.WTDeployEntity;
import io.jenkins.plugins.worktile.model.WTEnvironmentEntity;
import io.jenkins.plugins.worktile.model.WTEnvironmentSchema;
import io.jenkins.plugins.worktile.model.WTRestException;
import io.jenkins.plugins.worktile.service.WTRestService;
import java.io.IOException;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.jetbrains.annotations.NotNull;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class PCDeployNotifier
extends Notifier
implements SimpleBuildStep {
    private String environmentName;
    private String releaseName;
    private String releaseUrl;
    private String specifiedWorkItems;
    private boolean tagged;

    @DataBoundConstructor
    public PCDeployNotifier(String releaseName, String environmentName, String releaseUrl, String specifiedWorkItems, boolean tagged) {
        this.setReleaseName(releaseName);
        this.setReleaseUrl(releaseUrl);
        this.setSpecifiedWorkItems(specifiedWorkItems);
        this.setEnvironmentName(environmentName);
        this.setTagged(tagged);
    }

    public boolean getTagged() {
        return this.tagged;
    }

    public void setTagged(boolean tagged) {
        this.tagged = tagged;
    }

    public void perform(@NotNull Run<?, ?> run, @NotNull FilePath workspace, @NotNull Launcher launcher, @NotNull TaskListener listener) {
        String envId;
        WTRestService service;
        WTLogger wtLogger;
        block4: {
            wtLogger = new WTLogger(listener);
            service = new WTRestService();
            envId = null;
            try {
                envId = this.handleEnvName(this.environmentName, service);
            }
            catch (Exception exception) {
                wtLogger.error(exception.getMessage());
                if (!(exception instanceof WTRestException) || ((WTRestException)exception).getCode().equals("100105")) break block4;
                wtLogger.error(exception.getMessage());
            }
        }
        WTDeployEntity entity = WTDeployEntity.from(run, workspace, listener, this.getReleaseName(), this.getReleaseUrl(), this.getSpecifiedWorkItems(), envId, this.tagged);
        wtLogger.info("Will send data to pingcode: " + entity.toString());
        try {
            service.createDeploy(entity);
            wtLogger.info("Create pingcode deploy record successfully.");
        }
        catch (Exception error) {
            wtLogger.error(error.getMessage());
        }
    }

    public String handleEnvName(String name, WTRestService service) throws IOException, WTRestException {
        WTEnvironmentSchema schema = service.getEnvironmentByName(name);
        if (schema == null) {
            schema = service.createEnvironment(new WTEnvironmentEntity(name));
        }
        return schema.id;
    }

    public String getReleaseName() {
        return this.releaseName;
    }

    @DataBoundSetter
    public void setReleaseName(String releaseName) {
        this.releaseName = Util.fixEmptyAndTrim((String)releaseName);
    }

    public String getReleaseUrl() {
        return this.releaseUrl;
    }

    @DataBoundSetter
    public void setReleaseUrl(String releaseUrl) {
        this.releaseUrl = Util.fixEmptyAndTrim((String)releaseUrl);
    }

    public String getSpecifiedWorkItems() {
        return this.specifiedWorkItems;
    }

    @DataBoundSetter
    public void setSpecifiedWorkItems(String specifiedWorkItems) {
        this.specifiedWorkItems = specifiedWorkItems;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    @DataBoundSetter
    public void setEnvironmentName(String environment) {
        this.environmentName = Util.fixEmptyAndTrim((String)environment);
    }

    @Extension
    public static final class Descriptor
    extends BuildStepDescriptor<Publisher> {
        public Descriptor() {
            this.load();
        }

        public boolean isApplicable(@NotNull Class<? extends AbstractProject> item) {
            return true;
        }

        public String getDisplayName() {
            return Messages.PCDeployNotifier_DisplayName();
        }

        public PCDeployNotifier newInstance(StaplerRequest request, @NotNull JSONObject formData) {
            assert (request != null);
            return (PCDeployNotifier)((Object)request.bindJSON(PCDeployNotifier.class, formData));
        }

        public boolean configure(StaplerRequest request, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(request, formData);
        }

        public FormValidation doCheckReleaseName(@QueryParameter(value="releaseName", fixEmpty=true) String releaseName) {
            if (WTHelper.isBlank(releaseName)) {
                return FormValidation.error((String)Messages.PCDeployNotifier_ReleaseNameEmpty());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckEnvironmentName(@QueryParameter(value="environmentName", fixEmpty=true) String environmentName) {
            if (WTHelper.isBlank(environmentName)) {
                return FormValidation.error((String)Messages.PCDeployNotifier_EnvironmentEmpty());
            }
            return FormValidation.ok();
        }
    }
}

