/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.worktile.service;

import io.jenkins.plugins.worktile.MemoryTokenStore;
import io.jenkins.plugins.worktile.WTGlobalConfiguration;
import io.jenkins.plugins.worktile.WTHelper;
import io.jenkins.plugins.worktile.model.WTBuildEntity;
import io.jenkins.plugins.worktile.model.WTDeployEntity;
import io.jenkins.plugins.worktile.model.WTEnvironmentEntity;
import io.jenkins.plugins.worktile.model.WTEnvironmentSchema;
import io.jenkins.plugins.worktile.model.WTPaginationResponse;
import io.jenkins.plugins.worktile.model.WTRestException;
import io.jenkins.plugins.worktile.model.WTTokenEntity;
import io.jenkins.plugins.worktile.resolver.SecretResolver;
import io.jenkins.plugins.worktile.service.WTRestApiService;
import io.jenkins.plugins.worktile.service.WTTokenService;
import java.io.IOException;
import java.util.Objects;
import java.util.logging.Logger;

public class WTRestService {
    private final Logger log = Logger.getLogger(WTRestApiService.class.getName());
    private final WTTokenService tokenService;
    private final String clientId;
    private final String clientSecret;
    private final String baseURL;

    public WTRestService() {
        this(WTHelper.apiV1(WTGlobalConfiguration.get().getEndpoint()), WTGlobalConfiguration.get().getClientId(), SecretResolver.getSecretOf(WTGlobalConfiguration.get().getCredentialsId()).get());
    }

    public WTRestService(String baseURL, String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.baseURL = baseURL;
        this.tokenService = new WTTokenService(baseURL, clientId, clientSecret);
    }

    public void doConnectTest() throws IOException, WTRestException {
        this.tokenService.getTokenFromApi();
    }

    public void createBuild(WTBuildEntity entity) throws IOException, WTRestException {
        this.getWTRestService().createBuild(entity);
    }

    private WTRestApiService getWTRestService() {
        WTTokenEntity token = MemoryTokenStore.get(this.clientId, this.clientSecret);
        if (token == null || token.isExpired()) {
            try {
                token = this.tokenService.getTokenFromApi();
                boolean putResult = MemoryTokenStore.put(this.clientId, this.clientSecret, token);
                this.log.info("[INFO]: put token " + putResult);
            }
            catch (Exception e) {
                this.log.warning("[ERROR]: get token from api error " + e.getMessage());
            }
        }
        return new WTRestApiService(this.baseURL, Objects.requireNonNull(token).accessToken);
    }

    public void createDeploy(WTDeployEntity entity) throws IOException, WTRestException {
        this.getWTRestService().createDeploy(entity);
    }

    public WTPaginationResponse<WTEnvironmentSchema> listEnvironments() throws IOException, WTRestException {
        return this.getWTRestService().listEnvironments();
    }

    public WTEnvironmentSchema getEnvironmentByName(String name) throws IOException, WTRestException {
        return this.getWTRestService().getEnvironmentByName(name);
    }

    public WTEnvironmentSchema deleteEnvironment(String id) throws IOException, WTRestException {
        return this.getWTRestService().deleteEnvironment(id);
    }

    public WTEnvironmentSchema createEnvironment(WTEnvironmentEntity entity) throws IOException, WTRestException {
        return this.getWTRestService().createEnvironment(entity);
    }
}

