/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.wiz;

import hudson.FilePath;
import hudson.model.Run;
import io.jenkins.plugins.wiz.WizInputValidator;
import io.jenkins.plugins.wiz.WizScannerResult;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.RunAction2;

public class WizScannerAction
implements RunAction2 {
    private static final Logger LOGGER = Logger.getLogger(WizScannerAction.class.getName());
    private static final String DEFAULT_ICON = "symbol-wiz plugin-wiz-scanner";
    private static final String BASE_URL_NAME = "wiz-results";
    private static final String DEFAULT_DISPLAY_NAME = "Wiz Scanner";
    private transient Run<?, ?> run;
    private final WizScannerResult scanDetails;
    private final String name;
    private final String artifactSuffix;

    public WizScannerAction(Run<?, ?> build, FilePath workspace, String artifactSuffix, String artifactName) {
        WizInputValidator.validateScanAction(build, workspace, artifactName);
        this.name = artifactSuffix;
        this.artifactSuffix = artifactSuffix;
        this.run = build;
        WizScannerResult loadedDetails = null;
        try {
            FilePath resultsFile = workspace.child(artifactName);
            loadedDetails = this.loadScanDetails(resultsFile);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to load scan details", e);
        }
        this.scanDetails = loadedDetails;
    }

    private WizScannerResult loadScanDetails(FilePath jsonFile) throws IOException, InterruptedException {
        if (!jsonFile.exists()) {
            throw new IOException("Results file does not exist: " + jsonFile.getRemote());
        }
        WizScannerResult result = WizScannerResult.fromJsonFile(jsonFile);
        if (result == null) {
            throw new IOException("Failed to parse scan results from: " + jsonFile.getRemote());
        }
        return result;
    }

    public void onAttached(Run<?, ?> run) {
        this.run = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.run = run;
    }

    public String getIconFileName() {
        return DEFAULT_ICON;
    }

    public String getDisplayName() {
        return this.artifactSuffix == null ? DEFAULT_DISPLAY_NAME : "Wiz Scanner " + this.artifactSuffix;
    }

    public String getUrlName() {
        return this.artifactSuffix == null ? BASE_URL_NAME : "wiz-results-" + this.artifactSuffix;
    }

    public Run<?, ?> getRun() {
        return this.run;
    }

    public String getName() {
        return this.name;
    }

    public WizScannerResult getScanDetails() {
        return this.scanDetails;
    }
}

