/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.wiz;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import hudson.util.Secret;
import io.jenkins.plugins.wiz.WizCliAuthenticator;
import io.jenkins.plugins.wiz.WizCliDownloader;
import io.jenkins.plugins.wiz.WizCliSetup;
import io.jenkins.plugins.wiz.WizCliVersion;
import io.jenkins.plugins.wiz.WizInputValidator;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WizCliRunner {
    private static final Logger LOGGER = Logger.getLogger(WizCliRunner.class.getName());
    private static final String OUTPUT_FILENAME = "wizcli_output";
    private static final String ERROR_FILENAME = "wizcli_err_output";

    public static int execute(FilePath workspace, EnvVars env, Launcher launcher, TaskListener listener, String wizCliURL, String wizClientId, Secret wizSecretKey, String userInput, String artifactName) throws IOException, InterruptedException {
        WizCliSetup cliSetup = null;
        try {
            cliSetup = WizCliDownloader.setupWizCli(workspace, wizCliURL, listener);
            WizCliAuthenticator.authenticate(launcher, workspace, env, wizClientId, wizSecretKey, listener, cliSetup);
            int n = WizCliRunner.executeScan(workspace, env, launcher, listener, userInput, artifactName, cliSetup);
            return n;
        }
        catch (Exception e) {
            throw new AbortException("Error executing Wiz CLI: " + e.getMessage());
        }
        finally {
            if (cliSetup != null) {
                try {
                    int logoutResult = WizCliAuthenticator.logout(launcher, workspace, env, listener, cliSetup);
                    if (logoutResult != 0) {
                        LOGGER.warning("Failed to logout from Wiz CLI. Exit code: " + logoutResult);
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error during Wiz CLI logout", e);
                    listener.error("Warning: Failed to logout from Wiz CLI: " + e.getMessage());
                }
            }
        }
    }

    private static int executeScan(FilePath workspace, EnvVars env, Launcher launcher, TaskListener listener, String userInput, String artifactName, WizCliSetup cliSetup) throws IOException, InterruptedException {
        listener.getLogger().println("Executing Wiz scan...");
        try {
            WizInputValidator.validateCommand(userInput, cliSetup.getVersion());
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.SEVERE, "Command validation failed", e);
            listener.getLogger().println("Error: Invalid command: " + e.getMessage());
            return -1;
        }
        FilePath outputFile = workspace.child(OUTPUT_FILENAME);
        FilePath errorFile = workspace.child(ERROR_FILENAME);
        ArgumentListBuilder scanArgs = WizCliRunner.buildScanArguments(userInput, cliSetup);
        listener.getLogger().println("Executing command: " + String.valueOf(scanArgs));
        int exitCode = WizCliRunner.executeScanProcess(launcher, workspace, env, scanArgs, outputFile, errorFile);
        if (exitCode != 0 && errorFile.exists()) {
            listener.error("Scan failed with error output:");
            listener.getLogger().println(errorFile.readToString());
        }
        WizCliRunner.copyOutputToArtifact(outputFile, workspace, artifactName);
        return exitCode;
    }

    private static ArgumentListBuilder buildScanArguments(String userInput, WizCliSetup cliSetup) {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(cliSetup.getCliCommand());
        if (userInput != null && !userInput.trim().isEmpty()) {
            Pattern pattern = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");
            Matcher matcher = pattern.matcher(userInput.trim());
            while (matcher.find()) {
                String arg = matcher.group();
                if (arg.startsWith("\"") && arg.endsWith("\"") || arg.startsWith("'") && arg.endsWith("'")) {
                    arg = arg.substring(1, arg.length() - 1);
                }
                args.add(arg);
            }
        }
        assert (userInput != null);
        if (cliSetup.getVersion() == WizCliVersion.V0) {
            if (!userInput.contains("-f") && !userInput.contains("--format")) {
                args.add(new String[]{"-f", "json"});
            }
        } else if (!userInput.contains("--stdout")) {
            args.add(new String[]{"--stdout", "json"});
        }
        return args;
    }

    private static int executeScanProcess(Launcher launcher, FilePath workspace, EnvVars env, ArgumentListBuilder args, FilePath outputFile, FilePath errorFile) throws IOException, InterruptedException {
        Launcher.ProcStarter proc = launcher.launch().cmds(args).pwd(workspace).envs((Map)env).stdout(outputFile.write()).stderr(errorFile.write());
        return proc.join();
    }

    private static void copyOutputToArtifact(FilePath outputFile, FilePath workspace, String artifactName) throws IOException, InterruptedException {
        FilePath target = workspace.child(artifactName);
        outputFile.copyTo(target);
    }
}

