/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.wiz;

import io.jenkins.plugins.wiz.WizCliVersion;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParsedWizCliUrl {
    private static final Pattern VERSION_PATH_PATTERN = Pattern.compile("/wizcli/([^/]+)/");
    private final String url;
    private final WizCliVersion version;
    private final boolean latest;

    public ParsedWizCliUrl(String url, WizCliVersion version) {
        this.url = url;
        this.version = version;
        this.latest = ParsedWizCliUrl.detectLatest(url);
    }

    private static boolean detectLatest(String url) {
        Matcher matcher = VERSION_PATH_PATTERN.matcher(url);
        if (matcher.find()) {
            return "latest".equals(matcher.group(1));
        }
        return false;
    }

    public WizCliVersion getVersion() {
        return this.version;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isLatest() {
        return this.latest;
    }

    public String toString() {
        return this.url;
    }
}

