/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.wiz;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;

public class PGPVerifier {
    private static final Logger LOGGER = Logger.getLogger(PGPVerifier.class.getName());

    public boolean verifySignatureFromFiles(String dataPath, String signaturePath, String publicKeyPath) throws PGPVerificationException {
        try {
            LOGGER.log(Level.FINE, "Starting signature verification for file: {0}", dataPath);
            byte[] signedData = this.readFileWithValidation(dataPath, "data");
            byte[] signature = this.readFileWithValidation(signaturePath, "signature");
            byte[] publicKey = this.readFileWithValidation(publicKeyPath, "public key");
            return this.verifySignature(signedData, signature, publicKey);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to read verification files: {0}", e.getMessage());
            throw new PGPVerificationException("Failed to read verification files", e);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Signature verification failed: {0}", e.getMessage());
            throw new PGPVerificationException("Signature verification failed", e);
        }
    }

    private boolean verifySignature(byte[] signedData, byte[] signature, byte[] publicKey) throws PGPVerificationException {
        try {
            this.validateInput(signedData, signature, publicKey);
            PGPPublicKey pgpPublicKey = this.readPublicKey(new ByteArrayInputStream(publicKey));
            PGPSignature pgpSignature = this.readSignature(signature);
            LOGGER.log(Level.FINE, "Verifying signature with key ID: {0}", Long.toHexString(pgpPublicKey.getKeyID()));
            pgpSignature.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), pgpPublicKey);
            pgpSignature.update(signedData);
            boolean result = pgpSignature.verify();
            LOGGER.log(Level.FINE, "Signature verification result: {0}", result);
            return result;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Signature verification failed: {0}", e.getMessage());
            throw new PGPVerificationException("Signature verification failed", e);
        }
    }

    private PGPPublicKey readPublicKey(InputStream input) throws PGPVerificationException {
        PGPPublicKey pGPPublicKey;
        ArmoredInputStream armoredInput = new ArmoredInputStream(input);
        try {
            PGPPublicKeyRingCollection pgpRings = this.readKeyRingCollection(armoredInput);
            pGPPublicKey = this.findSigningKey(pgpRings);
        }
        catch (Throwable throwable) {
            try {
                try {
                    armoredInput.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to read public key: {0}", e.getMessage());
                throw new PGPVerificationException("Failed to read public key", e);
            }
        }
        armoredInput.close();
        return pGPPublicKey;
    }

    private PGPPublicKeyRingCollection readKeyRingCollection(ArmoredInputStream input) throws IOException, PGPException {
        return new PGPPublicKeyRingCollection((InputStream)input, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
    }

    private PGPPublicKey findSigningKey(PGPPublicKeyRingCollection pgpRings) throws PGPVerificationException {
        for (PGPPublicKeyRing keyRing : pgpRings) {
            PGPPublicKey signingKey = this.findSigningKeyInRing(keyRing);
            if (signingKey == null) continue;
            return signingKey;
        }
        throw new PGPVerificationException("No suitable signing key found in provided key ring");
    }

    private PGPPublicKey findSigningKeyInRing(PGPPublicKeyRing keyRing) {
        PGPPublicKey masterKey = keyRing.getPublicKey();
        LOGGER.log(Level.FINE, "Processing keyring with master key: {0}", Long.toHexString(masterKey.getKeyID()));
        Iterator keys = keyRing.getPublicKeys();
        while (keys.hasNext()) {
            PGPPublicKey key = (PGPPublicKey)keys.next();
            if (!this.isValidSigningKey(key)) continue;
            return key;
        }
        return null;
    }

    private boolean isValidSigningKey(PGPPublicKey key) {
        LOGGER.log(Level.FINE, "Examining key: {0}", Long.toHexString(key.getKeyID()));
        Iterator sigs = key.getSignatures();
        while (sigs.hasNext()) {
            if (!this.hasValidSigningFlag(sigs.next(), key)) continue;
            return true;
        }
        return false;
    }

    private boolean hasValidSigningFlag(Object sig, PGPPublicKey key) {
        if (!(sig instanceof PGPSignature)) {
            return false;
        }
        PGPSignature signature = (PGPSignature)sig;
        PGPSignatureSubpacketVector hashedSigs = signature.getHashedSubPackets();
        if (hashedSigs == null) {
            return false;
        }
        int keyFlags = hashedSigs.getKeyFlags();
        LOGGER.log(Level.FINE, "Key flags: {0}", keyFlags);
        if (!key.isMasterKey() && (keyFlags & 2) != 0) {
            LOGGER.log(Level.FINE, "Found suitable signing key");
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PGPSignature readSignature(byte[] signatureContent) throws PGPVerificationException {
        LOGGER.log(Level.FINE, "Reading signature data of size: {0} bytes", signatureContent.length);
        try (ByteArrayInputStream sigStream = new ByteArrayInputStream(signatureContent);){
            PGPSignature signature = this.readBinarySignature(sigStream);
            if (signature != null) {
                PGPSignature pGPSignature = signature;
                return pGPSignature;
            }
            ((InputStream)sigStream).reset();
            signature = this.readArmoredSignature(sigStream);
            if (signature != null) {
                PGPSignature pGPSignature = signature;
                return pGPSignature;
            }
            ((InputStream)sigStream).reset();
            signature = this.readRawSignature(sigStream);
            if (signature == null) throw new PGPVerificationException("Failed to read signature in any supported format");
            PGPSignature pGPSignature = signature;
            return pGPSignature;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error reading signature data: {0}", e.getMessage());
            throw new PGPVerificationException("Error reading signature data", e);
        }
    }

    private PGPSignature readBinarySignature(InputStream sigStream) {
        try {
            JcaPGPObjectFactory pgpFactory = new JcaPGPObjectFactory(sigStream);
            Object obj = pgpFactory.nextObject();
            if (obj instanceof PGPSignatureList) {
                PGPSignatureList sigs = (PGPSignatureList)obj;
                if (!sigs.isEmpty()) {
                    LOGGER.log(Level.FINE, "Successfully read binary signature list");
                    return sigs.get(0);
                }
            } else if (obj instanceof PGPSignature) {
                LOGGER.log(Level.FINE, "Successfully read binary signature");
                return (PGPSignature)obj;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Failed to read binary signature: {0}", e.getMessage());
        }
        return null;
    }

    private PGPSignature readArmoredSignature(InputStream sigStream) {
        try {
            InputStream decoderStream = PGPUtil.getDecoderStream((InputStream)sigStream);
            JcaPGPObjectFactory pgpFactory = new JcaPGPObjectFactory(decoderStream);
            Object obj = pgpFactory.nextObject();
            if (obj instanceof PGPSignatureList) {
                PGPSignatureList sigs = (PGPSignatureList)obj;
                if (!sigs.isEmpty()) {
                    LOGGER.log(Level.FINE, "Successfully read ASCII armored signature list");
                    return sigs.get(0);
                }
            } else if (obj instanceof PGPSignature) {
                LOGGER.log(Level.FINE, "Successfully read ASCII armored signature");
                return (PGPSignature)obj;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Failed to read ASCII armored signature: {0}", e.getMessage());
        }
        return null;
    }

    private PGPSignature readRawSignature(InputStream sigStream) {
        try {
            BCPGInputStream bcpgIn = new BCPGInputStream(sigStream);
            PGPSignature signature = new PGPSignature(bcpgIn);
            LOGGER.log(Level.FINE, "Successfully read raw signature");
            return signature;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Failed to read raw signature: {0}", e.getMessage());
            return null;
        }
    }

    private void validateInput(byte[] signedData, byte[] signature, byte[] publicKey) throws PGPVerificationException {
        if (signedData == null || signedData.length == 0) {
            LOGGER.log(Level.SEVERE, "Signed data validation failed: data is null or empty");
            throw new PGPVerificationException("Signed data is null or empty");
        }
        if (signature == null || signature.length == 0) {
            LOGGER.log(Level.SEVERE, "Signature validation failed: signature is null or empty");
            throw new PGPVerificationException("Signature is null or empty");
        }
        if (publicKey == null || publicKey.length == 0) {
            LOGGER.log(Level.SEVERE, "Public key validation failed: key is null or empty");
            throw new PGPVerificationException("Public key is null or empty");
        }
    }

    private byte[] readFileWithValidation(String path, String fileType) throws IOException {
        if (path == null || path.trim().isEmpty()) {
            LOGGER.log(Level.SEVERE, "Invalid {0} file path: null or empty", fileType);
            throw new IOException(fileType + " path is null or empty");
        }
        try {
            byte[] content = Files.readAllBytes(Paths.get(path, new String[0]));
            if (content.length == 0) {
                LOGGER.log(Level.SEVERE, "Empty {0} file: {1}", new Object[]{fileType, path});
                throw new IOException(fileType + " file is empty");
            }
            LOGGER.log(Level.FINE, "Successfully read {0} file: {1}, size: {2} bytes", new Object[]{fileType, path, content.length});
            return content;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to read {0} file {1}: {2}", new Object[]{fileType, path, e.getMessage()});
            throw new IOException("Failed to read " + fileType + " file: " + path, e);
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public static class PGPVerificationException
    extends Exception {
        public PGPVerificationException(String message) {
            super(message);
        }

        public PGPVerificationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

