/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.webhookexternalstore;

import io.jenkins.plugins.webhookexternalstore.exceptions.CredentialsConvertionException;
import java.util.Map;
import java.util.Objects;
import net.sf.json.JSONObject;

public record WebhookPayload(String id, String description, String type, Map<String, Object> secret) {
    public WebhookPayload(String id, String description, String type, Map<String, Object> secret) {
        this.id = Objects.requireNonNull(id, "id cannot be null");
        this.description = description;
        this.type = Objects.requireNonNull(type, "type cannot be null");
        this.secret = Objects.requireNonNull(secret, "secret cannot be null");
    }

    public static WebhookPayload fromJSON(JSONObject json) throws CredentialsConvertionException {
        String id = json.optString("id", null);
        if (id == null || id.isBlank()) {
            throw new CredentialsConvertionException("Missing required field: id");
        }
        String type = json.optString("type", null);
        if (type == null || type.isBlank()) {
            throw new CredentialsConvertionException("Missing required field: type");
        }
        String description = json.optString("description", null);
        if (description == null || description.isBlank()) {
            throw new CredentialsConvertionException("Missing required field: description");
        }
        JSONObject secretJson = json.optJSONObject("secret");
        if (secretJson == null) {
            throw new CredentialsConvertionException("Missing required object: secret");
        }
        return new WebhookPayload(id, description, type, (Map<String, Object>)secretJson);
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public String getSecretValue(String key) {
        String s;
        Object object = this.secret.get(key);
        return object instanceof String ? (s = (String)object) : null;
    }

    @Override
    public String toString() {
        return "WebhookPayload{type='" + this.type + "', description='" + this.description + "', id='" + this.id + "'}";
    }
}

