/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.webhookexternalstore.converters;

import com.cloudbees.plugins.credentials.common.IdCredentials;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import io.jenkins.plugins.webhookexternalstore.WebhookPayload;
import io.jenkins.plugins.webhookexternalstore.exceptions.CredentialsConvertionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebhookToCredentialConverter
implements ExtensionPoint {
    private static final Logger LOG = LoggerFactory.getLogger(WebhookToCredentialConverter.class);

    public abstract boolean canConvert(String var1);

    public abstract IdCredentials convert(WebhookPayload var1) throws CredentialsConvertionException;

    public static ExtensionList<WebhookToCredentialConverter> all() {
        return ExtensionList.lookup(WebhookToCredentialConverter.class);
    }

    public static WebhookToCredentialConverter lookup(String type) {
        for (WebhookToCredentialConverter converter : WebhookToCredentialConverter.all()) {
            try {
                if (!converter.canConvert(type)) continue;
                LOG.debug("Found converter {} for credential type {}", (Object)converter.getClass().getName(), (Object)type);
                return converter;
            }
            catch (Exception e) {
                LOG.error("Error checking converter {} for type {}: {}", new Object[]{converter.getClass().getName(), type, e.getMessage(), e});
            }
        }
        LOG.info("No converter found for credential type {}", (Object)type);
        return null;
    }

    public static IdCredentials convertFromPayload(WebhookPayload payload) throws CredentialsConvertionException {
        WebhookToCredentialConverter converter = WebhookToCredentialConverter.lookup(payload.getType());
        if (converter == null) {
            throw new CredentialsConvertionException("No converter found for credential type: " + payload.getType());
        }
        try {
            return converter.convert(payload);
        }
        catch (CredentialsConvertionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CredentialsConvertionException("Failed to convert credential of type " + payload.getType() + " with converter " + converter.getClass().getSimpleName(), e);
        }
    }
}

