/*
 * Decompiled with CFR 0.152.
 */
package com.vdoo.vision.plugin;

import com.vdoo.vision.plugin.Messages;
import com.vdoo.vision.plugin.ScannerAction;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.IOException;
import java.net.URL;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ScannerBuilder
extends Builder
implements SimpleBuildStep {
    private Secret vdooToken;
    private String failThreshold;
    private String maxHighlightedIssues;
    private String maxHighlightedExposures;
    private String maxHighlightedCVEs;
    private String maxMaliciousFiles;
    private Integer productId;
    private String firmwareLocation;
    private Boolean waitForResults;
    private String baseApi;

    @DataBoundConstructor
    public ScannerBuilder() {
    }

    public Secret getVdooToken() {
        return this.vdooToken;
    }

    public String getFailThreshold() {
        return this.failThreshold;
    }

    public String getMaxHighlightedIssues() {
        return this.maxHighlightedIssues;
    }

    public String getMaxHighlightedExposures() {
        return this.maxHighlightedExposures;
    }

    public String getMaxHighlightedCVEs() {
        return this.maxHighlightedCVEs;
    }

    public String getMaxMaliciousFiles() {
        return this.maxMaliciousFiles;
    }

    public Integer getProductId() {
        return this.productId;
    }

    public String getFirmwareLocation() {
        return this.firmwareLocation;
    }

    public String getBaseApi() {
        return this.baseApi;
    }

    @DataBoundSetter
    public void setBaseApi(String baseApi) {
        this.baseApi = baseApi;
    }

    public Boolean getWaitForResults() {
        return this.waitForResults;
    }

    @DataBoundSetter
    public void setWaitForResults(Boolean waitForResults) {
        this.waitForResults = waitForResults;
    }

    @DataBoundSetter
    public void setFailThreshold(String failThreshold) {
        this.failThreshold = failThreshold;
    }

    @DataBoundSetter
    public void setMaxHighlightedIssues(String maxHighlightedIssues) {
        this.maxHighlightedIssues = maxHighlightedIssues;
    }

    @DataBoundSetter
    public void setMaxHighlightedExposures(String maxHighlightedExposures) {
        this.maxHighlightedExposures = maxHighlightedExposures;
    }

    @DataBoundSetter
    public void setMaxHighlightedCVEs(String maxHighlightedCVEs) {
        this.maxHighlightedCVEs = maxHighlightedCVEs;
    }

    @DataBoundSetter
    public void setMaliciousFiles(String maxMaliciousFiles) {
        this.maxMaliciousFiles = maxMaliciousFiles;
    }

    @DataBoundSetter
    public void setProductId(String productId) {
        this.productId = Integer.parseInt(productId);
    }

    @DataBoundSetter
    public void setFirmwareLocation(String firmwareLocation) {
        this.firmwareLocation = firmwareLocation;
    }

    @DataBoundSetter
    public void setVdooToken(Secret vdooToken) {
        this.vdooToken = vdooToken;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        run.addAction((Action)new ScannerAction(this.vdooToken, this.failThreshold, this.maxHighlightedIssues, this.maxHighlightedExposures, this.maxHighlightedCVEs, this.maxMaliciousFiles, this.productId, this.firmwareLocation, this.baseApi, this.waitForResults, listener.getLogger(), run));
    }

    @Symbol(value={"vdooScan"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public FormValidation doCheckProductId(@QueryParameter String productId) {
            if (productId == null || productId.equals("")) {
                return FormValidation.error((String)Messages.ScannerBuilder_DescriptorImpl_ProductIdEmpty());
            }
            try {
                int productIdNum = Integer.parseInt(productId);
                if (productIdNum < 1) {
                    return FormValidation.error((String)Messages.ScannerBuilder_DescriptorImpl_PositiveNumber());
                }
            }
            catch (NumberFormatException nfe) {
                return FormValidation.error((String)Messages.ScannerBuilder_DescriptorImpl_ProductIdNumber());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckFirmwareLocation(@QueryParameter String firmwareLocation) {
            if (firmwareLocation == null || firmwareLocation.equals("")) {
                return FormValidation.error((String)Messages.ScannerBuilder_DescriptorImpl_FirmwareLocationEmpty());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckVdooToken(@QueryParameter Secret vdooToken) {
            if (vdooToken == null || vdooToken.getPlainText().equals("")) {
                return FormValidation.error((String)Messages.ScannerBuilder_DescriptorImpl_VdooTokenEmpty());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckBaseApi(@QueryParameter String baseApi) {
            if (baseApi == null || baseApi.equals("")) {
                return FormValidation.error((String)Messages.ScannerBuilder_DescriptorImpl_BaseAPIEmpty());
            }
            try {
                URL baseApiURL = new URL(baseApi);
                if (baseApiURL.getProtocol().equals("https")) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)Messages.ScannerBuilder_DescriptorImpl_BaseAPIHttp());
            }
            catch (Exception e) {
                return FormValidation.error((String)Messages.ScannerBuilder_DescriptorImpl_BaseAPIInvalid());
            }
        }

        public FormValidation doCheckMaxHighlightedIssues(@QueryParameter String maxHighlightedIssues) {
            if (maxHighlightedIssues == null || maxHighlightedIssues.equals("")) {
                return FormValidation.ok();
            }
            try {
                int maxHighlightedIssuesNum = Integer.parseInt(maxHighlightedIssues);
                if (maxHighlightedIssuesNum < 0) {
                    return FormValidation.error((String)Messages.ScannerBuilder_DescriptorImpl_PositiveNumber());
                }
            }
            catch (NumberFormatException nfe) {
                return FormValidation.error((String)Messages.ScannerBuilder_DescriptorImpl_MaxNumber());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckMaxHighlightedExposures(@QueryParameter String maxHighlightedExposures) {
            if (maxHighlightedExposures == null || maxHighlightedExposures.equals("")) {
                return FormValidation.ok();
            }
            try {
                int maxHighlightedExposuresNum = Integer.parseInt(maxHighlightedExposures);
                if (maxHighlightedExposuresNum < 0) {
                    return FormValidation.error((String)Messages.ScannerBuilder_DescriptorImpl_PositiveNumber());
                }
            }
            catch (NumberFormatException nfe) {
                return FormValidation.error((String)Messages.ScannerBuilder_DescriptorImpl_MaxNumber());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckMaxHighlightedCVEs(@QueryParameter String maxHighlightedCVEs) {
            if (maxHighlightedCVEs == null || maxHighlightedCVEs.equals("")) {
                return FormValidation.ok();
            }
            try {
                int maxHighlightedCVEsNum = Integer.parseInt(maxHighlightedCVEs);
                if (maxHighlightedCVEsNum < 0) {
                    return FormValidation.error((String)Messages.ScannerBuilder_DescriptorImpl_PositiveNumber());
                }
            }
            catch (NumberFormatException nfe) {
                return FormValidation.error((String)Messages.ScannerBuilder_DescriptorImpl_MaxNumber());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckMaxMaliciousFiles(@QueryParameter String maxMaliciousFiles) {
            if (maxMaliciousFiles == null || maxMaliciousFiles.equals("")) {
                return FormValidation.ok();
            }
            try {
                int maxMaliciousFilesNum = Integer.parseInt(maxMaliciousFiles);
                if (maxMaliciousFilesNum < 0) {
                    return FormValidation.error((String)Messages.ScannerBuilder_DescriptorImpl_PositiveNumber());
                }
            }
            catch (NumberFormatException nfe) {
                return FormValidation.error((String)Messages.ScannerBuilder_DescriptorImpl_MaxNumber());
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.ScannerBuilder_DescriptorImpl_DisplayName();
        }
    }
}

