/*
 * Decompiled with CFR 0.152.
 */
package com.vdoo.vision.plugin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vdoo.sdk.VdooSDK;
import com.vdoo.vision.plugin.Messages;
import hudson.AbortException;
import hudson.model.Run;
import hudson.util.Secret;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Scanner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkins.model.RunAction2;

public class ScannerAction
implements RunAction2 {
    public static final String REPORT_DIRECTORY_NAME = "VdooVision";
    private Secret vdooToken;
    private String failThreshold;
    private String maxHighlightedIssues;
    private String maxHighlightedExposures;
    private String maxHighlightedCVEs;
    private String maxMaliciousFiles;
    private String baseApi;
    private String firmwareLocation;
    private Integer artifactId;
    private String firmwareUUID;
    private Boolean waitForResults;
    private String reportLink;
    private String fwName;
    private transient JsonNode analysisResults;
    private transient JsonNode highlightedIssues;
    private transient JsonNode statusJson;
    private transient Map<String, Integer> statusToInt;
    private transient String defaultBaseApi = "https://prod.vdoo.io";
    private transient Run run;

    public ScannerAction(Secret vdooToken, String failThreshold, String maxHighlightedIssues, String maxHighlightedExposures, String maxHighlightedCVEs, String maxMaliciousFiles, Integer artifactId, String firmwareLocation, String baseApi, Boolean waitForResults, PrintStream logger, Run<?, ?> run) throws IOException, InterruptedException {
        this.vdooToken = vdooToken;
        if (vdooToken == null || vdooToken.getPlainText().equals("")) {
            throw new AbortException(Messages.ScannerAction_TokenEmptyError());
        }
        this.failThreshold = failThreshold;
        this.maxHighlightedIssues = maxHighlightedIssues;
        this.maxHighlightedExposures = maxHighlightedExposures;
        this.maxHighlightedCVEs = maxHighlightedCVEs;
        this.maxMaliciousFiles = maxMaliciousFiles;
        this.waitForResults = waitForResults;
        this.baseApi = baseApi;
        if (baseApi == null || baseApi.equals("")) {
            this.baseApi = this.defaultBaseApi;
        }
        if (this.baseApi.endsWith("/")) {
            this.baseApi = this.baseApi.substring(0, this.baseApi.length() - 1);
        }
        this.artifactId = artifactId;
        if (this.artifactId == null) {
            throw new AbortException(Messages.ScannerAction_ProductError());
        }
        this.firmwareLocation = firmwareLocation;
        this.run = run;
        this.statusToInt = Stream.of({"None", 20}, {"Very High", 10}, {"High", 8}, {"Medium", 6}, {"Low", 4}, {"Very Low", 2}).collect(Collectors.toMap(data -> (String)data[0], data -> (Integer)data[1]));
        File file = new File(this.firmwareLocation);
        if (!file.exists()) {
            throw new AbortException(String.format(Messages.ScannerAction_FirmwareFileMissing(), this.firmwareLocation));
        }
        VdooSDK sdk = new VdooSDK();
        this.firmwareUUID = sdk.analyzeImage(this.baseApi, String.valueOf(this.artifactId), file.getName(), this.firmwareLocation, vdooToken.getPlainText());
        logger.println(String.format(Messages.ScannerAction_FirmwareUploadSuccess(), this.firmwareUUID));
        if (!waitForResults.booleanValue()) {
            logger.println(Messages.ScannerAction_NotWaitingForResults());
            return;
        }
        String status = this.waitForEndStatus(logger);
        boolean didFail = false;
        String failReason = "";
        if (status.equals("Failure")) {
            failReason = this.statusJson.get("analysis_status").get("current").get("error_code").textValue();
            didFail = true;
        }
        if (status.equals("timeout")) {
            failReason = status;
            didFail = true;
        }
        if (didFail) {
            String failMessage = String.format(Messages.ScannerAction_FirmwareScanFailure(), failReason, this.firmwareUUID);
            logger.println(failMessage);
            throw new AbortException(failMessage);
        }
        this.saveReportArtifact(logger);
        this.saveReportAttributesInJobFile();
        this.checkThresholds();
        logger.println(Messages.ScannerAction_ScanFinished());
    }

    private void saveReportAttributesInJobFile() {
        this.setReportLink();
        this.setFwName();
    }

    private boolean isThresholdPassed(String threshold, int actual) {
        int intThreshold;
        return threshold != null && !threshold.equals("") && actual > (intThreshold = Integer.parseInt(threshold));
    }

    private void checkThresholds() throws AbortException {
        String failMessage = null;
        if (this.statusToInt.get(this.getThreatLevel()) >= this.statusToInt.get(this.failThreshold)) {
            failMessage = String.format(Messages.ScannerAction_ThreatLevelThresholdPassed(), this.getThreatLevel(), this.failThreshold);
        } else if (this.isThresholdPassed(this.maxHighlightedIssues, this.getHighlightedIssuesCount())) {
            failMessage = String.format(Messages.ScannerAction_HighlightedIssuesThresholdPassed(), this.getHighlightedIssuesCount(), this.maxHighlightedIssues);
        } else if (this.isThresholdPassed(this.maxHighlightedExposures, this.getHighlightedExposuresCount())) {
            failMessage = String.format(Messages.ScannerAction_HighlightedExposuresThresholdPassed(), this.getHighlightedExposuresCount(), this.maxHighlightedExposures);
        } else if (this.isThresholdPassed(this.maxHighlightedCVEs, this.getHighlightedCVEsCount())) {
            failMessage = String.format(Messages.ScannerAction_HighlightedCvesThresholdPassed(), this.getHighlightedCVEsCount(), this.maxHighlightedCVEs);
        } else if (this.isThresholdPassed(this.maxMaliciousFiles, this.getMaliciousFiles())) {
            failMessage = String.format(Messages.ScannerAction_MaliciousFilesThresholdPassed(), this.getMaliciousFiles(), this.maxMaliciousFiles);
        }
        if (failMessage != null) {
            throw new AbortException(failMessage);
        }
    }

    private Boolean saveReportArtifact(PrintStream logger) throws IOException {
        File artifactDir = new File(this.run.getArtifactsDir(), REPORT_DIRECTORY_NAME + this.run.getQueueId());
        Boolean wasArtifactDirCreated = artifactDir.mkdirs();
        if (wasArtifactDirCreated.booleanValue()) {
            JsonNode analysisResults = this.dumpReportPart(artifactDir, "analysis_results", false);
            JsonNode highlightedIssues = this.dumpReportPart(artifactDir, "highlighted_issues", false);
            JsonNode softwareComponents = this.dumpReportPart(artifactDir, "software_components", true);
            JsonNode hardwareComponents = this.dumpReportPart(artifactDir, "hardware_components", true);
            JsonNode cves = this.dumpReportPart(artifactDir, "cves", true);
            JsonNode exposures = this.dumpReportPart(artifactDir, "exposures", true);
            JsonNode maliciousFiles = this.dumpReportPart(artifactDir, "malicious_files", true);
            JsonNode zero_days = this.dumpReportPart(artifactDir, "potential_zero_days/zero_days", true);
            JsonNode weaknesses = this.dumpReportPart(artifactDir, "potential_zero_days/weaknesses", true);
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode aggregatedReport = mapper.createObjectNode();
            aggregatedReport.set("analysis_summary", analysisResults);
            aggregatedReport.set("highlighted_issues", highlightedIssues);
            ObjectNode components = mapper.createObjectNode();
            aggregatedReport.set("components", (JsonNode)components);
            components.set("software_components", softwareComponents);
            components.set("hardware_components", hardwareComponents);
            ObjectNode allSecurityIssues = mapper.createObjectNode();
            aggregatedReport.set("all_security_issues", (JsonNode)allSecurityIssues);
            allSecurityIssues.set("exposures", exposures);
            allSecurityIssues.set("cves", cves);
            allSecurityIssues.set("zero_days", zero_days);
            allSecurityIssues.set("weaknesses", weaknesses);
            allSecurityIssues.set("malicious_files", maliciousFiles);
            File path = new File(artifactDir, "all_findings.json");
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(path.toString()), "UTF-8");
            writer.write(aggregatedReport.toPrettyString());
            ((Writer)writer).close();
            this.analysisResults = analysisResults;
            this.highlightedIssues = highlightedIssues;
        } else {
            logger.println(Messages.ScannerAction_ArtifactFailed());
        }
        return wasArtifactDirCreated;
    }

    private ArrayNode buildReportPartJson(String report_part_name) throws IOException {
        JsonNode reportPart = this.callUrl("/v3/images/" + this.firmwareUUID + "/" + report_part_name, "GET", null);
        if (reportPart.get("next") == null) {
            ArrayNode an = JsonNodeFactory.instance.arrayNode();
            an.add(reportPart);
            return an;
        }
        String next_page_url = reportPart.get("next").asText();
        ArrayNode report = (ArrayNode)reportPart.get("results");
        while (!next_page_url.equals("null")) {
            reportPart = this.callUrl(next_page_url, "GET", null);
            report.addAll((ArrayNode)reportPart.get("results"));
            next_page_url = reportPart.get("next").asText();
        }
        return report;
    }

    private JsonNode dumpReportPart(File artifactDir, String reportPartName, boolean isArray) throws IOException {
        String filename = reportPartName.replace("potential_zero_days/", "");
        File path = new File(artifactDir, filename + ".json");
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(path.toString()), "UTF-8");
        ArrayNode reportJson = this.buildReportPartJson(reportPartName);
        ArrayNode ret = isArray ? reportJson : reportJson.get(0);
        writer.write(ret.toPrettyString());
        ((Writer)writer).close();
        return ret;
    }

    private String waitForEndStatus(PrintStream logger) throws IOException, InterruptedException {
        int maxTries = 60;
        int currentTry = 0;
        while (currentTry < maxTries) {
            ++currentTry;
            this.statusJson = this.callUrl("/v3/images/" + this.firmwareUUID + "/scan_status/", "GET", null);
            String status = this.statusJson.get("analysis_status").get("current").get("name").textValue();
            if (status.equals("Success") || status.equals("Failure")) {
                return status;
            }
            if (currentTry == 1) {
                logger.println(String.format(Messages.ScannerAction_ScanWaitMinute(), currentTry, status));
            } else {
                logger.println(String.format(Messages.ScannerAction_ScanWaitMinutes(), currentTry, status));
            }
            Thread.sleep(60000L);
        }
        return "timeout";
    }

    private JsonNode callUrl(String urlString, String method, String postParams) throws IOException {
        if (!urlString.startsWith("http")) {
            urlString = this.baseApi + urlString;
        }
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("accept", "application/json");
        connection.setRequestProperty("Authorization", "Token " + this.vdooToken.getPlainText());
        HttpURLConnection http = connection;
        http.setConnectTimeout(5000);
        http.setRequestMethod(method);
        http.setDoOutput(true);
        if (postParams != null) {
            byte[] postData = postParams.getBytes(StandardCharsets.UTF_8);
            int postDataLength = postData.length;
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("charset", "utf-8");
            connection.setRequestProperty("Content-Length", Integer.toString(postDataLength));
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.write(postData);
            wr.close();
        }
        try {
            InputStream responseStream = connection.getInputStream();
            Scanner s = new Scanner(responseStream, "UTF-8").useDelimiter("\\A");
            String result = s.hasNext() ? s.next() : "";
            ObjectMapper mapper = new ObjectMapper();
            return mapper.readTree(result);
        }
        catch (IOException e) {
            InputStream responseStream = connection.getErrorStream();
            if (responseStream == null) {
                String error_code = String.valueOf(connection.getResponseCode());
                throw new AbortException("Calling url " + urlString + " returned an error status code: " + error_code);
            }
            Scanner s = new Scanner(responseStream, "UTF-8").useDelimiter("\\A");
            String result = s.hasNext() ? s.next() : "";
            ObjectMapper mapper = new ObjectMapper();
            String error = "Calling url " + urlString + " returned an error:" + mapper.readTree(result).toString();
            throw new AbortException(error);
        }
    }

    public String getIconFileName() {
        return "document.png";
    }

    public String getDisplayName() {
        return "Vdoo Scan Report";
    }

    public String getUrlName() {
        return "vdoo-report";
    }

    public String getArtifactName() {
        return this.analysisResults.get("artifact_name").textValue();
    }

    public String getFwName() {
        if (this.fwName == null) {
            return this.analysisResults.get("name").textValue();
        }
        return this.fwName;
    }

    public void setFwName() {
        if (this.fwName == null) {
            this.fwName = this.analysisResults.get("name").textValue();
        }
    }

    public String getReportLink() {
        if (this.reportLink == null) {
            this.reportLink = this.analysisResults.get("report_link").textValue();
        }
        return this.reportLink;
    }

    public void setReportLink() {
        if (this.reportLink == null) {
            this.reportLink = this.analysisResults.get("report_link").textValue();
        }
    }

    public Secret getVdooToken() {
        return this.vdooToken;
    }

    public String getFirmwareUUID() {
        return this.firmwareUUID;
    }

    public String getThreatLevel() {
        return this.analysisResults.get("threat_level").textValue();
    }

    public int getHighlightedIssuesCount() {
        return this.getHighlightedExposuresCount() + this.getHighlightedCVEsCount() + this.getMaliciousFiles();
    }

    public int getHighlightedExposuresCount() {
        return this.highlightedIssues.get("exposures").size();
    }

    public int getHighlightedCVEsCount() {
        return this.highlightedIssues.get("cves").size();
    }

    public int getMaliciousFiles() {
        return this.highlightedIssues.get("malicious_files").size();
    }

    public Boolean getWaitForResults() {
        return this.waitForResults;
    }

    public void onAttached(Run<?, ?> run) {
        this.run = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.run = run;
    }

    public Run getRun() {
        return this.run;
    }
}

