// CHECKSTYLE:OFF

package com.vdoo.vision.plugin;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code ScannerAction.HighlightedExposuresThresholdPassed}: {@code
     * [Vdoo Vision Scanner] Number of highlighted exposures (%d) exceeds the
     * defined threshold (%s), failing build.}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Number of highlighted exposures (%d)
     *     exceeds the defined threshold (%s), failing build.}
     */
    public static String ScannerAction_HighlightedExposuresThresholdPassed() {
        return holder.format("ScannerAction.HighlightedExposuresThresholdPassed");
    }

    /**
     * Key {@code ScannerAction.HighlightedExposuresThresholdPassed}: {@code
     * [Vdoo Vision Scanner] Number of highlighted exposures (%d) exceeds the
     * defined threshold (%s), failing build.}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Number of highlighted exposures (%d)
     *     exceeds the defined threshold (%s), failing build.}
     */
    public static Localizable _ScannerAction_HighlightedExposuresThresholdPassed() {
        return new Localizable(holder, "ScannerAction.HighlightedExposuresThresholdPassed");
    }

    /**
     * Key {@code ScannerAction.ProductError}: {@code [Vdoo Vision Scanner]
     * Configured artifact ID is empty. Please fix your configuration.}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Configured artifact ID is empty. Please
     *     fix your configuration.}
     */
    public static String ScannerAction_ProductError() {
        return holder.format("ScannerAction.ProductError");
    }

    /**
     * Key {@code ScannerAction.ProductError}: {@code [Vdoo Vision Scanner]
     * Configured artifact ID is empty. Please fix your configuration.}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Configured artifact ID is empty. Please
     *     fix your configuration.}
     */
    public static Localizable _ScannerAction_ProductError() {
        return new Localizable(holder, "ScannerAction.ProductError");
    }

    /**
     * Key {@code ScannerBuilder.DescriptorImpl.BaseAPIInvalid}: {@code Base
     * API URL must be a valid URL.}.
     * 
     * @return
     *     {@code Base API URL must be a valid URL.}
     */
    public static String ScannerBuilder_DescriptorImpl_BaseAPIInvalid() {
        return holder.format("ScannerBuilder.DescriptorImpl.BaseAPIInvalid");
    }

    /**
     * Key {@code ScannerBuilder.DescriptorImpl.BaseAPIInvalid}: {@code Base
     * API URL must be a valid URL.}.
     * 
     * @return
     *     {@code Base API URL must be a valid URL.}
     */
    public static Localizable _ScannerBuilder_DescriptorImpl_BaseAPIInvalid() {
        return new Localizable(holder, "ScannerBuilder.DescriptorImpl.BaseAPIInvalid");
    }

    /**
     * Key {@code ScannerAction.ArtifactFailed}: {@code [Vdoo Vision Scanner]
     * Couldn't create artifact directory. Artifacts won't be saved.}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Couldn't create artifact directory.
     *     Artifacts won't be saved.}
     */
    public static String ScannerAction_ArtifactFailed() {
        return holder.format("ScannerAction.ArtifactFailed");
    }

    /**
     * Key {@code ScannerAction.ArtifactFailed}: {@code [Vdoo Vision Scanner]
     * Couldn't create artifact directory. Artifacts won't be saved.}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Couldn't create artifact directory.
     *     Artifacts won't be saved.}
     */
    public static Localizable _ScannerAction_ArtifactFailed() {
        return new Localizable(holder, "ScannerAction.ArtifactFailed");
    }

    /**
     * Key {@code ScannerAction.FirmwareUploadSuccess}: {@code [Vdoo Vision
     * Scanner] Image uploaded successfully. Image UUID: %s}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Image uploaded successfully. Image UUID:
     *     %s}
     */
    public static String ScannerAction_FirmwareUploadSuccess() {
        return holder.format("ScannerAction.FirmwareUploadSuccess");
    }

    /**
     * Key {@code ScannerAction.FirmwareUploadSuccess}: {@code [Vdoo Vision
     * Scanner] Image uploaded successfully. Image UUID: %s}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Image uploaded successfully. Image UUID:
     *     %s}
     */
    public static Localizable _ScannerAction_FirmwareUploadSuccess() {
        return new Localizable(holder, "ScannerAction.FirmwareUploadSuccess");
    }

    /**
     * Key {@code ScannerBuilder.DescriptorImpl.BaseAPIHttp}: {@code Base API
     * URL must be HTTPS.}.
     * 
     * @return
     *     {@code Base API URL must be HTTPS.}
     */
    public static String ScannerBuilder_DescriptorImpl_BaseAPIHttp() {
        return holder.format("ScannerBuilder.DescriptorImpl.BaseAPIHttp");
    }

    /**
     * Key {@code ScannerBuilder.DescriptorImpl.BaseAPIHttp}: {@code Base API
     * URL must be HTTPS.}.
     * 
     * @return
     *     {@code Base API URL must be HTTPS.}
     */
    public static Localizable _ScannerBuilder_DescriptorImpl_BaseAPIHttp() {
        return new Localizable(holder, "ScannerBuilder.DescriptorImpl.BaseAPIHttp");
    }

    /**
     * Key {@code ScannerAction.FirmwareScanFailure}: {@code [Vdoo Vision
     * Scanner] Vision failed to scan the image. Reason: %s. Contact support
     * for further details. Image UUID: %s}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Vision failed to scan the image. Reason:
     *     %s. Contact support for further details. Image UUID: %s}
     */
    public static String ScannerAction_FirmwareScanFailure() {
        return holder.format("ScannerAction.FirmwareScanFailure");
    }

    /**
     * Key {@code ScannerAction.FirmwareScanFailure}: {@code [Vdoo Vision
     * Scanner] Vision failed to scan the image. Reason: %s. Contact support
     * for further details. Image UUID: %s}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Vision failed to scan the image. Reason:
     *     %s. Contact support for further details. Image UUID: %s}
     */
    public static Localizable _ScannerAction_FirmwareScanFailure() {
        return new Localizable(holder, "ScannerAction.FirmwareScanFailure");
    }

    /**
     * Key {@code ScannerBuilder.DescriptorImpl.DisplayName}: {@code Vdoo
     * Vision Scanner}.
     * 
     * @return
     *     {@code Vdoo Vision Scanner}
     */
    public static String ScannerBuilder_DescriptorImpl_DisplayName() {
        return holder.format("ScannerBuilder.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code ScannerBuilder.DescriptorImpl.DisplayName}: {@code Vdoo
     * Vision Scanner}.
     * 
     * @return
     *     {@code Vdoo Vision Scanner}
     */
    public static Localizable _ScannerBuilder_DescriptorImpl_DisplayName() {
        return new Localizable(holder, "ScannerBuilder.DescriptorImpl.DisplayName");
    }

    /**
     * Key {@code ScannerAction.MaliciousFilesThresholdPassed}: {@code [Vdoo
     * Vision Scanner] Number of malicious files (%d) exceeds the defined
     * threshold (%s), failing build.}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Number of malicious files (%d) exceeds
     *     the defined threshold (%s), failing build.}
     */
    public static String ScannerAction_MaliciousFilesThresholdPassed() {
        return holder.format("ScannerAction.MaliciousFilesThresholdPassed");
    }

    /**
     * Key {@code ScannerAction.MaliciousFilesThresholdPassed}: {@code [Vdoo
     * Vision Scanner] Number of malicious files (%d) exceeds the defined
     * threshold (%s), failing build.}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Number of malicious files (%d) exceeds
     *     the defined threshold (%s), failing build.}
     */
    public static Localizable _ScannerAction_MaliciousFilesThresholdPassed() {
        return new Localizable(holder, "ScannerAction.MaliciousFilesThresholdPassed");
    }

    /**
     * Key {@code ScannerBuilder.DescriptorImpl.ProductIdNumber}: {@code
     * Artifact ID must be a number.}.
     * 
     * @return
     *     {@code Artifact ID must be a number.}
     */
    public static String ScannerBuilder_DescriptorImpl_ProductIdNumber() {
        return holder.format("ScannerBuilder.DescriptorImpl.ProductIdNumber");
    }

    /**
     * Key {@code ScannerBuilder.DescriptorImpl.ProductIdNumber}: {@code
     * Artifact ID must be a number.}.
     * 
     * @return
     *     {@code Artifact ID must be a number.}
     */
    public static Localizable _ScannerBuilder_DescriptorImpl_ProductIdNumber() {
        return new Localizable(holder, "ScannerBuilder.DescriptorImpl.ProductIdNumber");
    }

    /**
     * Key {@code ScannerAction.NotWaitingForResults}: {@code [Vdoo Vision
     * Scanner] Not waiting for results. Please check your Vision UI for
     * results.}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Not waiting for results. Please check
     *     your Vision UI for results.}
     */
    public static String ScannerAction_NotWaitingForResults() {
        return holder.format("ScannerAction.NotWaitingForResults");
    }

    /**
     * Key {@code ScannerAction.NotWaitingForResults}: {@code [Vdoo Vision
     * Scanner] Not waiting for results. Please check your Vision UI for
     * results.}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Not waiting for results. Please check
     *     your Vision UI for results.}
     */
    public static Localizable _ScannerAction_NotWaitingForResults() {
        return new Localizable(holder, "ScannerAction.NotWaitingForResults");
    }

    /**
     * Key {@code ScannerAction.ScanWaitMinutes}: {@code [Vdoo Vision
     * Scanner] Waiting for results (%s minutes). Current status: %s.}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Waiting for results (%s minutes). Current
     *     status: %s.}
     */
    public static String ScannerAction_ScanWaitMinutes() {
        return holder.format("ScannerAction.ScanWaitMinutes");
    }

    /**
     * Key {@code ScannerAction.ScanWaitMinutes}: {@code [Vdoo Vision
     * Scanner] Waiting for results (%s minutes). Current status: %s.}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Waiting for results (%s minutes). Current
     *     status: %s.}
     */
    public static Localizable _ScannerAction_ScanWaitMinutes() {
        return new Localizable(holder, "ScannerAction.ScanWaitMinutes");
    }

    /**
     * Key {@code ScannerAction.TokenEmptyError}: {@code [Vdoo Vision
     * Scanner] Configured Vision API token is empty. Please fix your
     * configuration.}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Configured Vision API token is empty.
     *     Please fix your configuration.}
     */
    public static String ScannerAction_TokenEmptyError() {
        return holder.format("ScannerAction.TokenEmptyError");
    }

    /**
     * Key {@code ScannerAction.TokenEmptyError}: {@code [Vdoo Vision
     * Scanner] Configured Vision API token is empty. Please fix your
     * configuration.}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Configured Vision API token is empty.
     *     Please fix your configuration.}
     */
    public static Localizable _ScannerAction_TokenEmptyError() {
        return new Localizable(holder, "ScannerAction.TokenEmptyError");
    }

    /**
     * Key {@code ScannerBuilder.DescriptorImpl.ProductIdEmpty}: {@code
     * Artifact ID can not be empty or null.}.
     * 
     * @return
     *     {@code Artifact ID can not be empty or null.}
     */
    public static String ScannerBuilder_DescriptorImpl_ProductIdEmpty() {
        return holder.format("ScannerBuilder.DescriptorImpl.ProductIdEmpty");
    }

    /**
     * Key {@code ScannerBuilder.DescriptorImpl.ProductIdEmpty}: {@code
     * Artifact ID can not be empty or null.}.
     * 
     * @return
     *     {@code Artifact ID can not be empty or null.}
     */
    public static Localizable _ScannerBuilder_DescriptorImpl_ProductIdEmpty() {
        return new Localizable(holder, "ScannerBuilder.DescriptorImpl.ProductIdEmpty");
    }

    /**
     * Key {@code ScannerBuilder.DescriptorImpl.BaseAPIEmpty}: {@code Base
     * API URL can not be empty or null.}.
     * 
     * @return
     *     {@code Base API URL can not be empty or null.}
     */
    public static String ScannerBuilder_DescriptorImpl_BaseAPIEmpty() {
        return holder.format("ScannerBuilder.DescriptorImpl.BaseAPIEmpty");
    }

    /**
     * Key {@code ScannerBuilder.DescriptorImpl.BaseAPIEmpty}: {@code Base
     * API URL can not be empty or null.}.
     * 
     * @return
     *     {@code Base API URL can not be empty or null.}
     */
    public static Localizable _ScannerBuilder_DescriptorImpl_BaseAPIEmpty() {
        return new Localizable(holder, "ScannerBuilder.DescriptorImpl.BaseAPIEmpty");
    }

    /**
     * Key {@code ScannerAction.HighlightedCvesThresholdPassed}: {@code [Vdoo
     * Vision Scanner] Number of highlighted CVEs (%d) exceeds the defined
     * threshold (%s), failing build.}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Number of highlighted CVEs (%d) exceeds
     *     the defined threshold (%s), failing build.}
     */
    public static String ScannerAction_HighlightedCvesThresholdPassed() {
        return holder.format("ScannerAction.HighlightedCvesThresholdPassed");
    }

    /**
     * Key {@code ScannerAction.HighlightedCvesThresholdPassed}: {@code [Vdoo
     * Vision Scanner] Number of highlighted CVEs (%d) exceeds the defined
     * threshold (%s), failing build.}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Number of highlighted CVEs (%d) exceeds
     *     the defined threshold (%s), failing build.}
     */
    public static Localizable _ScannerAction_HighlightedCvesThresholdPassed() {
        return new Localizable(holder, "ScannerAction.HighlightedCvesThresholdPassed");
    }

    /**
     * Key {@code ScannerBuilder.DescriptorImpl.MaxNumber}: {@code Field
     * value must be a number}.
     * 
     * @return
     *     {@code Field value must be a number}
     */
    public static String ScannerBuilder_DescriptorImpl_MaxNumber() {
        return holder.format("ScannerBuilder.DescriptorImpl.MaxNumber");
    }

    /**
     * Key {@code ScannerBuilder.DescriptorImpl.MaxNumber}: {@code Field
     * value must be a number}.
     * 
     * @return
     *     {@code Field value must be a number}
     */
    public static Localizable _ScannerBuilder_DescriptorImpl_MaxNumber() {
        return new Localizable(holder, "ScannerBuilder.DescriptorImpl.MaxNumber");
    }

    /**
     * Key {@code ScannerAction.FirmwareFileMissing}: {@code [Vdoo Vision
     * Scanner] Configured image file doesn't exist: %s}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Configured image file doesn't exist: %s}
     */
    public static String ScannerAction_FirmwareFileMissing() {
        return holder.format("ScannerAction.FirmwareFileMissing");
    }

    /**
     * Key {@code ScannerAction.FirmwareFileMissing}: {@code [Vdoo Vision
     * Scanner] Configured image file doesn't exist: %s}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Configured image file doesn't exist: %s}
     */
    public static Localizable _ScannerAction_FirmwareFileMissing() {
        return new Localizable(holder, "ScannerAction.FirmwareFileMissing");
    }

    /**
     * Key {@code ScannerAction.HighlightedIssuesThresholdPassed}: {@code
     * [Vdoo Vision Scanner] Number of highlighted issues (%d) exceeds the
     * defined threshold (%s), failing build.}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Number of highlighted issues (%d) exceeds
     *     the defined threshold (%s), failing build.}
     */
    public static String ScannerAction_HighlightedIssuesThresholdPassed() {
        return holder.format("ScannerAction.HighlightedIssuesThresholdPassed");
    }

    /**
     * Key {@code ScannerAction.HighlightedIssuesThresholdPassed}: {@code
     * [Vdoo Vision Scanner] Number of highlighted issues (%d) exceeds the
     * defined threshold (%s), failing build.}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Number of highlighted issues (%d) exceeds
     *     the defined threshold (%s), failing build.}
     */
    public static Localizable _ScannerAction_HighlightedIssuesThresholdPassed() {
        return new Localizable(holder, "ScannerAction.HighlightedIssuesThresholdPassed");
    }

    /**
     * Key {@code ScannerBuilder.DescriptorImpl.VdooTokenEmpty}: {@code
     * Vision API token can not be empty or null.}.
     * 
     * @return
     *     {@code Vision API token can not be empty or null.}
     */
    public static String ScannerBuilder_DescriptorImpl_VdooTokenEmpty() {
        return holder.format("ScannerBuilder.DescriptorImpl.VdooTokenEmpty");
    }

    /**
     * Key {@code ScannerBuilder.DescriptorImpl.VdooTokenEmpty}: {@code
     * Vision API token can not be empty or null.}.
     * 
     * @return
     *     {@code Vision API token can not be empty or null.}
     */
    public static Localizable _ScannerBuilder_DescriptorImpl_VdooTokenEmpty() {
        return new Localizable(holder, "ScannerBuilder.DescriptorImpl.VdooTokenEmpty");
    }

    /**
     * Key {@code ScannerAction.ScanFinished}: {@code [Vdoo Vision Scanner]
     * Vdoo Vision scan successfully finished.}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Vdoo Vision scan successfully finished.}
     */
    public static String ScannerAction_ScanFinished() {
        return holder.format("ScannerAction.ScanFinished");
    }

    /**
     * Key {@code ScannerAction.ScanFinished}: {@code [Vdoo Vision Scanner]
     * Vdoo Vision scan successfully finished.}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Vdoo Vision scan successfully finished.}
     */
    public static Localizable _ScannerAction_ScanFinished() {
        return new Localizable(holder, "ScannerAction.ScanFinished");
    }

    /**
     * Key {@code ScannerBuilder.DescriptorImpl.PositiveNumber}: {@code Field
     * value must be a positive number}.
     * 
     * @return
     *     {@code Field value must be a positive number}
     */
    public static String ScannerBuilder_DescriptorImpl_PositiveNumber() {
        return holder.format("ScannerBuilder.DescriptorImpl.PositiveNumber");
    }

    /**
     * Key {@code ScannerBuilder.DescriptorImpl.PositiveNumber}: {@code Field
     * value must be a positive number}.
     * 
     * @return
     *     {@code Field value must be a positive number}
     */
    public static Localizable _ScannerBuilder_DescriptorImpl_PositiveNumber() {
        return new Localizable(holder, "ScannerBuilder.DescriptorImpl.PositiveNumber");
    }

    /**
     * Key {@code ScannerAction.ScanWaitMinute}: {@code [Vdoo Vision Scanner]
     * Waiting for results (%s minute). Current status: %s.}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Waiting for results (%s minute). Current
     *     status: %s.}
     */
    public static String ScannerAction_ScanWaitMinute() {
        return holder.format("ScannerAction.ScanWaitMinute");
    }

    /**
     * Key {@code ScannerAction.ScanWaitMinute}: {@code [Vdoo Vision Scanner]
     * Waiting for results (%s minute). Current status: %s.}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Waiting for results (%s minute). Current
     *     status: %s.}
     */
    public static Localizable _ScannerAction_ScanWaitMinute() {
        return new Localizable(holder, "ScannerAction.ScanWaitMinute");
    }

    /**
     * Key {@code ScannerBuilder.DescriptorImpl.FirmwareLocationEmpty}:
     * {@code Image location can not be empty or null.}.
     * 
     * @return
     *     {@code Image location can not be empty or null.}
     */
    public static String ScannerBuilder_DescriptorImpl_FirmwareLocationEmpty() {
        return holder.format("ScannerBuilder.DescriptorImpl.FirmwareLocationEmpty");
    }

    /**
     * Key {@code ScannerBuilder.DescriptorImpl.FirmwareLocationEmpty}:
     * {@code Image location can not be empty or null.}.
     * 
     * @return
     *     {@code Image location can not be empty or null.}
     */
    public static Localizable _ScannerBuilder_DescriptorImpl_FirmwareLocationEmpty() {
        return new Localizable(holder, "ScannerBuilder.DescriptorImpl.FirmwareLocationEmpty");
    }

    /**
     * Key {@code ScannerAction.ThreatLevelThresholdPassed}: {@code [Vdoo
     * Vision Scanner] Image threat level '%s'. It reached the threshold '%s'
     * to fail the build.}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Image threat level '%s'. It reached the
     *     threshold '%s' to fail the build.}
     */
    public static String ScannerAction_ThreatLevelThresholdPassed() {
        return holder.format("ScannerAction.ThreatLevelThresholdPassed");
    }

    /**
     * Key {@code ScannerAction.ThreatLevelThresholdPassed}: {@code [Vdoo
     * Vision Scanner] Image threat level '%s'. It reached the threshold '%s'
     * to fail the build.}.
     * 
     * @return
     *     {@code [Vdoo Vision Scanner] Image threat level '%s'. It reached the
     *     threshold '%s' to fail the build.}
     */
    public static Localizable _ScannerAction_ThreatLevelThresholdPassed() {
        return new Localizable(holder, "ScannerAction.ThreatLevelThresholdPassed");
    }

}
