/*
 * Decompiled with CFR 0.152.
 */
package com.delinea.secrets.jenkins.wrapper.cred;

import com.delinea.platform.service.AuthenticationService;
import com.delinea.secrets.jenkins.util.DelineaProxyUtil;
import com.delinea.secrets.jenkins.wrapper.cred.ServerConfiguration;
import com.delinea.secrets.jenkins.wrapper.cred.ServerConsoleLogFilter;
import com.delinea.secrets.jenkins.wrapper.cred.ServerSecret;
import com.delinea.secrets.jenkins.wrapper.cred.UserCredentials;
import com.delinea.server.spring.Secret;
import com.delinea.server.spring.SecretServer;
import com.delinea.server.spring.SecretServerFactoryBean;
import hudson.EnvVars;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Launcher;
import hudson.console.ConsoleLogFilter;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jenkins.tasks.SimpleBuildWrapper;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.web.client.HttpClientErrorException;

public class ServerBuildWrapper
extends SimpleBuildWrapper {
    private static final String USERNAME_PROPERTY = "server.username";
    private static final String PASSWORD_PROPERTY = "server.password";
    private static final String SERVER_URL_PROPERTY = "server.url";
    private List<ServerSecret> secrets;
    private List<String> valuesToMask = new ArrayList<String>();

    @DataBoundConstructor
    public ServerBuildWrapper(List<ServerSecret> secrets) {
        this.secrets = secrets;
    }

    public List<ServerSecret> getSecrets() {
        return this.secrets;
    }

    @DataBoundSetter
    public void setSecrets(List<ServerSecret> secrets) {
        this.secrets = secrets;
    }

    public ConsoleLogFilter createLoggerDecorator(Run<?, ?> build) {
        return new ServerConsoleLogFilter(build.getCharset().name(), this.valuesToMask);
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        ServerConfiguration configuration = (ServerConfiguration)((Object)ExtensionList.lookupSingleton(ServerConfiguration.class));
        for (ServerSecret serverSecret : this.secrets) {
            UserCredentials credential;
            HashMap<String, String> properties = new HashMap<String, String>();
            String overrideBaseURL = serverSecret.getBaseUrl();
            String effectiveUrl = StringUtils.isNotBlank((String)overrideBaseURL) ? overrideBaseURL : configuration.getBaseUrl();
            properties.put(SERVER_URL_PROPERTY, effectiveUrl);
            String overrideCredId = serverSecret.getCredentialId();
            UserCredentials userCredentials = credential = StringUtils.isNotBlank((String)overrideCredId) ? UserCredentials.get(overrideCredId, (Item)build.getParent()) : UserCredentials.get(configuration.getCredentialId(), (Item)build.getParent());
            if (credential == null) {
                throw new IOException("No credentials available to access Delinea Secret Server.");
            }
            properties.put(USERNAME_PROPERTY, credential.getUsername());
            properties.put(PASSWORD_PROPERTY, credential.getPassword().getPlainText());
            Map<String, String> proxyConfig = DelineaProxyUtil.resolveProxy(effectiveUrl, configuration.isUseProxy() ? configuration.getProxyHost() : "", configuration.isUseProxy() ? String.valueOf(configuration.getProxyPort()) : "", configuration.isUseProxy() ? configuration.getProxyUsername() : "", configuration.isUseProxy() && configuration.getProxyPassword() != null ? configuration.getProxyPassword().getPlainText() : "", configuration.isUseProxy() ? configuration.getNoProxyHosts() : "");
            for (Map.Entry<String, String> entry : proxyConfig.entrySet()) {
                properties.put(entry.getKey(), entry.getValue());
            }
            listener.getLogger().println("[ServerBuildWrapper][DEBUG] Connecting to Secret Server URL: " + effectiveUrl);
            try (AnnotationConfigApplicationContext applicationContext = new AnnotationConfigApplicationContext();){
                applicationContext.getEnvironment().getPropertySources().addLast((PropertySource)new MapPropertySource("properties", properties));
                applicationContext.registerBean(SecretServerFactoryBean.class, new BeanDefinitionCustomizer[0]);
                applicationContext.registerBean(AuthenticationService.class, new BeanDefinitionCustomizer[0]);
                applicationContext.refresh();
                SecretServer secretServer = (SecretServer)applicationContext.getBean(SecretServer.class);
                Secret secret = secretServer.getSecret(serverSecret.getId());
                secret.getFields().forEach(field -> serverSecret.getMappings().forEach(mapping -> {
                    if (mapping.getField().equalsIgnoreCase(field.getFieldName()) || mapping.getField().equalsIgnoreCase(field.getSlug())) {
                        context.env(StringUtils.trimToEmpty((String)configuration.getEnvironmentVariablePrefix()) + mapping.getEnvironmentVariable(), field.getValue());
                        this.valuesToMask.add(field.getValue());
                    }
                }));
            }
            catch (Exception ex) {
                int status;
                String proxyHost = proxyConfig.getOrDefault("proxy.host", "(none)");
                String proxyPort = proxyConfig.getOrDefault("proxy.port", "(none)");
                String proxyUser = proxyConfig.getOrDefault("proxy.username", "(none)");
                String proxyPass = proxyConfig.getOrDefault("proxy.password", "(none)");
                String maskedProxyUser = proxyUser.equals("(none)") ? "(none)" : proxyUser.replaceAll(".", "*");
                String maskedProxyPass = proxyPass.equals("(none)") ? "(none)" : proxyPass.replaceAll(".", "*");
                String maskedProxyInfo = String.format("Proxy Host=%s, Port=%s, Username=%s, Password=%s", proxyHost, proxyPort, maskedProxyUser, maskedProxyPass);
                Throwable root = ex;
                while (root.getCause() != null) {
                    root = root.getCause();
                }
                Object friendlyMessage = root instanceof UnknownHostException ? "Host not found: " + root.getMessage() : (root instanceof HttpClientErrorException ? ((status = ((HttpClientErrorException)root).getStatusCode().value()) == 407 ? "Proxy authentication failed (HTTP 407)." : (status == 400 ? "Access denied / invalid credentials (HTTP 400)." : (status == 403 ? "Access forbidden (HTTP 403)." : "HTTP error (status " + status + ")."))) : (root instanceof IOException ? "Network I/O error: " + root.getMessage() : "Unexpected error: " + root.getMessage()));
                listener.getLogger().println("[ServerBuildWrapper][ERROR] Failed to fetch secret.");
                listener.getLogger().println("    Secret ID   : " + serverSecret.getId());
                listener.getLogger().println("    Target URL  : " + effectiveUrl);
                listener.getLogger().println("    Proxy Info  : " + maskedProxyInfo);
                listener.getLogger().println("    Root Cause  : " + root.getClass().getSimpleName() + " - " + (String)friendlyMessage);
                throw new IOException(String.format("Failed to fetch secret (id=%s) for host=%s. Proxy used: %s. See logs for details.", serverSecret.getId(), effectiveUrl, maskedProxyInfo), ex);
            }
        }
    }

    @Extension
    @Symbol(value={"withSecretServer"})
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return "Use Delinea Secret Server or Platform Secrets";
        }
    }
}

