/*
 * Decompiled with CFR 0.152.
 */
package com.delinea.secrets.jenkins.wrapper.cred;

import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.delinea.secrets.jenkins.wrapper.cred.UserCredentials;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletException;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

@Extension
@Symbol(value={"secretServer"})
public class ServerConfiguration
extends GlobalConfiguration {
    public static final String DEFAULT_API_PATH_URI = "/api/v1";
    public static final String DEFAULT_TOKEN_PATH_URI = "/oauth2/token";
    public static final String DEFAULT_ENVIRONMENT_VARIABLE_PREFIX = "TSS_";
    private String credentialId;
    private String baseUrl;
    private String apiPathUri = "/api/v1";
    private String tknPathUri = "/oauth2/token";
    private String environmentVariablePrefix = "TSS_";

    public static ServerConfiguration get() {
        return (ServerConfiguration)((Object)ExtensionList.lookupSingleton(ServerConfiguration.class));
    }

    static FormValidation checkBaseUrl(@QueryParameter String value) {
        try {
            new URL(value);
            return FormValidation.ok();
        }
        catch (MalformedURLException e) {
            return FormValidation.error((String)"Invalid URL");
        }
    }

    String getAPIUrl() {
        return this.getBaseUrl() + this.getApiPathUri();
    }

    String getTokenUrl() {
        return this.getBaseUrl() + this.getTokenPathUri();
    }

    public ServerConfiguration() {
        this.load();
    }

    @POST
    public FormValidation doCheckBaseUrl(@QueryParameter String value) throws IOException, ServletException {
        if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            return FormValidation.error((String)"You do not have permission to perform this action");
        }
        return ServerConfiguration.checkBaseUrl(value);
    }

    @POST
    public ListBoxModel doFillCredentialIdItems(@AncestorInPath Item item) {
        if (item == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || item != null && !item.hasPermission(Item.CONFIGURE)) {
            return new StandardListBoxModel();
        }
        return new StandardListBoxModel().includeEmptyValue().includeAs(ACL.SYSTEM, item, UserCredentials.class);
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    @DataBoundSetter
    public void setCredentialId(String credentialId) {
        this.credentialId = credentialId;
        this.save();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @DataBoundSetter
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = StringUtils.removeEnd((String)baseUrl, (String)"/");
        this.save();
    }

    public String getEnvironmentVariablePrefix() {
        return this.environmentVariablePrefix;
    }

    @DataBoundSetter
    public void setEnvironmentVariablePrefix(String environmentVariablePrefix) {
        this.environmentVariablePrefix = environmentVariablePrefix;
        this.save();
    }

    public String getApiPathUri() {
        return this.apiPathUri;
    }

    @DataBoundSetter
    public void setApiPathUri(String apiPathUri) {
        this.apiPathUri = "/" + StringUtils.strip((String)apiPathUri, (String)"/");
        this.save();
    }

    public String getTokenPathUri() {
        return this.tknPathUri;
    }

    @DataBoundSetter
    public void setTokenPathUri(String tokenPathUri) {
        this.tknPathUri = StringUtils.strip((String)tokenPathUri);
        this.save();
    }
}

