/*
 * Decompiled with CFR 0.152.
 */
package com.delinea.secrets.jenkins.global.cred;

import com.thycotic.secrets.server.spring.Secret;
import com.thycotic.secrets.server.spring.SecretServer;
import com.thycotic.secrets.server.spring.SecretServerFactoryBean;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class VaultClient {
    private static final String USERNAME_PROPERTY = "secret_server.oauth2.username";
    private static final String PASSWORD_PROPERTY = "secret_server.oauth2.password";
    private static final String API_ROOT_URL_PROPERTY = "secret_server.api_root_url";
    private static final String OAUTH2_TOKEN_URL_PROPERTY = "secret_server.oauth2.token_url";

    public UsernamePassword fetchCredentials(String vaultUrl, String secretId, String username, String password, String usernameSlug, String passwordSlugName) throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        String ssurl = StringUtils.removeEnd((String)vaultUrl, (String)"/");
        if (StringUtils.isNotBlank((CharSequence)ssurl)) {
            properties.put(API_ROOT_URL_PROPERTY, ssurl + "/api/v1");
            properties.put(OAUTH2_TOKEN_URL_PROPERTY, ssurl + "/oauth2/token");
        }
        properties.put(USERNAME_PROPERTY, username);
        properties.put(PASSWORD_PROPERTY, password);
        try (AnnotationConfigApplicationContext applicationContext = new AnnotationConfigApplicationContext();){
            applicationContext.getEnvironment().getPropertySources().addLast((PropertySource)new MapPropertySource("properties", properties));
            applicationContext.registerBean(SecretServerFactoryBean.class, new BeanDefinitionCustomizer[0]);
            applicationContext.refresh();
            Secret secret = ((SecretServer)applicationContext.getBean(SecretServer.class)).getSecret(Integer.parseInt(secretId));
            Optional<String> fetchUsername = secret.getFields().stream().filter(field -> usernameSlug.equalsIgnoreCase(field.getFieldName()) || usernameSlug.equalsIgnoreCase(field.getSlug())).map(Secret.Field::getValue).findFirst();
            Optional<String> fetchPassword = secret.getFields().stream().filter(field -> passwordSlugName.equalsIgnoreCase(field.getFieldName()) || passwordSlugName.equalsIgnoreCase(field.getSlug())).map(Secret.Field::getValue).findFirst();
            if (fetchUsername.isPresent() && fetchPassword.isPresent()) {
                UsernamePassword usernamePassword;
                UsernamePassword usernamePassword2 = usernamePassword = new UsernamePassword(fetchUsername.get(), fetchPassword.get());
                return usernamePassword2;
            }
            UsernamePassword usernamePassword = null;
            return usernamePassword;
        }
    }

    public static class UsernamePassword {
        private final String username;
        private final hudson.util.Secret password;

        public UsernamePassword(String username, String password) {
            this.username = username;
            this.password = hudson.util.Secret.fromString((String)password);
        }

        public String getPassword() {
            return this.password.getPlainText();
        }

        public String getUsername() {
            return this.username;
        }
    }
}

