/*
 * Decompiled with CFR 0.152.
 */
package com.delinea.secrets.jenkins.global.cred;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.delinea.secrets.jenkins.global.cred.VaultClient;
import com.delinea.secrets.jenkins.wrapper.cred.UserCredentials;
import hudson.Extension;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.util.Collections;
import javax.annotation.Nullable;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.verb.POST;

public class SecretServerCredentials
extends UsernamePasswordCredentialsImpl
implements StandardCredentials {
    private static final long serialVersionUID = 1L;
    private final String usernameSlug;
    private final String passwordSlugName;
    private final String vaultUrl;
    private final String credentialId;
    private final String secretId;
    private transient VaultClient.UsernamePassword vaultCredential;

    @DataBoundConstructor
    public SecretServerCredentials(CredentialsScope scope, String id, String description, String vaultUrl, String credentialId, String secretId, String usernameSlug, String passwordSlugName) {
        super(scope, id, description, null, null);
        this.usernameSlug = usernameSlug;
        this.passwordSlugName = passwordSlugName;
        this.vaultUrl = vaultUrl;
        this.credentialId = credentialId;
        this.secretId = secretId;
        this.vaultCredential = null;
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public String getUsernameSlug() {
        return this.usernameSlug;
    }

    public String getPasswordSlugName() {
        return this.passwordSlugName;
    }

    public String getUsername() {
        return this.getVaultCredential(this.getContextItem()).getUsername();
    }

    public Secret getPassword() {
        return Secret.fromString((String)this.getVaultCredential(this.getContextItem()).getPassword());
    }

    @Nullable
    private Item getContextItem() {
        Item contextItem;
        if (Stapler.getCurrentRequest() != null && (contextItem = (Item)Stapler.getCurrentRequest().findAncestorObject(Item.class)) != null) {
            return contextItem;
        }
        return null;
    }

    private VaultClient.UsernamePassword getVaultCredential(@Nullable Item contextItem) {
        if (this.vaultCredential == null) {
            try {
                UserCredentials credential = UserCredentials.get(this.credentialId, contextItem);
                if (credential == null) {
                    throw new RuntimeException("UserCredentials with the specified credentialId not found in the folder context.");
                }
                this.vaultCredential = new VaultClient().fetchCredentials(this.vaultUrl, this.secretId, credential.getUsername(), credential.getPassword().getPlainText(), this.usernameSlug, this.passwordSlugName);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to fetch credentials from vault. " + e.getMessage());
            }
        }
        return this.vaultCredential;
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return "Secret Server Vault Credentials";
        }

        @POST
        public ListBoxModel doFillCredentialIdItems(@AncestorInPath Item owner) {
            if (owner == null && !Jenkins.get().hasPermission(CredentialsProvider.CREATE) || owner != null && !owner.hasPermission(CredentialsProvider.CREATE)) {
                return new StandardListBoxModel();
            }
            return new StandardListBoxModel().includeEmptyValue().includeAs(ACL.SYSTEM, owner, UserCredentials.class);
        }

        @POST
        public FormValidation doCheckCredentialId(@AncestorInPath Item item, @QueryParameter String value) throws IOException, ServletException {
            if (item == null && !Jenkins.get().hasPermission(CredentialsProvider.CREATE) || item != null && !item.hasPermission(CredentialsProvider.CREATE)) {
                return FormValidation.error((String)"You do not have permission to perform this action.");
            }
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Credential ID is required.");
            }
            if (CredentialsProvider.lookupCredentials(UserCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, Collections.emptyList()).stream().noneMatch(cred -> cred.getId().equals(value))) {
                return FormValidation.error((String)"Credential ID not found. Please provide a valid ID.");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckSecretId(@AncestorInPath Item item, @QueryParameter String value) throws IOException, ServletException {
            if (item == null && !Jenkins.get().hasPermission(CredentialsProvider.CREATE) || item != null && !item.hasPermission(CredentialsProvider.CREATE)) {
                return FormValidation.error((String)"You do not have permission to perform this action.");
            }
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Secret ID is required.");
            }
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"ID must be an integer.");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckUsernameSlug(@AncestorInPath Item item, @QueryParameter String value) throws IOException, ServletException {
            if (item == null && !Jenkins.get().hasPermission(CredentialsProvider.CREATE) || item != null && !item.hasPermission(CredentialsProvider.CREATE)) {
                return FormValidation.error((String)"You do not have permission to perform this action.");
            }
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Slug name is required.");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckPasswordSlugName(@AncestorInPath Item item, @QueryParameter String value) throws IOException, ServletException {
            if (item == null && !Jenkins.get().hasPermission(CredentialsProvider.CREATE) || item != null && !item.hasPermission(CredentialsProvider.CREATE)) {
                return FormValidation.error((String)"You do not have permission to perform this action.");
            }
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Slug name is required.");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doTestConnection(@AncestorInPath Item owner, @QueryParameter(value="usernameSlug") String usernameSlug, @QueryParameter(value="passwordSlugName") String passwordSlugName, @QueryParameter(value="vaultUrl") String vaultUrl, @QueryParameter(value="credentialId") String credentialId, @QueryParameter(value="secretId") String secretId) {
            if (owner == null && !Jenkins.get().hasPermission(CredentialsProvider.CREATE) || owner != null && !owner.hasPermission(CredentialsProvider.CREATE)) {
                return FormValidation.error((String)"You do not have permission to perform this action.");
            }
            if (StringUtils.isBlank((String)credentialId)) {
                return FormValidation.error((String)"Credential ID is required to test the connection.");
            }
            if (StringUtils.isBlank((String)vaultUrl)) {
                return FormValidation.error((String)"Vault URL cannot be blank.");
            }
            if (StringUtils.isBlank((String)usernameSlug)) {
                return FormValidation.error((String)"Slug name cannot be blank.");
            }
            if (StringUtils.isBlank((String)passwordSlugName)) {
                return FormValidation.error((String)"Slug name cannot be blank.");
            }
            try {
                UserCredentials credential = UserCredentials.get(credentialId, owner);
                new VaultClient().fetchCredentials(vaultUrl, secretId, credential.getUsername(), credential.getPassword().getPlainText(), usernameSlug, passwordSlugName);
                return FormValidation.ok((String)"Connection successful.");
            }
            catch (Exception e) {
                return FormValidation.error((String)("Failed to establish connection: " + e.getMessage()));
            }
        }
    }
}

