/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.thememanager;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import tools.jackson.databind.ObjectMapper;

public class Theme {
    private static final String JS_HTML = "<script type=\"text/javascript\" src=\"{0}\"></script>";
    private static final String JSON_HTML = "<script id=\"theme-manager-{0}\" type=\"application/json\">{1}</script>";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String CSS_HTML = "<link type=\"text/css\" rel=\"stylesheet\" href=\"{0}\"/>";
    private final List<String> cssUrls;
    private final List<String> javascriptUrls;
    private final boolean respectSystemAppearance;
    private final Map<String, String> properties;

    private Theme(List<String> cssUrls, List<String> javascriptUrls, boolean respectSystemAppearance, Map<String, String> properties) {
        this.cssUrls = cssUrls;
        this.javascriptUrls = javascriptUrls;
        this.respectSystemAppearance = respectSystemAppearance;
        this.properties = properties;
    }

    @Restricted(value={NoExternalUse.class})
    String generateProperties() {
        try {
            return MessageFormat.format(JSON_HTML, "properties", OBJECT_MAPPER.writeValueAsString(this.properties));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Restricted(value={NoExternalUse.class})
    Set<String> generateHeaderElements(boolean injectCss) {
        HashSet<String> headerElements = new HashSet<String>();
        if (injectCss) {
            for (String cssUrl : this.cssUrls) {
                headerElements.add(MessageFormat.format(CSS_HTML, cssUrl));
            }
        }
        for (String javascriptUrl : this.javascriptUrls) {
            headerElements.add(MessageFormat.format(JS_HTML, javascriptUrl));
        }
        return headerElements;
    }

    public List<String> getCssUrls() {
        return this.cssUrls;
    }

    public List<String> getJavascriptUrls() {
        return this.javascriptUrls;
    }

    public boolean isRespectSystemAppearance() {
        return this.respectSystemAppearance;
    }

    public List<String> getProperties(String artifactId) {
        return this.properties.entrySet().stream().filter(k -> ((String)k.getKey()).startsWith(artifactId + ":")).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @Deprecated
    public Optional<String> getProperty(String artifactId, String propertyName) {
        return Optional.ofNullable(this.properties.get(artifactId + ":" + propertyName));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<String> cssUrls = Collections.emptyList();
        private List<String> javascriptUrls = Collections.emptyList();
        private boolean respectSystemAppearance = false;
        private final Map<String, String> properties = new HashMap<String, String>();

        Builder() {
        }

        public Builder withCssUrl(String cssUrl) {
            this.cssUrls = Collections.singletonList(cssUrl);
            return this;
        }

        public Builder withCssUrls(List<String> cssUrls) {
            this.cssUrls = cssUrls;
            return this;
        }

        public Builder respectSystemAppearance() {
            this.respectSystemAppearance = true;
            return this;
        }

        public Builder withProperty(String pluginId, String name, String value) {
            this.properties.put(pluginId + ":" + name, value);
            return this;
        }

        public Builder withJavascriptUrl(String javascriptUrl) {
            this.javascriptUrls = Collections.singletonList(javascriptUrl);
            return this;
        }

        public Builder withJavascriptUrls(List<String> javascriptUrls) {
            this.javascriptUrls = javascriptUrls;
            return this;
        }

        public Theme build() {
            return new Theme(this.cssUrls, this.javascriptUrls, this.respectSystemAppearance, this.properties);
        }
    }
}

