/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.thememanager;

import hudson.ExtensionPoint;
import hudson.model.AbstractDescribableImpl;
import io.jenkins.plugins.thememanager.Theme;
import io.jenkins.plugins.thememanager.ThemeManagerFactoryDescriptor;
import jenkins.model.Jenkins;

public abstract class ThemeManagerFactory
extends AbstractDescribableImpl<ThemeManagerFactory>
implements ExtensionPoint {
    public abstract Theme getTheme();

    public String getCssUrl() {
        ThemeManagerFactoryDescriptor descriptor = this.getDescriptor();
        return this.toAssetUrl(descriptor.getThemeCssSuffix());
    }

    public String toAssetUrl(String asset) {
        ThemeManagerFactoryDescriptor descriptor = this.getDescriptor();
        return Jenkins.get().getRootUrl() + "theme-" + descriptor.getThemeId() + "/" + asset;
    }

    public String getJavaScriptUrl() {
        ThemeManagerFactoryDescriptor descriptor = this.getDescriptor();
        return this.toAssetUrl(descriptor.getThemeJsSuffix());
    }

    public ThemeManagerFactoryDescriptor getDescriptor() {
        return (ThemeManagerFactoryDescriptor)super.getDescriptor();
    }
}

