/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.thememanager;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import io.jenkins.plugins.thememanager.Theme;
import io.jenkins.plugins.thememanager.ThemeManagerFactory;
import io.jenkins.plugins.thememanager.ThemeManagerPageDecorator;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

@Restricted(value={NoExternalUse.class})
public class ThemeUserProperty
extends UserProperty {
    private ThemeManagerFactory theme;

    @DataBoundConstructor
    public ThemeUserProperty() {
    }

    public ThemeManagerFactory getTheme() {
        return this.theme;
    }

    @DataBoundSetter
    public void setTheme(ThemeManagerFactory theme) {
        this.theme = theme;
    }

    @CheckForNull
    public static Theme forCurrentUser() {
        ThemeManagerFactory factory = ThemeUserProperty.forCurrentUserFactory();
        if (factory == null) {
            return null;
        }
        return factory.getTheme();
    }

    @CheckForNull
    public static ThemeManagerFactory forCurrentUserFactory() {
        User current = User.current();
        if (current == null) {
            return null;
        }
        ThemeUserProperty property = (ThemeUserProperty)current.getProperty(ThemeUserProperty.class);
        if (property == null || property.theme == null) {
            return null;
        }
        return property.getTheme();
    }

    @Extension
    public static class ThemeUserPropertyDescriptor
    extends UserPropertyDescriptor {
        public boolean isEnabled() {
            return !ThemeManagerPageDecorator.get().isDisableUserThemes();
        }

        @NonNull
        public String getDisplayName() {
            return "Themes";
        }

        public UserProperty newInstance(User user) {
            return new ThemeUserProperty();
        }
    }
}

