/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.thememanager;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.PageDecorator;
import io.jenkins.plugins.thememanager.Theme;
import io.jenkins.plugins.thememanager.ThemeManagerFactory;
import io.jenkins.plugins.thememanager.ThemeManagerFactoryDescriptor;
import io.jenkins.plugins.thememanager.ThemeUserProperty;
import io.jenkins.plugins.thememanager.none.NoOpThemeManagerFactory;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

@Extension
@Symbol(value={"themeManager"})
public class ThemeManagerPageDecorator
extends PageDecorator {
    private ThemeManagerFactory theme;
    private boolean disableUserThemes;

    public ThemeManagerPageDecorator() {
        this.load();
    }

    public static ThemeManagerPageDecorator get() {
        return (ThemeManagerPageDecorator)((Object)ExtensionList.lookupSingleton(ThemeManagerPageDecorator.class));
    }

    public boolean configure(StaplerRequest req, JSONObject formData) {
        req.bindJSON((Object)this, formData);
        this.save();
        return true;
    }

    @DataBoundSetter
    public void setTheme(ThemeManagerFactory theme) {
        this.theme = theme;
    }

    public ThemeManagerFactory getTheme() {
        return this.theme;
    }

    public boolean isDisableUserThemes() {
        return this.disableUserThemes;
    }

    @DataBoundSetter
    public void setDisableUserThemes(boolean disableUserThemes) {
        this.disableUserThemes = disableUserThemes;
    }

    @NonNull
    public Theme findTheme() {
        Theme userTheme;
        if (!this.disableUserThemes && (userTheme = ThemeUserProperty.forCurrentUser()) != null) {
            return userTheme;
        }
        if (this.theme != null) {
            return this.theme.getTheme();
        }
        return new NoOpThemeManagerFactory().getTheme();
    }

    @NonNull
    public ThemeManagerFactory findThemeFactory() {
        ThemeManagerFactory userTheme;
        if (!this.disableUserThemes && (userTheme = ThemeUserProperty.forCurrentUserFactory()) != null) {
            return userTheme;
        }
        if (this.theme != null) {
            return this.theme;
        }
        return new NoOpThemeManagerFactory();
    }

    public String getHeaderHtml() {
        boolean injectCss = this.shouldInjectCss();
        Set namespacedThemes = ThemeManagerFactoryDescriptor.all().stream().filter(ThemeManagerFactoryDescriptor::isNamespaced).map(desc -> desc.getInstance().getTheme().generateHeaderElements(injectCss)).flatMap(Collection::stream).collect(Collectors.toSet());
        ThemeManagerFactory themeManagerFactory = this.findThemeFactory();
        if (!themeManagerFactory.getDescriptor().isNamespaced()) {
            LinkedHashSet<String> data = new LinkedHashSet<String>(themeManagerFactory.getTheme().generateHeaderElements(injectCss));
            data.addAll(namespacedThemes);
            return StringUtils.join(data, (String)"\n");
        }
        return StringUtils.join(namespacedThemes, (String)"\n");
    }

    public String getThemeKey() {
        ThemeManagerFactory themeFactory = this.findThemeFactory();
        return themeFactory.getDescriptor().getThemeKey();
    }

    public boolean shouldInjectCss() {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req == null) {
            return false;
        }
        List ancestors = req.getAncestors();
        if (ancestors == null || ancestors.size() == 0) {
            return false;
        }
        Ancestor a = (Ancestor)ancestors.get(ancestors.size() - 1);
        Object o = a.getObject();
        return !o.getClass().getName().startsWith("com.smartcodeltd.jenkinsci.plugins.buildmonitor");
    }
}

