/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.swarmcloud.monitoring;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.User;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Extension
public class SwarmAuditLog {
    private static final Logger LOGGER = Logger.getLogger(SwarmAuditLog.class.getName());
    private static final int MAX_ENTRIES = 1000;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault());
    private static final ConcurrentLinkedDeque<AuditEntry> auditLog = new ConcurrentLinkedDeque();

    public static void logProvision(@NonNull String cloudName, @NonNull String templateName, @NonNull String agentName, @Nullable String serviceId) {
        String user = SwarmAuditLog.getCurrentUser();
        AuditEntry entry = new AuditEntry(AuditEvent.PROVISION, cloudName, templateName, agentName, serviceId, null, user);
        SwarmAuditLog.addEntry(entry);
        LOGGER.log(Level.FINE, "[AUDIT] PROVISION: cloud={0}, template={1}, agent={2}, serviceId={3}, user={4}", new Object[]{cloudName, templateName, agentName, serviceId, user});
    }

    public static void logTermination(@NonNull String cloudName, @NonNull String agentName, @Nullable String serviceId, @NonNull String reason) {
        String user = SwarmAuditLog.getCurrentUser();
        AuditEntry entry = new AuditEntry(AuditEvent.TERMINATE, cloudName, null, agentName, serviceId, reason, user);
        SwarmAuditLog.addEntry(entry);
        LOGGER.log(Level.FINE, "[AUDIT] TERMINATE: cloud={0}, agent={1}, serviceId={2}, reason={3}, user={4}", new Object[]{cloudName, agentName, serviceId, reason, user});
    }

    public static void logProvisionFailure(@NonNull String cloudName, @NonNull String templateName, @NonNull String errorMessage) {
        String user = SwarmAuditLog.getCurrentUser();
        AuditEntry entry = new AuditEntry(AuditEvent.PROVISION_FAILED, cloudName, templateName, null, null, errorMessage, user);
        SwarmAuditLog.addEntry(entry);
        LOGGER.log(Level.WARNING, "[AUDIT] PROVISION_FAILED: cloud={0}, template={1}, error={2}, user={3}", new Object[]{cloudName, templateName, errorMessage, user});
    }

    public static void logConfigChange(@NonNull String cloudName, @Nullable String templateName, @NonNull String changeDescription) {
        String user = SwarmAuditLog.getCurrentUser();
        AuditEntry entry = new AuditEntry(AuditEvent.CONFIG_CHANGE, cloudName, templateName, null, null, changeDescription, user);
        SwarmAuditLog.addEntry(entry);
        LOGGER.log(Level.FINE, "[AUDIT] CONFIG_CHANGE: cloud={0}, template={1}, change={2}, user={3}", new Object[]{cloudName, templateName, changeDescription, user});
    }

    public static void logApiAccess(@NonNull String endpoint, @NonNull String method, @Nullable String cloudName) {
        String user = SwarmAuditLog.getCurrentUser();
        String message = String.format("%s %s", method, endpoint);
        AuditEntry entry = new AuditEntry(AuditEvent.API_ACCESS, cloudName, null, null, null, message, user);
        SwarmAuditLog.addEntry(entry);
        LOGGER.log(Level.FINE, "[AUDIT] API_ACCESS: {0} {1}, cloud={2}, user={3}", new Object[]{method, endpoint, cloudName, user});
    }

    public static void logConnectionTest(@NonNull String cloudName, @NonNull String dockerHost, boolean success, @Nullable String errorMessage) {
        String user = SwarmAuditLog.getCurrentUser();
        String message = success ? "Connection successful to " + dockerHost : "Connection failed to " + dockerHost + ": " + errorMessage;
        AuditEntry entry = new AuditEntry(success ? AuditEvent.CONNECTION_TEST_SUCCESS : AuditEvent.CONNECTION_TEST_FAILED, cloudName, null, null, null, message, user);
        SwarmAuditLog.addEntry(entry);
        if (success) {
            LOGGER.log(Level.FINE, "[AUDIT] CONNECTION_TEST_SUCCESS: cloud={0}, host={1}, user={2}", new Object[]{cloudName, dockerHost, user});
        } else {
            LOGGER.log(Level.WARNING, "[AUDIT] CONNECTION_TEST_FAILED: cloud={0}, host={1}, error={2}, user={3}", new Object[]{cloudName, dockerHost, errorMessage, user});
        }
    }

    private static void addEntry(AuditEntry entry) {
        auditLog.addFirst(entry);
        while (auditLog.size() > 1000) {
            auditLog.removeLast();
        }
    }

    @NonNull
    private static String getCurrentUser() {
        User user = User.current();
        if (user != null) {
            return user.getId();
        }
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null) {
            return "SYSTEM";
        }
        return "ANONYMOUS";
    }

    @NonNull
    public static List<AuditEntry> getRecentEntries(int limit) {
        ArrayList<AuditEntry> entries = new ArrayList<AuditEntry>();
        int count = 0;
        for (AuditEntry entry : auditLog) {
            if (count >= limit) break;
            entries.add(entry);
            ++count;
        }
        return Collections.unmodifiableList(entries);
    }

    @NonNull
    public static List<AuditEntry> getEntriesForCloud(@NonNull String cloudName, int limit) {
        ArrayList<AuditEntry> entries = new ArrayList<AuditEntry>();
        for (AuditEntry entry : auditLog) {
            if (entries.size() >= limit) break;
            if (!cloudName.equals(entry.getCloudName())) continue;
            entries.add(entry);
        }
        return Collections.unmodifiableList(entries);
    }

    public static void clear() {
        auditLog.clear();
    }

    public static class AuditEntry {
        private final long timestamp = System.currentTimeMillis();
        private final AuditEvent event;
        private final String cloudName;
        private final String templateName;
        private final String agentName;
        private final String serviceId;
        private final String message;
        private final String user;

        public AuditEntry(AuditEvent event, String cloudName, String templateName, String agentName, String serviceId, String message, String user) {
            this.event = event;
            this.cloudName = cloudName;
            this.templateName = templateName;
            this.agentName = agentName;
            this.serviceId = serviceId;
            this.message = message;
            this.user = user;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String getFormattedTimestamp() {
            return FORMATTER.format(Instant.ofEpochMilli(this.timestamp));
        }

        public AuditEvent getEvent() {
            return this.event;
        }

        public String getCloudName() {
            return this.cloudName;
        }

        public String getTemplateName() {
            return this.templateName;
        }

        public String getAgentName() {
            return this.agentName;
        }

        public String getServiceId() {
            return this.serviceId;
        }

        public String getMessage() {
            return this.message;
        }

        public String getUser() {
            return this.user;
        }

        public String toString() {
            return String.format("[%s] %s: cloud=%s, template=%s, agent=%s, user=%s, message=%s", new Object[]{this.getFormattedTimestamp(), this.event, this.cloudName, this.templateName, this.agentName, this.user, this.message});
        }
    }

    public static enum AuditEvent {
        PROVISION,
        TERMINATE,
        PROVISION_FAILED,
        CONFIG_CHANGE,
        API_ACCESS,
        CONNECTION_TEST_SUCCESS,
        CONNECTION_TEST_FAILED;

    }
}

