/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.swarmcloud;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class SwarmConfigFile
extends AbstractDescribableImpl<SwarmConfigFile> {
    private final String configName;
    private String targetPath;
    private String fileName;
    private String fileMode;
    private String uid;
    private String gid;

    @DataBoundConstructor
    public SwarmConfigFile(@NonNull String configName) {
        this.configName = Util.fixEmptyAndTrim((String)configName);
    }

    @Nullable
    public static SwarmConfigFile parse(String configString) {
        if (configString == null || configString.isBlank()) {
            return null;
        }
        int colonIdx = (configString = configString.trim()).indexOf(58);
        if (colonIdx <= 0) {
            return new SwarmConfigFile(configString);
        }
        if (colonIdx == 1 && Character.isLetter(configString.charAt(0))) {
            return new SwarmConfigFile(configString);
        }
        String configName = configString.substring(0, colonIdx).trim();
        String targetPath = configString.substring(colonIdx + 1).trim();
        if (configName.isEmpty()) {
            return null;
        }
        SwarmConfigFile config = new SwarmConfigFile(configName);
        if (!targetPath.isEmpty()) {
            config.setTargetPath(targetPath);
        }
        return config;
    }

    @NonNull
    public String getConfigName() {
        return this.configName != null ? this.configName : "";
    }

    @Nullable
    public String getTargetPath() {
        return this.targetPath;
    }

    @DataBoundSetter
    public void setTargetPath(String targetPath) {
        this.targetPath = Util.fixEmptyAndTrim((String)targetPath);
    }

    @Nullable
    public String getFileName() {
        return this.fileName;
    }

    @DataBoundSetter
    public void setFileName(String fileName) {
        this.fileName = Util.fixEmptyAndTrim((String)fileName);
    }

    @Nullable
    public String getFileMode() {
        return this.fileMode;
    }

    @DataBoundSetter
    public void setFileMode(String fileMode) {
        this.fileMode = Util.fixEmptyAndTrim((String)fileMode);
    }

    @Nullable
    public String getUid() {
        return this.uid;
    }

    @DataBoundSetter
    public void setUid(String uid) {
        this.uid = Util.fixEmptyAndTrim((String)uid);
    }

    @Nullable
    public String getGid() {
        return this.gid;
    }

    @DataBoundSetter
    public void setGid(String gid) {
        this.gid = Util.fixEmptyAndTrim((String)gid);
    }

    @NonNull
    public String getEffectiveTargetPath() {
        if (this.targetPath != null && !this.targetPath.isBlank()) {
            return this.targetPath;
        }
        return "/" + this.configName;
    }

    @NonNull
    public String getEffectiveFileName() {
        if (this.fileName != null && !this.fileName.isBlank()) {
            return this.fileName;
        }
        String path = this.getEffectiveTargetPath();
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash >= 0 && lastSlash < path.length() - 1) {
            return path.substring(lastSlash + 1);
        }
        return this.configName;
    }

    @Nullable
    public Long getFileModeAsLong() {
        if (this.fileMode == null || this.fileMode.isBlank()) {
            return null;
        }
        try {
            return Long.parseLong(this.fileMode, 8);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String toString() {
        if (this.targetPath != null && !this.targetPath.isBlank()) {
            return this.configName + ":" + this.targetPath;
        }
        return this.configName;
    }

    @Extension
    @Symbol(value={"swarmConfig"})
    public static class DescriptorImpl
    extends Descriptor<SwarmConfigFile> {
        @NonNull
        public String getDisplayName() {
            return "Docker Swarm Config";
        }

        @POST
        public FormValidation doCheckConfigName(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.error((String)"Config name is required");
            }
            if (!value.matches("[a-zA-Z0-9_.-]+")) {
                return FormValidation.error((String)"Config name can only contain letters, numbers, underscores, dots, and hyphens");
            }
            if (value.length() > 64) {
                return FormValidation.error((String)"Config name must be 64 characters or less");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckFileMode(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.ok();
            }
            if (!value.matches("[0-7]{3,4}")) {
                return FormValidation.error((String)"File mode must be in octal format (e.g., 0644)");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckTargetPath(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.ok();
            }
            if (!value.startsWith("/")) {
                return FormValidation.error((String)"Target path must be an absolute path");
            }
            return FormValidation.ok();
        }
    }
}

