/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.swarmcloud;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.security.ACL;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.swarmcloud.SwarmAgent;
import io.jenkins.plugins.swarmcloud.SwarmAgentTemplate;
import io.jenkins.plugins.swarmcloud.api.DockerSwarmClient;
import io.jenkins.plugins.swarmcloud.monitoring.SwarmAuditLog;
import io.jenkins.plugins.swarmcloud.ratelimit.ProvisionRateLimiter;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.net.ssl.SSLHandshakeException;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class SwarmCloud
extends Cloud {
    private static final Logger LOGGER = Logger.getLogger(SwarmCloud.class.getName());
    private String dockerHost;
    private String credentialsId;
    private String jenkinsUrl;
    private String swarmNetwork;
    private int maxConcurrentAgents = 10;
    private int maxProvisionsPerMinute = 10;
    private long minProvisionIntervalMs = 1000L;
    private boolean rateLimitEnabled = true;
    private List<SwarmAgentTemplate> templates = new ArrayList<SwarmAgentTemplate>();
    private transient DockerSwarmClient dockerClient;

    @DataBoundConstructor
    public SwarmCloud(@NonNull String name) {
        super(name);
    }

    @NonNull
    public String getDockerHost() {
        return this.dockerHost != null ? this.dockerHost : "";
    }

    @DataBoundSetter
    public void setDockerHost(String dockerHost) {
        this.dockerHost = dockerHost;
    }

    @Nullable
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    @Nullable
    public String getJenkinsUrl() {
        return this.jenkinsUrl;
    }

    @DataBoundSetter
    public void setJenkinsUrl(String jenkinsUrl) {
        this.jenkinsUrl = jenkinsUrl;
    }

    @Nullable
    public String getSwarmNetwork() {
        return this.swarmNetwork;
    }

    @DataBoundSetter
    public void setSwarmNetwork(String swarmNetwork) {
        this.swarmNetwork = swarmNetwork;
    }

    public int getMaxConcurrentAgents() {
        return this.maxConcurrentAgents;
    }

    @DataBoundSetter
    public void setMaxConcurrentAgents(int maxConcurrentAgents) {
        this.maxConcurrentAgents = maxConcurrentAgents > 0 ? maxConcurrentAgents : 10;
    }

    public int getMaxProvisionsPerMinute() {
        return this.maxProvisionsPerMinute > 0 ? this.maxProvisionsPerMinute : 10;
    }

    @DataBoundSetter
    public void setMaxProvisionsPerMinute(int maxProvisionsPerMinute) {
        this.maxProvisionsPerMinute = maxProvisionsPerMinute > 0 ? maxProvisionsPerMinute : 10;
    }

    public long getMinProvisionIntervalMs() {
        return this.minProvisionIntervalMs > 0L ? this.minProvisionIntervalMs : 1000L;
    }

    @DataBoundSetter
    public void setMinProvisionIntervalMs(long minProvisionIntervalMs) {
        this.minProvisionIntervalMs = minProvisionIntervalMs > 0L ? minProvisionIntervalMs : 1000L;
    }

    public boolean isRateLimitEnabled() {
        return this.rateLimitEnabled;
    }

    @DataBoundSetter
    public void setRateLimitEnabled(boolean rateLimitEnabled) {
        this.rateLimitEnabled = rateLimitEnabled;
    }

    @NonNull
    public List<SwarmAgentTemplate> getTemplates() {
        return this.templates != null ? Collections.unmodifiableList(this.templates) : Collections.emptyList();
    }

    @DataBoundSetter
    public void setTemplates(List<SwarmAgentTemplate> templates) {
        this.templates = templates != null ? new ArrayList<SwarmAgentTemplate>(templates) : new ArrayList();
        for (SwarmAgentTemplate template : this.templates) {
            template.setParent(this);
        }
    }

    @NonNull
    public String getEffectiveJenkinsUrl() {
        String rootUrl;
        if (this.jenkinsUrl != null && !this.jenkinsUrl.isBlank()) {
            return this.jenkinsUrl;
        }
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null && (rootUrl = jenkins.getRootUrl()) != null) {
            return rootUrl;
        }
        return "http://localhost:8080/";
    }

    @NonNull
    public synchronized DockerSwarmClient getDockerClient() {
        if (this.dockerClient == null) {
            this.dockerClient = new DockerSwarmClient(this.dockerHost, this.credentialsId);
        }
        return this.dockerClient;
    }

    @Nullable
    public SwarmAgentTemplate getTemplate(@Nullable Label label) {
        for (SwarmAgentTemplate template : this.getTemplates()) {
            if (!template.matches(label)) continue;
            return template;
        }
        return null;
    }

    @Nullable
    public SwarmAgentTemplate getTemplateByName(@NonNull String name) {
        for (SwarmAgentTemplate template : this.getTemplates()) {
            if (!name.equals(template.getName())) continue;
            return template;
        }
        return null;
    }

    public boolean canProvision() {
        int currentAgents = this.countCurrentAgents();
        return currentAgents < this.maxConcurrentAgents;
    }

    public int countCurrentAgents() {
        int count = 0;
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null) {
            for (Node node : jenkins.getNodes()) {
                SwarmAgent agent;
                if (!(node instanceof SwarmAgent) || !this.name.equals((agent = (SwarmAgent)node).getCloudName())) continue;
                ++count;
            }
        }
        return count;
    }

    public boolean canProvision(@NonNull Cloud.CloudState state) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null || jenkins.isQuietingDown() || jenkins.isTerminating()) {
            LOGGER.log(Level.FINE, "Not provisioning: Jenkins is shutting down or in quiet mode");
            return false;
        }
        Label label = state.getLabel();
        LOGGER.log(Level.FINE, "canProvision called for cloud ''{0}'' with label: {1}, templates count: {2}", new Object[]{this.name, label, this.templates != null ? this.templates.size() : 0});
        if (!this.canProvision()) {
            LOGGER.log(Level.FINE, "canProvision=false: max agents reached ({0}/{1})", new Object[]{this.countCurrentAgents(), this.maxConcurrentAgents});
            return false;
        }
        SwarmAgentTemplate template = this.getTemplate(label);
        if (template == null) {
            if (this.templates != null && !this.templates.isEmpty()) {
                for (SwarmAgentTemplate t : this.templates) {
                    LOGGER.log(Level.FINE, "Available template: name=''{0}'', label=''{1}''", new Object[]{t.getName(), t.getLabelString()});
                }
            }
            LOGGER.log(Level.FINE, "canProvision=false: no template found for label ''{0}''", label);
            return false;
        }
        LOGGER.log(Level.FINE, "Found matching template: ''{0}'' for label ''{1}''", new Object[]{template.getName(), label});
        if (this.rateLimitEnabled && !ProvisionRateLimiter.canProvision(this.name, this.getMaxProvisionsPerMinute(), this.getMinProvisionIntervalMs())) {
            LOGGER.log(Level.FINE, "Provision rate limited for cloud: {0}", this.name);
            return false;
        }
        return true;
    }

    @NonNull
    public Collection<NodeProvisioner.PlannedNode> provision(@NonNull Cloud.CloudState state, int excessWorkload) {
        ArrayList<NodeProvisioner.PlannedNode> plannedNodes = new ArrayList<NodeProvisioner.PlannedNode>();
        Label label = state.getLabel();
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null || jenkins.isQuietingDown() || jenkins.isTerminating()) {
            LOGGER.log(Level.FINE, "Skipping provision: Jenkins is shutting down or in quiet mode");
            return Collections.emptyList();
        }
        LOGGER.log(Level.FINE, "Provision requested for label: {0}, excessWorkload: {1}", new Object[]{label, excessWorkload});
        if (this.rateLimitEnabled && !ProvisionRateLimiter.canProvision(this.name, this.getMaxProvisionsPerMinute(), this.getMinProvisionIntervalMs())) {
            long waitTime = ProvisionRateLimiter.getWaitTime(this.name, this.getMaxProvisionsPerMinute(), this.getMinProvisionIntervalMs());
            LOGGER.log(Level.FINE, "Provision rate limited for cloud: {0}, wait time: {1}ms", new Object[]{this.name, waitTime});
            return Collections.emptyList();
        }
        SwarmAgentTemplate template = this.getTemplate(label);
        if (template == null) {
            LOGGER.log(Level.WARNING, "No template found for label: {0}", label);
            return Collections.emptyList();
        }
        int availableCapacity = this.maxConcurrentAgents - this.countCurrentAgents();
        int toProvision = Math.min(excessWorkload, availableCapacity);
        toProvision = Math.min(toProvision, template.getAvailableCapacity());
        if (this.rateLimitEnabled) {
            int maxAllowed = this.getMaxProvisionsPerMinute() - ProvisionRateLimiter.getInfo(this.name).getProvisionCount();
            toProvision = Math.min(toProvision, Math.max(1, maxAllowed));
        }
        LOGGER.log(Level.FINE, "Will provision {0} agents using template: {1}", new Object[]{toProvision, template.getName()});
        for (int i = 0; i < toProvision; ++i) {
            String agentName = template.generateAgentName();
            plannedNodes.add(new NodeProvisioner.PlannedNode(agentName, Computer.threadPoolForRemoting.submit(new ProvisioningCallback(this, template, agentName)), template.getNumExecutors()));
            if (!this.rateLimitEnabled) continue;
            ProvisionRateLimiter.recordProvision(this.name);
        }
        return plannedNodes;
    }

    private static class ProvisioningCallback
    implements Callable<Node> {
        private final SwarmCloud cloud;
        private final SwarmAgentTemplate template;
        private final String agentName;

        ProvisioningCallback(SwarmCloud cloud, SwarmAgentTemplate template, String agentName) {
            this.cloud = cloud;
            this.template = template;
            this.agentName = agentName;
        }

        @Override
        public Node call() throws Exception {
            LOGGER.log(Level.FINE, "Provisioning agent: {0}", this.agentName);
            SwarmAgentTemplate resolvedTemplate = this.template.resolve();
            int maxRetries = resolvedTemplate.getProvisionRetryCount();
            long baseDelayMs = resolvedTemplate.getProvisionRetryDelayMs();
            int idleTimeoutMinutes = resolvedTemplate.getIdleTimeoutMinutes();
            Exception lastException = null;
            for (int attempt = 0; attempt <= maxRetries; ++attempt) {
                try {
                    if (attempt > 0) {
                        long delayMs = baseDelayMs * (1L << attempt - 1);
                        delayMs = Math.min(delayMs, 30000L);
                        LOGGER.log(Level.FINE, "Retry attempt {0}/{1} for agent {2}, waiting {3}ms", new Object[]{attempt, maxRetries, this.agentName, delayMs});
                        Thread.sleep(delayMs);
                    }
                    String serviceId = this.cloud.getDockerClient().createService(this.agentName, resolvedTemplate, this.cloud.getEffectiveJenkinsUrl(), this.cloud.getSwarmNetwork());
                    LOGGER.log(Level.FINE, "Created Docker Swarm service: {0} for agent: {1}", new Object[]{serviceId, this.agentName});
                    SwarmAgent agent = new SwarmAgent(this.agentName, resolvedTemplate, this.cloud.name, serviceId, idleTimeoutMinutes);
                    if (this.cloud.isRateLimitEnabled()) {
                        ProvisionRateLimiter.resetFailures(this.cloud.name);
                    }
                    SwarmAuditLog.logProvision(this.cloud.name, this.template.getName(), this.agentName, serviceId);
                    return agent;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw e;
                }
                catch (Exception e) {
                    lastException = e;
                    LOGGER.log(Level.WARNING, "Provision attempt {0}/{1} failed for agent {2}: {3}", new Object[]{attempt + 1, maxRetries + 1, this.agentName, e.getMessage()});
                    continue;
                }
            }
            LOGGER.log(Level.SEVERE, "Failed to provision agent after " + (maxRetries + 1) + " attempts: " + this.agentName, lastException);
            if (this.cloud.isRateLimitEnabled()) {
                ProvisionRateLimiter.recordFailure(this.cloud.name);
            }
            String errorMsg = lastException != null ? lastException.getMessage() : "Unknown error";
            SwarmAuditLog.logProvisionFailure(this.cloud.name, this.template.getName(), errorMsg);
            throw lastException != null ? lastException : new Exception("Failed to provision agent");
        }
    }

    @Extension
    @Symbol(value={"swarmAgentsCloud"})
    public static class DescriptorImpl
    extends Descriptor<Cloud> {
        private static final Pattern DOCKER_HOST_PATTERN = Pattern.compile("^(tcp|unix|npipe)://[^\\s]+$", 2);

        @NonNull
        public String getDisplayName() {
            return "Docker Swarm Agents Cloud";
        }

        @POST
        public FormValidation doTestConnection(@QueryParameter(value="dockerHost") String dockerHost, @QueryParameter(value="credentialsId") String credentialsId) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (dockerHost == null || dockerHost.isBlank()) {
                return FormValidation.error((String)"Docker host is required");
            }
            String trimmedHost = dockerHost.trim();
            if (!DOCKER_HOST_PATTERN.matcher(trimmedHost).matches()) {
                if (trimmedHost.startsWith("https://") || trimmedHost.startsWith("http://")) {
                    return FormValidation.error((String)"Invalid protocol. Use 'tcp://' instead of '%s'. Example: tcp://docker-host:2376", (Object[])new Object[]{trimmedHost.substring(0, trimmedHost.indexOf("://"))});
                }
                return FormValidation.error((String)"Invalid Docker host format. Expected: tcp://host:port, unix:///var/run/docker.sock, or npipe:////./pipe/docker_engine");
            }
            try {
                DockerSwarmClient client = new DockerSwarmClient(trimmedHost, credentialsId);
                String version = client.getSwarmVersion();
                int nodes = client.getNodeCount();
                return FormValidation.ok((String)"Connected to Docker Swarm. Version: %s, Nodes: %d", (Object[])new Object[]{version, nodes});
            }
            catch (Exception e) {
                return this.handleConnectionError(e, trimmedHost, credentialsId);
            }
        }

        private FormValidation handleConnectionError(Exception e, String dockerHost, String credentialsId) {
            Throwable cause;
            for (cause = e; cause.getCause() != null && cause.getCause() != cause; cause = cause.getCause()) {
            }
            if (cause instanceof SSLHandshakeException) {
                if (credentialsId == null || credentialsId.isBlank()) {
                    return FormValidation.error((String)"TLS/SSL handshake failed. The Docker host requires TLS authentication. Please select Docker Server Credentials with client certificate.");
                }
                return FormValidation.error((String)"TLS/SSL certificate error: %s. Check that credentials contain valid certificates matching the Docker host CA.", (Object[])new Object[]{cause.getMessage()});
            }
            if (cause instanceof ConnectException) {
                return FormValidation.error((String)"Connection refused. Please verify: (1) Docker daemon is running, (2) Host and port are correct, (3) Docker API is exposed (not just Docker socket).");
            }
            if (cause instanceof UnknownHostException) {
                return FormValidation.error((String)"Unknown host: '%s'. Please check the hostname or IP address.", (Object[])new Object[]{cause.getMessage()});
            }
            if (cause instanceof SocketTimeoutException) {
                return FormValidation.error((String)"Connection timed out. The Docker host may be unreachable or behind a firewall.");
            }
            String message = e.getMessage();
            if (message != null) {
                if (message.contains("This node is not a swarm manager")) {
                    return FormValidation.error((String)"Docker is running but Swarm mode is not enabled. Initialize Swarm with: docker swarm init");
                }
                if (message.contains("Unsupported protocol scheme")) {
                    return FormValidation.error((String)"Invalid protocol scheme. Use 'tcp://' for remote connections. Example: tcp://docker-host:2376");
                }
            }
            String sanitizedMessage = message != null ? message.replaceAll("[<>&'\"]", "") : "Unknown error";
            return FormValidation.error((String)"Connection failed: %s", (Object[])new Object[]{sanitizedMessage});
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String dockerHost, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(credentialsId);
            }
            result.includeEmptyValue();
            result.includeMatchingAs(item instanceof Queue.Task ? ((Queue.Task)item).getDefaultAuthentication() : ACL.SYSTEM, item, DockerServerCredentials.class, dockerHost != null && !dockerHost.isBlank() ? URIRequirementBuilder.fromUri((String)dockerHost).build() : URIRequirementBuilder.create().build(), CredentialsMatchers.always());
            return result;
        }

        @POST
        public FormValidation doCheckCredentialsId(@AncestorInPath Item item, @QueryParameter String value, @QueryParameter String dockerHost) {
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return FormValidation.ok();
            }
            if (value == null || value.isBlank()) {
                return FormValidation.ok();
            }
            if (CredentialsProvider.listCredentials(DockerServerCredentials.class, (Item)item, (Authentication)(item instanceof Queue.Task ? ((Queue.Task)item).getDefaultAuthentication() : ACL.SYSTEM), (List)(dockerHost != null && !dockerHost.isBlank() ? URIRequirementBuilder.fromUri((String)dockerHost).build() : URIRequirementBuilder.create().build()), (CredentialsMatcher)CredentialsMatchers.withId((String)value)).isEmpty()) {
                return FormValidation.error((String)"Cannot find currently selected credentials");
            }
            return FormValidation.ok();
        }
    }
}

