/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.swarmcloud.pipeline;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.Cloud;
import io.jenkins.plugins.swarmcloud.SwarmAgent;
import io.jenkins.plugins.swarmcloud.SwarmAgentTemplate;
import io.jenkins.plugins.swarmcloud.SwarmCloud;
import io.jenkins.plugins.swarmcloud.monitoring.SwarmAuditLog;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SwarmAgentStep
extends Step
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(SwarmAgentStep.class.getName());
    private final String cloud;
    private String template;
    private String image;
    private String label;
    private int numExecutors;
    private String cpuLimit;
    private String memoryLimit;
    private int idleTimeout;
    private int connectionTimeout;

    @DataBoundConstructor
    public SwarmAgentStep(@NonNull String cloud) {
        this.cloud = cloud;
        this.numExecutors = 1;
        this.idleTimeout = 60;
        this.connectionTimeout = 300;
    }

    @NonNull
    public String getCloud() {
        return this.cloud;
    }

    @Nullable
    public String getTemplate() {
        return this.template;
    }

    @DataBoundSetter
    public void setTemplate(String template) {
        this.template = template;
    }

    @Nullable
    public String getImage() {
        return this.image;
    }

    @DataBoundSetter
    public void setImage(String image) {
        this.image = image;
    }

    @Nullable
    public String getLabel() {
        return this.label;
    }

    @DataBoundSetter
    public void setLabel(String label) {
        this.label = label;
    }

    public int getNumExecutors() {
        return this.numExecutors;
    }

    @DataBoundSetter
    public void setNumExecutors(int numExecutors) {
        this.numExecutors = numExecutors > 0 ? numExecutors : 1;
    }

    @Nullable
    public String getCpuLimit() {
        return this.cpuLimit;
    }

    @DataBoundSetter
    public void setCpuLimit(String cpuLimit) {
        this.cpuLimit = cpuLimit;
    }

    @Nullable
    public String getMemoryLimit() {
        return this.memoryLimit;
    }

    @DataBoundSetter
    public void setMemoryLimit(String memoryLimit) {
        this.memoryLimit = memoryLimit;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    @DataBoundSetter
    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout > 0 ? idleTimeout : 60;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @DataBoundSetter
    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout > 0 ? connectionTimeout : 300;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new SwarmAgentStepExecution(this, context);
    }

    private static class SwarmAgentStepExecution
    extends StepExecution {
        private static final long serialVersionUID = 1L;
        private final SwarmAgentStep step;
        private String agentName;
        private String cloudName;

        SwarmAgentStepExecution(SwarmAgentStep step, StepContext context) {
            super(context);
            this.step = step;
            this.cloudName = step.getCloud();
        }

        public boolean start() throws Exception {
            SwarmAgentTemplate agentTemplate;
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            PrintStream logger = listener != null ? listener.getLogger() : System.out;
            logger.println("=== Swarm Agent Pipeline Step ===");
            logger.println("Provisioning Swarm agent from cloud: " + this.step.getCloud());
            Jenkins jenkins = Jenkins.get();
            SwarmCloud swarmCloud = null;
            for (Cloud cloud : jenkins.clouds) {
                if (!(cloud instanceof SwarmCloud) || !cloud.name.equals(this.step.getCloud())) continue;
                swarmCloud = (SwarmCloud)cloud;
                break;
            }
            if (swarmCloud == null) {
                this.getContext().onFailure((Throwable)new IllegalArgumentException("Swarm cloud not found: " + this.step.getCloud()));
                return true;
            }
            if (this.step.getTemplate() != null && !this.step.getTemplate().isBlank()) {
                agentTemplate = swarmCloud.getTemplateByName(this.step.getTemplate());
                if (agentTemplate == null) {
                    this.getContext().onFailure((Throwable)new IllegalArgumentException("Template not found: " + this.step.getTemplate()));
                    return true;
                }
                logger.println("Using template: " + this.step.getTemplate());
            } else {
                String inlineName = "pipeline-" + System.currentTimeMillis();
                agentTemplate = new SwarmAgentTemplate(inlineName);
                if (this.step.getImage() != null && !this.step.getImage().isBlank()) {
                    agentTemplate.setImage(this.step.getImage());
                }
                if (this.step.getLabel() != null && !this.step.getLabel().isBlank()) {
                    agentTemplate.setLabelString(this.step.getLabel());
                }
                agentTemplate.setNumExecutors(this.step.getNumExecutors());
                if (this.step.getCpuLimit() != null && !this.step.getCpuLimit().isBlank()) {
                    agentTemplate.setCpuLimit(this.step.getCpuLimit());
                }
                if (this.step.getMemoryLimit() != null && !this.step.getMemoryLimit().isBlank()) {
                    agentTemplate.setMemoryLimit(this.step.getMemoryLimit());
                }
                agentTemplate.setMaxInstances(1);
                agentTemplate.setIdleTimeoutMinutes(this.step.getIdleTimeout());
                agentTemplate.setConnectionTimeoutSeconds(this.step.getConnectionTimeout());
                logger.println("Using inline template with image: " + agentTemplate.getImage());
            }
            if (!swarmCloud.canProvision()) {
                this.getContext().onFailure((Throwable)new IllegalStateException("Cannot provision: max concurrent agents reached for cloud " + this.step.getCloud()));
                return true;
            }
            this.agentName = agentTemplate.generateAgentName();
            logger.println("Creating Swarm service for agent: " + this.agentName);
            try {
                String serviceId = swarmCloud.getDockerClient().createService(this.agentName, agentTemplate, swarmCloud.getEffectiveJenkinsUrl(), swarmCloud.getSwarmNetwork());
                logger.println("Created Docker Swarm service: " + serviceId);
                SwarmAgent agent = new SwarmAgent(this.agentName, agentTemplate, swarmCloud.name, serviceId, this.step.getIdleTimeout());
                jenkins.addNode((Node)agent);
                logger.println("Agent registered: " + this.agentName);
                logger.println("Agent label: " + (this.step.getLabel() != null ? this.step.getLabel() : agentTemplate.getLabelString()));
                SwarmAuditLog.logProvision(swarmCloud.name, agentTemplate.getName(), this.agentName, serviceId);
                this.getContext().newBodyInvoker().withCallback((BodyExecutionCallback)new SwarmAgentCallback(this.agentName, this.cloudName)).start();
                return false;
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to provision pipeline agent", e);
                SwarmAuditLog.logProvisionFailure(swarmCloud.name, agentTemplate.getName(), e.getMessage());
                this.getContext().onFailure((Throwable)e);
                return true;
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.SEVERE, "Unexpected error provisioning pipeline agent", e);
                SwarmAuditLog.logProvisionFailure(swarmCloud.name, agentTemplate.getName(), e.getMessage());
                this.getContext().onFailure((Throwable)e);
                return true;
            }
        }

        public void stop(Throwable cause) throws Exception {
            this.terminateAgent();
        }

        public void onResume() {
        }

        private void terminateAgent() {
            if (this.agentName != null) {
                try {
                    Node node;
                    Jenkins jenkins = Jenkins.getInstanceOrNull();
                    if (jenkins != null && (node = jenkins.getNode(this.agentName)) instanceof SwarmAgent) {
                        jenkins.removeNode(node);
                        LOGGER.log(Level.FINE, "Terminated pipeline agent: {0}", this.agentName);
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to terminate agent: " + this.agentName, e);
                }
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "swarmAgent";
        }

        @NonNull
        public String getDisplayName() {
            return "Provision Docker Swarm Agent";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            HashSet<Class> context = new HashSet<Class>();
            context.add(TaskListener.class);
            context.add(FlowNode.class);
            return context;
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }
    }

    private static class SwarmAgentCallback
    extends BodyExecutionCallback {
        private static final long serialVersionUID = 1L;
        private final String agentName;
        private final String cloudName;

        SwarmAgentCallback(String agentName, String cloudName) {
            this.agentName = agentName;
            this.cloudName = cloudName;
        }

        public void onSuccess(StepContext context, Object result) {
            try {
                TaskListener listener = (TaskListener)context.get(TaskListener.class);
                if (listener != null) {
                    listener.getLogger().println("Swarm agent pipeline step completed successfully");
                }
                context.onSuccess(result);
            }
            catch (IOException | InterruptedException e) {
                context.onFailure((Throwable)e);
            }
        }

        public void onFailure(StepContext context, Throwable t) {
            try {
                TaskListener listener = (TaskListener)context.get(TaskListener.class);
                if (listener != null) {
                    listener.getLogger().println("Swarm agent pipeline step failed: " + t.getMessage());
                }
                this.terminateAgent();
            }
            catch (IOException | InterruptedException e) {
                LOGGER.log(Level.FINE, "Cleanup error during onFailure", e);
            }
            context.onFailure(t);
        }

        private void terminateAgent() {
            if (this.agentName != null) {
                try {
                    Node node;
                    Jenkins jenkins = Jenkins.getInstanceOrNull();
                    if (jenkins != null && (node = jenkins.getNode(this.agentName)) instanceof SwarmAgent) {
                        jenkins.removeNode(node);
                        LOGGER.log(Level.FINE, "Terminated pipeline agent on failure: {0}", this.agentName);
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to terminate agent: " + this.agentName, e);
                }
            }
        }
    }
}

