/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.swarmcloud.api;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateServiceCmd;
import com.github.dockerjava.api.command.CreateServiceResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.Config;
import com.github.dockerjava.api.model.ContainerDNSConfig;
import com.github.dockerjava.api.model.ContainerSpec;
import com.github.dockerjava.api.model.ContainerSpecConfig;
import com.github.dockerjava.api.model.ContainerSpecFile;
import com.github.dockerjava.api.model.ContainerSpecPrivileges;
import com.github.dockerjava.api.model.ContainerSpecSecret;
import com.github.dockerjava.api.model.EndpointSpec;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.HealthCheck;
import com.github.dockerjava.api.model.Mount;
import com.github.dockerjava.api.model.MountType;
import com.github.dockerjava.api.model.NetworkAttachmentConfig;
import com.github.dockerjava.api.model.PortConfig;
import com.github.dockerjava.api.model.PortConfigProtocol;
import com.github.dockerjava.api.model.ResourceRequirements;
import com.github.dockerjava.api.model.ResourceSpecs;
import com.github.dockerjava.api.model.ResourceVersion;
import com.github.dockerjava.api.model.Secret;
import com.github.dockerjava.api.model.SecretSpec;
import com.github.dockerjava.api.model.Service;
import com.github.dockerjava.api.model.ServiceModeConfig;
import com.github.dockerjava.api.model.ServicePlacement;
import com.github.dockerjava.api.model.ServiceReplicatedModeOptions;
import com.github.dockerjava.api.model.ServiceRestartCondition;
import com.github.dockerjava.api.model.ServiceRestartPolicy;
import com.github.dockerjava.api.model.ServiceSpec;
import com.github.dockerjava.api.model.Swarm;
import com.github.dockerjava.api.model.Task;
import com.github.dockerjava.api.model.TaskSpec;
import com.github.dockerjava.api.model.TaskState;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.core.command.LogContainerResultCallback;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jenkins.plugins.swarmcloud.SwarmAgentTemplate;
import io.jenkins.plugins.swarmcloud.SwarmComputerLauncher;
import io.jenkins.plugins.swarmcloud.SwarmConfigFile;
import io.jenkins.plugins.swarmcloud.SwarmSecretConfig;
import io.jenkins.plugins.swarmcloud.config.DockerCredentialsHelper;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerCredentials;

public class DockerSwarmClient
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(DockerSwarmClient.class.getName());
    private final DockerClient dockerClient;
    private final String dockerHost;

    public DockerSwarmClient(@NonNull String dockerHost, @Nullable String credentialsId) {
        this.dockerHost = dockerHost;
        DefaultDockerClientConfig.Builder configBuilder = DefaultDockerClientConfig.createDefaultConfigBuilder().withDockerHost(dockerHost).withDockerTlsVerify(Boolean.valueOf(false));
        com.github.dockerjava.core.SSLConfig sslConfig = null;
        if (credentialsId != null && !credentialsId.isBlank()) {
            DockerServerCredentials credentials = DockerCredentialsHelper.lookupCredentials(credentialsId, dockerHost);
            if (credentials != null) {
                LOGGER.log(Level.FINE, "Configuring TLS with credentials: {0}", credentialsId);
                try {
                    sslConfig = this.createSslConfig(credentials);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to configure TLS, falling back to insecure connection", e);
                }
            } else {
                LOGGER.log(Level.WARNING, "Credentials not found: {0}", credentialsId);
            }
        }
        DefaultDockerClientConfig config = configBuilder.build();
        ApacheDockerHttpClient.Builder httpClientBuilder = new ApacheDockerHttpClient.Builder().dockerHost(config.getDockerHost()).maxConnections(100).connectionTimeout(Duration.ofSeconds(30L)).responseTimeout(Duration.ofSeconds(45L));
        if (sslConfig != null) {
            httpClientBuilder.sslConfig((SSLConfig)sslConfig);
        } else {
            httpClientBuilder.sslConfig((SSLConfig)config.getSSLConfig());
        }
        ApacheDockerHttpClient httpClient = httpClientBuilder.build();
        this.dockerClient = DockerClientImpl.getInstance((DockerClientConfig)config, (DockerHttpClient)httpClient);
    }

    @Nullable
    private com.github.dockerjava.core.SSLConfig createSslConfig(DockerServerCredentials credentials) throws Exception {
        final String caCert = DockerCredentialsHelper.getCaCertificate(credentials);
        final String clientCert = DockerCredentialsHelper.getClientCertificate(credentials);
        final String clientKey = DockerCredentialsHelper.getClientKey(credentials);
        if (caCert == null || clientCert == null || clientKey == null) {
            LOGGER.log(Level.WARNING, "Incomplete TLS credentials - missing certificate or key");
            return null;
        }
        return new com.github.dockerjava.core.SSLConfig(){

            public SSLContext getSSLContext() {
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    X509Certificate caCertificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(caCert.getBytes(StandardCharsets.UTF_8)));
                    X509Certificate clientCertificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(clientCert.getBytes(StandardCharsets.UTF_8)));
                    PrivateKey privateKey = DockerSwarmClient.this.loadPrivateKey(clientKey);
                    KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    trustStore.load(null, null);
                    trustStore.setCertificateEntry("ca", caCertificate);
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init(trustStore);
                    KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    keyStore.load(null, null);
                    keyStore.setKeyEntry("client", privateKey, "docker".toCharArray(), new Certificate[]{clientCertificate});
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    kmf.init(keyStore, "docker".toCharArray());
                    SSLContext sslContext = SSLContext.getInstance("TLS");
                    sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
                    return sslContext;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create SSL context", e);
                }
            }
        };
    }

    private PrivateKey loadPrivateKey(String pemKey) throws Exception {
        try (PEMParser pemParser = new PEMParser((Reader)new StringReader(pemKey));){
            Object object = pemParser.readObject();
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
            if (object instanceof PEMKeyPair) {
                PEMKeyPair keyPair = (PEMKeyPair)object;
                PrivateKey privateKey = converter.getPrivateKey(keyPair.getPrivateKeyInfo());
                return privateKey;
            }
            if (object instanceof PrivateKeyInfo) {
                PrivateKey privateKey = converter.getPrivateKey((PrivateKeyInfo)object);
                return privateKey;
            }
            throw new IllegalArgumentException("Unsupported key format. Expected PEM private key, got: " + (object != null ? object.getClass().getName() : "null"));
        }
    }

    @NonNull
    public String getSwarmVersion() {
        try {
            Swarm swarm = this.dockerClient.inspectSwarmCmd().exec();
            ResourceVersion version = swarm.getVersion();
            return version != null ? String.valueOf(version.getIndex()) : "unknown";
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to get Swarm version", e);
            return "unknown";
        }
    }

    public int getNodeCount() {
        try {
            List nodes = (List)this.dockerClient.listSwarmNodesCmd().exec();
            return nodes.size();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to get node count", e);
            return 0;
        }
    }

    @NonNull
    public String createService(@NonNull String agentName, @NonNull SwarmAgentTemplate template, @NonNull String jenkinsUrl, @NonNull String secret, @Nullable String networkName) {
        List<SwarmAgentTemplate.PortBinding> portBindings;
        ServicePlacement placement;
        List<ContainerSpecConfig> configRefs;
        List<ContainerSpecSecret> secretRefs;
        boolean hasCustomCommand;
        LOGGER.log(Level.FINE, "Creating service for agent: {0}, template: {1}, image: {2}", new Object[]{agentName, template.getName(), template.getImage()});
        List<String> env = this.buildEnvironmentVariables(template, jenkinsUrl, agentName, secret);
        ContainerSpec containerSpec = new ContainerSpec().withImage(template.getImage()).withEnv(env);
        List<Mount> mounts = this.buildMounts(template);
        if (!mounts.isEmpty()) {
            containerSpec.withMounts(mounts);
        }
        if (template.getCommand() != null && !template.getCommand().isBlank()) {
            List<String> commandParts = this.parseCommand(template.getCommand());
            containerSpec.withCommand(commandParts);
            LOGGER.log(Level.FINE, "Container command configured: {0}", commandParts);
        }
        boolean bl = hasCustomCommand = template.getCommand() != null && !template.getCommand().isBlank();
        if (!template.isDisableContainerArgs() && !hasCustomCommand) {
            List<String> args = List.of(jenkinsUrl, secret, agentName);
            containerSpec.withArgs(args);
            LOGGER.log(Level.FINE, "Container args configured for {0}", agentName);
        } else {
            LOGGER.log(Level.FINE, "Container args disabled for {0} (customCommand={1}, disableArgs={2})", new Object[]{agentName, hasCustomCommand, template.isDisableContainerArgs()});
        }
        containerSpec.withDir(template.getRemoteFs());
        if (template.hasHealthCheck()) {
            HealthCheck healthCheck = new HealthCheck().withTest(List.of("CMD-SHELL", template.getHealthCheckCommand())).withInterval(Long.valueOf(Duration.ofSeconds(template.getHealthCheckIntervalSeconds()).toNanos())).withTimeout(Long.valueOf(Duration.ofSeconds(template.getHealthCheckTimeoutSeconds()).toNanos())).withRetries(Integer.valueOf(template.getHealthCheckRetries()));
            containerSpec.withHealthCheck(healthCheck);
        }
        if (!(secretRefs = this.buildSecretReferences(template)).isEmpty()) {
            containerSpec.withSecrets(secretRefs);
        }
        if (!(configRefs = this.buildConfigReferences(template)).isEmpty()) {
            containerSpec.withConfigs(configRefs);
        }
        this.applyAdvancedContainerOptions(containerSpec, template);
        TaskSpec taskSpec = new TaskSpec().withContainerSpec(containerSpec);
        ResourceRequirements resources = this.buildResourceRequirements(template);
        if (resources != null) {
            taskSpec.withResources(resources);
        }
        if ((placement = this.buildPlacement(template)) != null) {
            taskSpec.withPlacement(placement);
        }
        taskSpec.withRestartPolicy(new ServiceRestartPolicy().withCondition(ServiceRestartCondition.ON_FAILURE).withMaxAttempts(Long.valueOf(3L)).withDelay(Long.valueOf(5000000000L)));
        ServiceSpec serviceSpec = new ServiceSpec().withName(agentName).withTaskTemplate(taskSpec).withMode(new ServiceModeConfig().withReplicated(new ServiceReplicatedModeOptions().withReplicas(1)));
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("jenkins.agent", "true");
        labels.put("jenkins.agent.name", agentName);
        labels.put("jenkins.template", template.getName());
        labels.put("jenkins.cloud", "swarm-agents-cloud");
        labels.put("jenkins.created", String.valueOf(System.currentTimeMillis()));
        serviceSpec.withLabels(labels);
        if (networkName != null && !networkName.isBlank()) {
            NetworkAttachmentConfig networkConfig = new NetworkAttachmentConfig().withTarget(networkName);
            List<String> aliases = template.getNetworkAliases();
            if (!aliases.isEmpty()) {
                networkConfig.withAliases(aliases);
            }
            serviceSpec.withNetworks(List.of(networkConfig));
        }
        if (!(portBindings = template.getPortBindings()).isEmpty()) {
            ArrayList<PortConfig> ports = new ArrayList<PortConfig>();
            for (SwarmAgentTemplate.PortBinding binding : portBindings) {
                PortConfig portConfig = new PortConfig().withTargetPort(binding.getTargetPort()).withProtocol(PortConfigProtocol.valueOf((String)binding.getProtocol().toUpperCase(Locale.ROOT))).withPublishMode(PortConfig.PublishMode.ingress);
                if (binding.getPublishedPort() > 0) {
                    portConfig.withPublishedPort(binding.getPublishedPort());
                }
                ports.add(portConfig);
            }
            EndpointSpec endpointSpec = new EndpointSpec().withPorts(ports);
            serviceSpec.withEndpointSpec(endpointSpec);
            LOGGER.log(Level.FINE, "Configured {0} port binding(s) for service {1}", new Object[]{ports.size(), agentName});
        }
        CreateServiceCmd createServiceCmd = this.dockerClient.createServiceCmd(serviceSpec);
        String registryCredentialsId = template.getRegistryCredentialsId();
        if (registryCredentialsId != null && !registryCredentialsId.isBlank()) {
            String registryAddress = DockerCredentialsHelper.extractRegistryAddress(template.getImage());
            AuthConfig authConfig = DockerCredentialsHelper.createAuthConfig(registryCredentialsId, registryAddress);
            if (authConfig != null) {
                createServiceCmd.withAuthConfig(authConfig);
                LOGGER.log(Level.FINE, "Using registry auth for image {0}, registry: {1}", new Object[]{template.getImage(), registryAddress});
            } else {
                LOGGER.log(Level.WARNING, "Registry credentials not found: {0}", registryCredentialsId);
            }
        }
        CreateServiceResponse response = createServiceCmd.exec();
        String serviceId = response.getId();
        LOGGER.log(Level.FINE, "Created service: {0} with ID: {1}", new Object[]{agentName, serviceId});
        template.incrementInstances();
        return serviceId;
    }

    @NonNull
    public String createService(@NonNull String agentName, @NonNull SwarmAgentTemplate template, @NonNull String jenkinsUrl, @Nullable String networkName) {
        String secret = SwarmComputerLauncher.getAgentSecret(agentName);
        return this.createService(agentName, template, jenkinsUrl, secret, networkName);
    }

    public void removeService(@NonNull String serviceId) {
        LOGGER.log(Level.FINE, "Removing service: {0}", serviceId);
        try {
            this.dockerClient.removeServiceCmd(serviceId).exec();
            LOGGER.log(Level.FINE, "Removed service: {0}", serviceId);
        }
        catch (NotFoundException e) {
            LOGGER.log(Level.FINE, "Service {0} already removed (not found)", serviceId);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to remove service: " + serviceId, e);
            throw new RuntimeException("Failed to remove service: " + serviceId, e);
        }
    }

    @Nullable
    public Service getService(@NonNull String serviceId) {
        try {
            return this.dockerClient.inspectServiceCmd(serviceId).exec();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Failed to inspect service: " + serviceId, e);
            return null;
        }
    }

    @Nullable
    public String getServiceLogs(@NonNull String serviceId, int tailLines) {
        try {
            final StringBuilder logs = new StringBuilder();
            (this.dockerClient.logServiceCmd(serviceId).withStdout(Boolean.valueOf(true)).withStderr(Boolean.valueOf(true)).withTail(Integer.valueOf(tailLines)).withTimestamps(Boolean.valueOf(true)).exec((ResultCallback)new LogContainerResultCallback(this){

                public void onNext(Frame frame) {
                    logs.append(new String(frame.getPayload(), StandardCharsets.UTF_8));
                }
            })).awaitCompletion(10L, TimeUnit.SECONDS);
            return logs.toString();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to get service logs: " + serviceId, e);
            return null;
        }
    }

    @NonNull
    public List<Service> listJenkinsServices() {
        try {
            return (List)this.dockerClient.listServicesCmd().withLabelFilter(Map.of("jenkins.agent", "true")).exec();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to list Jenkins services", e);
            return List.of();
        }
    }

    @NonNull
    public List<Service> listServicesForCloud(@NonNull String cloudName) {
        try {
            return (List)this.dockerClient.listServicesCmd().withLabelFilter(Map.of("jenkins.agent", "true", "jenkins.cloud", cloudName)).exec();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to list services for cloud: " + cloudName, e);
            return List.of();
        }
    }

    @NonNull
    public List<Task> getServiceTasks(@NonNull String serviceId) {
        try {
            return this.dockerClient.listTasksCmd().withServiceFilter(new String[]{serviceId}).exec();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to get tasks for service: " + serviceId, e);
            return List.of();
        }
    }

    public boolean isServiceRunning(@NonNull String serviceId) {
        return this.getServiceTasks(serviceId).stream().map(Task::getStatus).anyMatch(status -> status != null && status.getState() == TaskState.RUNNING);
    }

    private List<String> buildEnvironmentVariables(SwarmAgentTemplate template, String jenkinsUrl, String agentName, String secret) {
        ArrayList<String> env = new ArrayList<String>();
        env.add("JENKINS_URL=" + jenkinsUrl);
        env.add("JENKINS_AGENT_NAME=" + agentName);
        env.add("JENKINS_SECRET=" + secret);
        env.add("JENKINS_WEB_SOCKET=true");
        env.add("JENKINS_AGENT_WORKDIR=" + template.getRemoteFs());
        env.add("JNLP_URL=" + jenkinsUrl);
        env.add("JENKINS_JNLP_URL=" + jenkinsUrl);
        String jenkinsUrlNormalized = jenkinsUrl.replaceAll("/$", "");
        env.add("DOCKER_SWARM_PLUGIN_JENKINS_AGENT_JAR_URL=" + jenkinsUrlNormalized + "/jnlpJars/agent.jar");
        env.add("DOCKER_SWARM_PLUGIN_JENKINS_AGENT_JNLP_URL=" + jenkinsUrlNormalized + "/computer/" + agentName + "/jenkins-agent.jnlp");
        env.add("DOCKER_SWARM_PLUGIN_JENKINS_AGENT_SECRET=" + secret);
        env.add("JENKINS_DIRECT_CONNECTION=" + jenkinsUrlNormalized.replace("http://", "").replace("https://", ""));
        for (SwarmAgentTemplate.EnvironmentVariable var : template.getEnvironmentVariables()) {
            env.add(var.getName() + "=" + var.getValue());
        }
        return env;
    }

    private List<Mount> buildMounts(SwarmAgentTemplate template) {
        ArrayList<Mount> mounts = new ArrayList<Mount>();
        for (SwarmAgentTemplate.MountConfig config : template.getMounts()) {
            Mount mount = new Mount().withTarget(config.getTarget()).withReadOnly(Boolean.valueOf(config.isReadOnly()));
            SwarmAgentTemplate.SwarmMountType mountType = config.getType();
            if (mountType == SwarmAgentTemplate.SwarmMountType.TMPFS) {
                mount.withType(MountType.TMPFS);
            } else if (mountType == SwarmAgentTemplate.SwarmMountType.BIND) {
                mount.withType(MountType.BIND);
                mount.withSource(config.getSource());
            } else {
                mount.withType(MountType.VOLUME);
                mount.withSource(config.getSource());
            }
            mounts.add(mount);
        }
        for (String cacheDir : template.getCacheDirs()) {
            if (cacheDir == null || cacheDir.isBlank() || !cacheDir.startsWith("/")) continue;
            Mount cacheMount = new Mount().withType(MountType.TMPFS).withTarget(cacheDir.trim()).withReadOnly(Boolean.valueOf(false));
            mounts.add(cacheMount);
            LOGGER.log(Level.FINE, "Added cache directory as tmpfs: {0}", cacheDir);
        }
        return mounts;
    }

    @Nullable
    private ResourceRequirements buildResourceRequirements(SwarmAgentTemplate template) {
        ResourceSpecs limits = null;
        ResourceSpecs reservations = null;
        if (template.getCpuLimit() != null || template.getMemoryLimit() != null) {
            limits = new ResourceSpecs();
            if (template.getCpuLimit() != null) {
                limits.withNanoCPUs(this.parseNanoCPUs(template.getCpuLimit()));
            }
            if (template.getMemoryLimit() != null) {
                limits.withMemoryBytes(this.parseMemoryBytes(template.getMemoryLimit()));
            }
        }
        if (template.getCpuReservation() != null || template.getMemoryReservation() != null) {
            reservations = new ResourceSpecs();
            if (template.getCpuReservation() != null) {
                reservations.withNanoCPUs(this.parseNanoCPUs(template.getCpuReservation()));
            }
            if (template.getMemoryReservation() != null) {
                reservations.withMemoryBytes(this.parseMemoryBytes(template.getMemoryReservation()));
            }
        }
        if (limits != null || reservations != null) {
            ResourceRequirements resources = new ResourceRequirements();
            if (limits != null) {
                resources.withLimits(limits);
            }
            if (reservations != null) {
                resources.withReservations(reservations);
            }
            return resources;
        }
        return null;
    }

    @Nullable
    private ServicePlacement buildPlacement(SwarmAgentTemplate template) {
        List<String> constraints = template.getPlacementConstraints();
        if (constraints.isEmpty()) {
            return null;
        }
        return new ServicePlacement().withConstraints(constraints);
    }

    @NonNull
    private List<ContainerSpecSecret> buildSecretReferences(SwarmAgentTemplate template) {
        ArrayList<ContainerSpecSecret> refs = new ArrayList<ContainerSpecSecret>();
        for (SwarmSecretConfig secretConfig : template.getSecrets()) {
            try {
                String secretId = this.findSecretId(secretConfig.getSecretName());
                if (secretId == null) {
                    LOGGER.log(Level.WARNING, "Secret not found: {0}", secretConfig.getSecretName());
                    continue;
                }
                String uid = secretConfig.getUid() != null ? secretConfig.getUid() : "0";
                String gid = secretConfig.getGid() != null ? secretConfig.getGid() : "0";
                long mode = secretConfig.getFileModeAsLong() != null ? secretConfig.getFileModeAsLong() : 292L;
                ContainerSpecSecret ref = new ContainerSpecSecret().withSecretId(secretId).withSecretName(secretConfig.getSecretName()).withFile(new ContainerSpecFile().withName(secretConfig.getEffectiveFileName()).withUid(uid).withGid(gid).withMode(Long.valueOf(mode)));
                refs.add(ref);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to configure secret: " + secretConfig.getSecretName(), e);
            }
        }
        return refs;
    }

    @Nullable
    private String findSecretId(String secretName) {
        try {
            List secrets = (List)this.dockerClient.listSecretsCmd().withNameFilter(List.of(secretName)).exec();
            if (!secrets.isEmpty()) {
                return ((Secret)secrets.get(0)).getId();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to find secret: " + secretName, e);
        }
        return null;
    }

    @NonNull
    private List<ContainerSpecConfig> buildConfigReferences(SwarmAgentTemplate template) {
        ArrayList<ContainerSpecConfig> refs = new ArrayList<ContainerSpecConfig>();
        for (SwarmConfigFile configFile : template.getConfigs()) {
            try {
                String configId = this.findConfigId(configFile.getConfigName());
                if (configId == null) {
                    LOGGER.log(Level.WARNING, "Config not found: {0}", configFile.getConfigName());
                    continue;
                }
                String uid = configFile.getUid() != null ? configFile.getUid() : "0";
                String gid = configFile.getGid() != null ? configFile.getGid() : "0";
                long mode = configFile.getFileModeAsLong() != null ? configFile.getFileModeAsLong() : 292L;
                ContainerSpecConfig ref = new ContainerSpecConfig().withConfigID(configId).withConfigName(configFile.getConfigName()).withFile(new ContainerSpecFile().withName(configFile.getEffectiveTargetPath()).withUid(uid).withGid(gid).withMode(Long.valueOf(mode)));
                refs.add(ref);
                LOGGER.log(Level.FINE, "Added config: {0} -> {1}", new Object[]{configFile.getConfigName(), configFile.getEffectiveTargetPath()});
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to configure config: " + configFile.getConfigName(), e);
            }
        }
        return refs;
    }

    @Nullable
    private String findConfigId(String configName) {
        try {
            HashMap<String, List<String>> filters = new HashMap<String, List<String>>();
            filters.put("name", List.of(configName));
            List configs = (List)this.dockerClient.listConfigsCmd().withFilters(filters).exec();
            for (Config config : configs) {
                if (!configName.equals(config.getSpec().getName())) continue;
                return config.getId();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to find config: " + configName, e);
        }
        return null;
    }

    @NonNull
    public String createConfig(@NonNull String name, @NonNull byte[] data) {
        return this.dockerClient.createConfigCmd().withName(name).withData(data).exec().getId();
    }

    public void deleteConfig(@NonNull String configId) {
        try {
            this.dockerClient.removeConfigCmd(configId).exec();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to delete config: " + configId, e);
        }
    }

    @NonNull
    public List<Config> listConfigs() {
        try {
            return (List)this.dockerClient.listConfigsCmd().exec();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to list configs", e);
            return List.of();
        }
    }

    @NonNull
    public String createSecret(@NonNull String name, @NonNull byte[] data) {
        SecretSpec spec = new SecretSpec().withName(name).withData(Base64.getEncoder().encodeToString(data));
        return this.dockerClient.createSecretCmd(spec).exec().getId();
    }

    public void deleteSecret(@NonNull String secretId) {
        try {
            this.dockerClient.removeSecretCmd(secretId).exec();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to delete secret: " + secretId, e);
        }
    }

    @NonNull
    public List<Secret> listSecrets() {
        try {
            return (List)this.dockerClient.listSecretsCmd().exec();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to list secrets", e);
            return List.of();
        }
    }

    private void applyAdvancedContainerOptions(ContainerSpec containerSpec, SwarmAgentTemplate template) {
        List<String> sysctls;
        long stopGracePeriod;
        List hostsForDocker;
        List<String> extraHosts;
        List<String> capAdd = template.getCapAdd();
        List<String> capDrop = template.getCapDrop();
        if (!capAdd.isEmpty()) {
            LOGGER.log(Level.FINE, "Requested capabilities to add (limited support in Swarm): {0}", capAdd);
        }
        if (!capDrop.isEmpty()) {
            LOGGER.log(Level.FINE, "Requested capabilities to drop (limited support in Swarm): {0}", capDrop);
        }
        if (template.isPrivileged()) {
            containerSpec.withPrivileges(new ContainerSpecPrivileges());
            LOGGER.log(Level.FINE, "Running container in privileged mode");
        }
        if (DockerSwarmClient.isNotBlank(template.getUser())) {
            containerSpec.withUser(template.getUser());
        }
        if (DockerSwarmClient.isNotBlank(template.getHostname())) {
            containerSpec.withHostname(template.getHostname());
        }
        List<String> dnsServers = template.getDnsServers();
        List<String> dnsOptions = template.getDnsOptions();
        List<String> dnsSearch = template.getDnsSearch();
        if (!(dnsServers.isEmpty() && dnsOptions.isEmpty() && dnsSearch.isEmpty())) {
            ContainerDNSConfig dnsConfig = new ContainerDNSConfig();
            if (!dnsServers.isEmpty()) {
                dnsConfig.withNameservers(dnsServers);
            }
            if (!dnsOptions.isEmpty()) {
                dnsConfig.withOptions(dnsOptions);
            }
            if (!dnsSearch.isEmpty()) {
                dnsConfig.withSearch(dnsSearch);
            }
            containerSpec.withDnsConfig(dnsConfig);
        }
        if (!(extraHosts = template.getExtraHosts()).isEmpty() && !(hostsForDocker = extraHosts.stream().map(this::convertHostEntryToDockerFormat).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            containerSpec.withHosts(hostsForDocker);
            LOGGER.log(Level.FINE, "Configured {0} extra host(s) for container", hostsForDocker.size());
        }
        if (DockerSwarmClient.isNotBlank(template.getStopSignal())) {
            containerSpec.withStopSignal(template.getStopSignal());
        }
        if ((stopGracePeriod = template.getStopGracePeriod()) > 0L) {
            containerSpec.withStopGracePeriod(Long.valueOf(stopGracePeriod * 1000000000L));
        }
        if (!(sysctls = template.getSysctls()).isEmpty()) {
            LOGGER.log(Level.FINE, "Sysctls configured: {0}. Note: Limited Swarm support.", sysctls);
        }
        this.applySecurityProfiles(containerSpec, template);
        List<SwarmAgentTemplate.GenericResource> genericResources = template.getGenericResources();
        if (!genericResources.isEmpty()) {
            LOGGER.log(Level.FINE, "Generic resources requested: {0}. Note: Requires Docker daemon configured with node-generic-resources.", genericResources);
        }
    }

    private void applySecurityProfiles(ContainerSpec containerSpec, SwarmAgentTemplate template) {
        String seccompProfile = template.getSeccompProfile();
        String apparmorProfile = template.getApparmorProfile();
        if (!DockerSwarmClient.isNotBlank(seccompProfile) && !DockerSwarmClient.isNotBlank(apparmorProfile)) {
            return;
        }
        ContainerSpecPrivileges privileges = containerSpec.getPrivileges();
        if (privileges == null) {
            privileges = new ContainerSpecPrivileges();
        }
        if (DockerSwarmClient.isNotBlank(seccompProfile)) {
            LOGGER.log(Level.FINE, "Setting Seccomp profile: {0}", seccompProfile);
            if (!"default".equalsIgnoreCase(seccompProfile) && !"unconfined".equalsIgnoreCase(seccompProfile)) {
                LOGGER.log(Level.WARNING, "Custom Seccomp profile '{0}' requires Docker Engine configuration. Using default profile.", seccompProfile);
            }
        }
        if (DockerSwarmClient.isNotBlank(apparmorProfile)) {
            LOGGER.log(Level.FINE, "Setting AppArmor profile: {0}", apparmorProfile);
            if (!"runtime/default".equalsIgnoreCase(apparmorProfile) && !"unconfined".equalsIgnoreCase(apparmorProfile)) {
                LOGGER.log(Level.FINE, "Custom AppArmor profile '{0}' must be loaded on Docker hosts.", apparmorProfile);
            }
        }
        containerSpec.withPrivileges(privileges);
    }

    private long parseNanoCPUs(String cpu) {
        double cpuValue = Double.parseDouble(cpu.trim());
        return (long)(cpuValue * 1.0E9);
    }

    private long parseMemoryBytes(String memory) {
        memory = memory.toLowerCase(Locale.ROOT).trim();
        long multiplier = 1L;
        if (memory.endsWith("g") || memory.endsWith("gb")) {
            multiplier = 0x40000000L;
            memory = memory.replaceAll("[gb]+$", "");
        } else if (memory.endsWith("m") || memory.endsWith("mb")) {
            multiplier = 0x100000L;
            memory = memory.replaceAll("[mb]+$", "");
        } else if (memory.endsWith("k") || memory.endsWith("kb")) {
            multiplier = 1024L;
            memory = memory.replaceAll("[kb]+$", "");
        } else if (memory.endsWith("b")) {
            memory = memory.substring(0, memory.length() - 1);
        }
        return Long.parseLong(memory.trim()) * multiplier;
    }

    @NonNull
    private List<String> parseCommand(@NonNull String command) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        for (int i = 0; i < command.length(); ++i) {
            char c = command.charAt(i);
            if (c == '\\' && i + 1 < command.length()) {
                char next = command.charAt(i + 1);
                if (inDoubleQuote && (next == '\"' || next == '\\' || next == '$' || next == '`')) {
                    current.append(next);
                    ++i;
                    continue;
                }
                if (!inSingleQuote && !inDoubleQuote) {
                    current.append(next);
                    ++i;
                    continue;
                }
            }
            if (c == '\'' && !inDoubleQuote) {
                inSingleQuote = !inSingleQuote;
                continue;
            }
            if (c == '\"' && !inSingleQuote) {
                inDoubleQuote = !inDoubleQuote;
                continue;
            }
            if (Character.isWhitespace(c) && !inSingleQuote && !inDoubleQuote) {
                if (current.length() <= 0) continue;
                result.add(current.toString());
                current.setLength(0);
                continue;
            }
            current.append(c);
        }
        if (current.length() > 0) {
            result.add(current.toString());
        }
        if (inSingleQuote || inDoubleQuote) {
            LOGGER.log(Level.WARNING, "Command has unclosed {0} quote: {1}", new Object[]{inSingleQuote ? "single" : "double", command});
        }
        return List.copyOf(result);
    }

    public DockerClient getDockerClient() {
        return this.dockerClient;
    }

    public String getDockerHost() {
        return this.dockerHost;
    }

    @Override
    public void close() throws IOException {
        if (this.dockerClient != null) {
            this.dockerClient.close();
        }
    }

    @Nullable
    private String convertHostEntryToDockerFormat(String entry) {
        if (entry == null || entry.isBlank()) {
            return null;
        }
        int colonIndex = entry.indexOf(58);
        if (colonIndex <= 0 || colonIndex >= entry.length() - 1) {
            LOGGER.log(Level.WARNING, "Invalid extra host entry format (missing colon or empty parts): {0}", entry);
            return null;
        }
        String hostname = entry.substring(0, colonIndex).trim();
        String ip = entry.substring(colonIndex + 1).trim();
        if (hostname.isEmpty() || ip.isEmpty()) {
            LOGGER.log(Level.WARNING, "Invalid extra host entry (empty hostname or IP): {0}", entry);
            return null;
        }
        return ip + " " + hostname;
    }

    private static boolean isNotBlank(String value) {
        return value != null && !value.isBlank();
    }
}

