/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.swarmcloud;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.ManagementLink;
import hudson.model.RootAction;
import hudson.security.Permission;
import hudson.slaves.Cloud;
import io.jenkins.plugins.swarmcloud.SwarmCloud;
import io.jenkins.plugins.swarmcloud.monitoring.ClusterMonitor;
import io.jenkins.plugins.swarmcloud.monitoring.ClusterStatus;
import io.jenkins.plugins.swarmcloud.monitoring.NodeInfo;
import io.jenkins.plugins.swarmcloud.monitoring.ServiceInfo;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.verb.GET;
import org.kohsuke.stapler.verb.POST;

@Extension
public class SwarmDashboard
extends ManagementLink
implements RootAction {
    public String getIconFileName() {
        return "symbol-cloud-outline plugin-ionicons-api";
    }

    public String getDisplayName() {
        return "Swarm Agents Dashboard";
    }

    public String getUrlName() {
        return "swarm-dashboard";
    }

    public String getDescription() {
        return "Monitor Docker Swarm agents, view cluster status, and manage services";
    }

    @NonNull
    public ManagementLink.Category getCategory() {
        return ManagementLink.Category.STATUS;
    }

    @NonNull
    public Permission getRequiredPermission() {
        return Jenkins.ADMINISTER;
    }

    @NonNull
    public List<SwarmCloud> getSwarmClouds() {
        ArrayList<SwarmCloud> clouds = new ArrayList<SwarmCloud>();
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null) {
            for (Cloud cloud : jenkins.clouds) {
                if (!(cloud instanceof SwarmCloud)) continue;
                clouds.add((SwarmCloud)cloud);
            }
        }
        return clouds;
    }

    @NonNull
    public ClusterStatus getClusterStatus(@NonNull String cloudName) {
        return ClusterMonitor.getStatus(cloudName);
    }

    @NonNull
    public Map<String, ClusterStatus> getAllStatuses() {
        return ClusterMonitor.getAllStatuses();
    }

    public long getLastUpdate() {
        return ClusterMonitor.getLastUpdate();
    }

    @GET
    public void doApi(StaplerRequest req, StaplerResponse rsp, @QueryParameter String cloud) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        JSONObject response = new JSONObject();
        if (cloud != null && !cloud.isBlank()) {
            ClusterStatus status = this.getClusterStatus(cloud);
            response.put("status", (Object)this.statusToJson(status));
        } else {
            JSONArray clouds = new JSONArray();
            for (Map.Entry<String, ClusterStatus> entry : this.getAllStatuses().entrySet()) {
                clouds.add((Object)this.statusToJson(entry.getValue()));
            }
            response.put("clouds", (Object)clouds);
        }
        response.put("lastUpdate", (Object)this.getLastUpdate());
        this.writeJsonResponse(rsp, 200, response.toString());
    }

    private void writeJsonResponse(StaplerResponse rsp, int status, String json) throws IOException {
        rsp.setStatus(status);
        rsp.setContentType("application/json;charset=UTF-8");
        try (PrintWriter writer = rsp.getWriter();){
            writer.write(json);
        }
    }

    @POST
    public HttpResponse doRefresh(@QueryParameter String cloud) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (cloud != null && !cloud.isBlank()) {
            ClusterMonitor.refreshNow(cloud);
            return HttpResponses.ok();
        }
        return HttpResponses.error((int)400, (String)"Cloud name is required");
    }

    @POST
    public HttpResponse doRemoveService(@QueryParameter String cloud, @QueryParameter String serviceId) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (cloud == null || cloud.isBlank() || serviceId == null || serviceId.isBlank()) {
            return HttpResponses.error((int)400, (String)"Cloud name and service ID are required");
        }
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            return HttpResponses.error((int)500, (String)"Jenkins is not available");
        }
        for (Cloud c : jenkins.clouds) {
            if (!(c instanceof SwarmCloud) || !c.name.equals(cloud)) continue;
            SwarmCloud swarmCloud = (SwarmCloud)c;
            try {
                swarmCloud.getDockerClient().removeService(serviceId);
                ClusterMonitor.refreshNow(cloud);
                return HttpResponses.ok();
            }
            catch (Exception e) {
                return HttpResponses.error((int)500, (String)("Failed to remove service: " + e.getMessage()));
            }
        }
        return HttpResponses.error((int)404, (String)("Cloud not found: " + cloud));
    }

    private JSONObject statusToJson(ClusterStatus status) {
        JSONObject json = new JSONObject();
        json.put("cloudName", (Object)status.getCloudName());
        json.put("healthy", (Object)status.isHealthy());
        json.put("errorMessage", (Object)status.getErrorMessage());
        json.put("swarmVersion", (Object)status.getSwarmVersion());
        json.put("totalNodes", (Object)status.getTotalNodes());
        json.put("readyNodes", (Object)status.getReadyNodes());
        json.put("managerNodes", (Object)status.getManagerNodes());
        json.put("totalMemory", (Object)status.getTotalMemory());
        json.put("formattedMemory", (Object)status.getFormattedMemory());
        json.put("totalCpu", (Object)status.getTotalCpu());
        json.put("activeServices", (Object)status.getActiveServices());
        json.put("runningTasks", (Object)status.getRunningTasks());
        json.put("pendingTasks", (Object)status.getPendingTasks());
        json.put("failedTasks", (Object)status.getFailedTasks());
        json.put("maxAgents", (Object)status.getMaxAgents());
        json.put("currentAgents", (Object)status.getCurrentAgents());
        json.put("availableCapacity", (Object)status.getAvailableCapacity());
        json.put("utilizationPercent", (Object)status.getUtilizationPercent());
        json.put("statusClass", (Object)status.getStatusClass());
        json.put("lastUpdate", (Object)status.getLastUpdate());
        JSONArray nodes = new JSONArray();
        for (NodeInfo node : status.getNodes()) {
            JSONObject n = new JSONObject();
            n.put("id", (Object)node.getId());
            n.put("hostname", (Object)node.getHostname());
            n.put("state", (Object)node.getState());
            n.put("role", (Object)node.getRole());
            n.put("memoryBytes", (Object)node.getMemoryBytes());
            n.put("formattedMemory", (Object)node.getFormattedMemory());
            n.put("cpuCores", (Object)node.getCpuCores());
            n.put("stateClass", (Object)node.getStateClass());
            nodes.add((Object)n);
        }
        json.put("nodes", (Object)nodes);
        JSONArray services = new JSONArray();
        for (ServiceInfo svc : status.getServices()) {
            JSONObject s = new JSONObject();
            s.put("id", (Object)svc.getId());
            s.put("shortId", (Object)svc.getShortId());
            s.put("name", (Object)svc.getName());
            s.put("state", (Object)svc.getState());
            s.put("templateName", (Object)svc.getTemplateName());
            s.put("uptime", (Object)svc.getUptime());
            s.put("error", (Object)svc.getError());
            s.put("stateClass", (Object)svc.getStateClass());
            services.add((Object)s);
        }
        json.put("services", (Object)services);
        return json;
    }
}

