/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.swarmcloud.monitoring;

public class ServiceInfo {
    private String id;
    private String name;
    private String state;
    private String templateName;
    private long createdTime;
    private String error;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(long createdTime) {
        this.createdTime = createdTime;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getStateClass() {
        if ("running".equalsIgnoreCase(this.state)) {
            return "success";
        }
        if ("pending".equalsIgnoreCase(this.state)) {
            return "warning";
        }
        if ("failed".equalsIgnoreCase(this.state)) {
            return "error";
        }
        if ("complete".equalsIgnoreCase(this.state)) {
            return "info";
        }
        if ("shutdown".equalsIgnoreCase(this.state)) {
            return "neutral";
        }
        if ("stopped".equalsIgnoreCase(this.state)) {
            return "neutral";
        }
        return "neutral";
    }

    public boolean isRunning() {
        return "running".equalsIgnoreCase(this.state);
    }

    public boolean isFailed() {
        return "failed".equalsIgnoreCase(this.state);
    }

    public String getUptime() {
        if (this.createdTime == 0L) {
            return "unknown";
        }
        long now = System.currentTimeMillis();
        long uptimeMs = now - this.createdTime;
        if (uptimeMs < 60000L) {
            return uptimeMs / 1000L + "s";
        }
        if (uptimeMs < 3600000L) {
            return uptimeMs / 60000L + "m";
        }
        if (uptimeMs < 86400000L) {
            return uptimeMs / 3600000L + "h " + uptimeMs % 3600000L / 60000L + "m";
        }
        return uptimeMs / 86400000L + "d " + uptimeMs % 86400000L / 3600000L + "h";
    }

    public String getShortId() {
        if (this.id == null) {
            return "";
        }
        return this.id.length() > 12 ? this.id.substring(0, 12) : this.id;
    }
}

