/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.swarmcloud;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.labels.LabelAtom;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.swarmcloud.SwarmCloud;
import io.jenkins.plugins.swarmcloud.SwarmConfigFile;
import io.jenkins.plugins.swarmcloud.SwarmSecretConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class SwarmAgentTemplate
extends AbstractDescribableImpl<SwarmAgentTemplate> {
    private static final Logger LOGGER = Logger.getLogger(SwarmAgentTemplate.class.getName());
    private static final AtomicInteger AGENT_COUNTER = new AtomicInteger(0);
    private final String name;
    private String image;
    private String labelString;
    private String command;
    private String remoteFs;
    private int numExecutors;
    private int maxInstances;
    private Node.Mode mode;
    private String cpuLimit;
    private String memoryLimit;
    private String cpuReservation;
    private String memoryReservation;
    private List<MountConfig> mounts;
    private List<EnvironmentVariable> environmentVariables;
    private List<String> placementConstraints;
    private List<String> networkAliases;
    private List<SwarmSecretConfig> secrets;
    private List<SwarmConfigFile> configs;
    private List<String> cacheDirs;
    private String healthCheckCommand;
    private int healthCheckIntervalSeconds;
    private int healthCheckTimeoutSeconds;
    private int healthCheckRetries;
    private List<String> capAdd;
    private List<String> capDrop;
    private List<String> sysctls;
    private boolean privileged;
    private String user;
    private String hostname;
    private List<String> dnsServers;
    private List<String> dnsOptions;
    private List<String> dnsSearch;
    private String stopSignal;
    private long stopGracePeriod;
    private String inheritFrom;
    private List<GenericResource> genericResources;
    private String seccompProfile;
    private String apparmorProfile;
    private int connectionTimeoutSeconds;
    private int idleTimeoutMinutes;
    private int provisionRetryCount;
    private long provisionRetryDelayMs;
    private List<PortBinding> portBindings;
    private boolean disableContainerArgs;
    private transient SwarmCloud parent;
    private transient AtomicInteger currentInstances;

    protected Object readResolve() {
        if (this.currentInstances == null) {
            this.currentInstances = new AtomicInteger(0);
        }
        return this;
    }

    public AtomicInteger getCurrentInstancesCounter() {
        if (this.currentInstances == null) {
            this.currentInstances = new AtomicInteger(0);
        }
        return this.currentInstances;
    }

    @DataBoundConstructor
    public SwarmAgentTemplate(@NonNull String name) {
        this.name = Util.fixEmptyAndTrim((String)name);
        this.image = "jenkins/inbound-agent:latest";
        this.remoteFs = "/home/jenkins/agent";
        this.numExecutors = 1;
        this.maxInstances = 5;
        this.mode = Node.Mode.NORMAL;
        this.currentInstances = new AtomicInteger(0);
    }

    @NonNull
    public String getName() {
        return this.name != null ? this.name : "";
    }

    @NonNull
    public String getImage() {
        return this.image != null ? this.image : "jenkins/inbound-agent:latest";
    }

    @DataBoundSetter
    public void setImage(String image) {
        this.image = Util.fixEmptyAndTrim((String)image);
    }

    @Nullable
    public String getLabelString() {
        return this.labelString;
    }

    @DataBoundSetter
    public void setLabelString(String labelString) {
        this.labelString = Util.fixEmptyAndTrim((String)labelString);
    }

    @Nullable
    public String getLabel() {
        return this.labelString;
    }

    @DataBoundSetter
    public void setLabel(String label) {
        this.labelString = Util.fixEmptyAndTrim((String)label);
    }

    @Nullable
    public String getCommand() {
        return this.command;
    }

    @DataBoundSetter
    public void setCommand(String command) {
        this.command = Util.fixEmptyAndTrim((String)command);
    }

    @NonNull
    public String getRemoteFs() {
        return this.remoteFs != null ? this.remoteFs : "/home/jenkins/agent";
    }

    @DataBoundSetter
    public void setRemoteFs(String remoteFs) {
        this.remoteFs = Util.fixEmptyAndTrim((String)remoteFs);
    }

    @NonNull
    public String getWorkingDir() {
        return this.getRemoteFs();
    }

    @DataBoundSetter
    public void setWorkingDir(String workingDir) {
        this.remoteFs = Util.fixEmptyAndTrim((String)workingDir);
    }

    public int getNumExecutors() {
        return this.numExecutors > 0 ? this.numExecutors : 1;
    }

    @DataBoundSetter
    public void setNumExecutors(int numExecutors) {
        this.numExecutors = numExecutors > 0 ? numExecutors : 1;
    }

    public int getMaxInstances() {
        return this.maxInstances > 0 ? this.maxInstances : 5;
    }

    @DataBoundSetter
    public void setMaxInstances(int maxInstances) {
        this.maxInstances = maxInstances > 0 ? maxInstances : 5;
    }

    @NonNull
    public Node.Mode getMode() {
        return this.mode != null ? this.mode : Node.Mode.NORMAL;
    }

    @DataBoundSetter
    public void setMode(Node.Mode mode) {
        this.mode = mode;
    }

    @Nullable
    public String getCpuLimit() {
        return this.cpuLimit;
    }

    @DataBoundSetter
    public void setCpuLimit(String cpuLimit) {
        this.cpuLimit = Util.fixEmptyAndTrim((String)cpuLimit);
    }

    @Nullable
    public String getMemoryLimit() {
        return this.memoryLimit;
    }

    @DataBoundSetter
    public void setMemoryLimit(String memoryLimit) {
        this.memoryLimit = Util.fixEmptyAndTrim((String)memoryLimit);
    }

    @Nullable
    public Long getLimitsNanoCPUs() {
        if (this.cpuLimit == null || this.cpuLimit.isBlank()) {
            return null;
        }
        try {
            return (long)(Double.parseDouble(this.cpuLimit) * 1.0E9);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @DataBoundSetter
    public void setLimitsNanoCPUs(Long nanoCPUs) {
        this.cpuLimit = nanoCPUs == null || nanoCPUs <= 0L ? null : String.valueOf((double)nanoCPUs.longValue() / 1.0E9);
    }

    @Nullable
    public Long getLimitsMemoryBytes() {
        return SwarmAgentTemplate.parseMemoryToBytes(this.memoryLimit);
    }

    @DataBoundSetter
    public void setLimitsMemoryBytes(Long bytes) {
        this.memoryLimit = SwarmAgentTemplate.formatBytesToMemory(bytes);
    }

    @Nullable
    public Long getReservationsNanoCPUs() {
        if (this.cpuReservation == null || this.cpuReservation.isBlank()) {
            return null;
        }
        try {
            return (long)(Double.parseDouble(this.cpuReservation) * 1.0E9);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @DataBoundSetter
    public void setReservationsNanoCPUs(Long nanoCPUs) {
        this.cpuReservation = nanoCPUs == null || nanoCPUs <= 0L ? null : String.valueOf((double)nanoCPUs.longValue() / 1.0E9);
    }

    @Nullable
    public Long getReservationsMemoryBytes() {
        return SwarmAgentTemplate.parseMemoryToBytes(this.memoryReservation);
    }

    @DataBoundSetter
    public void setReservationsMemoryBytes(Long bytes) {
        this.memoryReservation = SwarmAgentTemplate.formatBytesToMemory(bytes);
    }

    @Nullable
    private static Long parseMemoryToBytes(String memory) {
        if (memory == null || memory.isBlank()) {
            return null;
        }
        memory = memory.trim().toLowerCase(Locale.ROOT);
        try {
            long multiplier = 1L;
            if (memory.endsWith("g")) {
                multiplier = 0x40000000L;
                memory = memory.substring(0, memory.length() - 1);
            } else if (memory.endsWith("m")) {
                multiplier = 0x100000L;
                memory = memory.substring(0, memory.length() - 1);
            } else if (memory.endsWith("k")) {
                multiplier = 1024L;
                memory = memory.substring(0, memory.length() - 1);
            } else if (memory.endsWith("b")) {
                memory = memory.substring(0, memory.length() - 1);
            }
            return Long.parseLong(memory) * multiplier;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    private static String formatBytesToMemory(Long bytes) {
        if (bytes == null || bytes <= 0L) {
            return null;
        }
        if (bytes >= 0x40000000L && bytes % 0x40000000L == 0L) {
            return bytes / 0x40000000L + "g";
        }
        if (bytes >= 0x100000L && bytes % 0x100000L == 0L) {
            return bytes / 0x100000L + "m";
        }
        if (bytes >= 1024L && bytes % 1024L == 0L) {
            return bytes / 1024L + "k";
        }
        return bytes.toString();
    }

    @Nullable
    public String getCpuReservation() {
        return this.cpuReservation;
    }

    @DataBoundSetter
    public void setCpuReservation(String cpuReservation) {
        this.cpuReservation = Util.fixEmptyAndTrim((String)cpuReservation);
    }

    @Nullable
    public String getMemoryReservation() {
        return this.memoryReservation;
    }

    @DataBoundSetter
    public void setMemoryReservation(String memoryReservation) {
        this.memoryReservation = Util.fixEmptyAndTrim((String)memoryReservation);
    }

    @NonNull
    public List<MountConfig> getMounts() {
        return this.mounts != null ? Collections.unmodifiableList(this.mounts) : Collections.emptyList();
    }

    @DataBoundSetter
    public void setMounts(List<MountConfig> mounts) {
        this.mounts = mounts;
    }

    @NonNull
    public List<MountConfig> getHostBinds() {
        return this.getMounts();
    }

    @DataBoundSetter
    public void setHostBinds(List<MountConfig> hostBinds) {
        this.mounts = hostBinds;
    }

    @NonNull
    public List<EnvironmentVariable> getEnvironmentVariables() {
        return this.environmentVariables != null ? Collections.unmodifiableList(this.environmentVariables) : Collections.emptyList();
    }

    @DataBoundSetter
    public void setEnvironmentVariables(List<EnvironmentVariable> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    @NonNull
    public List<EnvironmentVariable> getEnvVars() {
        return this.getEnvironmentVariables();
    }

    @DataBoundSetter
    public void setEnvVars(List<EnvironmentVariable> envVars) {
        this.environmentVariables = envVars;
    }

    @NonNull
    public List<String> getPlacementConstraints() {
        return this.placementConstraints != null ? Collections.unmodifiableList(this.placementConstraints) : Collections.emptyList();
    }

    @DataBoundSetter
    public void setPlacementConstraints(List<String> placementConstraints) {
        this.placementConstraints = placementConstraints;
    }

    @DataBoundSetter
    public void setPlacementConstraintsString(String constraints) {
        if (constraints == null || constraints.isBlank()) {
            this.placementConstraints = null;
            return;
        }
        this.placementConstraints = Arrays.stream(constraints.split("\\n")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    @Nullable
    public String getPlacementConstraintsString() {
        if (this.placementConstraints == null || this.placementConstraints.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)"\n", this.placementConstraints);
    }

    @NonNull
    public List<String> getNetworkAliases() {
        return this.networkAliases != null ? Collections.unmodifiableList(this.networkAliases) : Collections.emptyList();
    }

    @DataBoundSetter
    public void setNetworkAliases(List<String> networkAliases) {
        this.networkAliases = networkAliases;
    }

    @DataBoundSetter
    public void setNetworkAliasesString(String aliases) {
        if (aliases == null || aliases.isBlank()) {
            this.networkAliases = null;
            return;
        }
        this.networkAliases = Arrays.stream(aliases.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    @Nullable
    public String getNetworkAliasesString() {
        if (this.networkAliases == null || this.networkAliases.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)", ", this.networkAliases);
    }

    @NonNull
    public List<SwarmSecretConfig> getSecrets() {
        return this.secrets != null ? Collections.unmodifiableList(this.secrets) : Collections.emptyList();
    }

    @DataBoundSetter
    public void setSecrets(List<SwarmSecretConfig> secrets) {
        this.secrets = secrets;
    }

    @NonNull
    public List<SwarmConfigFile> getConfigs() {
        return this.configs != null ? Collections.unmodifiableList(this.configs) : Collections.emptyList();
    }

    @DataBoundSetter
    public void setConfigs(List<SwarmConfigFile> configs) {
        this.configs = configs;
    }

    @Nullable
    public String getConfigsString() {
        if (this.configs == null || this.configs.isEmpty()) {
            return null;
        }
        return this.configs.stream().map(SwarmConfigFile::toString).collect(Collectors.joining("\n"));
    }

    @DataBoundSetter
    public void setConfigsString(String configsStr) {
        if (configsStr == null || configsStr.isBlank()) {
            this.configs = null;
            return;
        }
        this.configs = Arrays.stream(configsStr.split("\\n")).map(String::trim).filter(s -> !s.isEmpty()).map(SwarmConfigFile::parse).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NonNull
    public List<String> getCacheDirs() {
        return this.cacheDirs != null ? Collections.unmodifiableList(this.cacheDirs) : Collections.emptyList();
    }

    @DataBoundSetter
    public void setCacheDirs(List<String> cacheDirs) {
        this.cacheDirs = cacheDirs;
    }

    @Nullable
    public String getCacheDirsString() {
        if (this.cacheDirs == null || this.cacheDirs.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)"\n", this.cacheDirs);
    }

    @DataBoundSetter
    public void setCacheDirsString(String cacheDirsStr) {
        if (cacheDirsStr == null || cacheDirsStr.isBlank()) {
            this.cacheDirs = null;
            return;
        }
        this.cacheDirs = Arrays.stream(cacheDirsStr.split("\\n")).map(String::trim).filter(s -> !s.isEmpty() && s.startsWith("/")).collect(Collectors.toList());
    }

    @Nullable
    public String getHealthCheckCommand() {
        return this.healthCheckCommand;
    }

    @DataBoundSetter
    public void setHealthCheckCommand(String healthCheckCommand) {
        this.healthCheckCommand = Util.fixEmptyAndTrim((String)healthCheckCommand);
    }

    public int getHealthCheckIntervalSeconds() {
        return this.healthCheckIntervalSeconds > 0 ? this.healthCheckIntervalSeconds : 30;
    }

    @DataBoundSetter
    public void setHealthCheckIntervalSeconds(int healthCheckIntervalSeconds) {
        this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
    }

    public int getHealthCheckTimeoutSeconds() {
        return this.healthCheckTimeoutSeconds > 0 ? this.healthCheckTimeoutSeconds : 10;
    }

    @DataBoundSetter
    public void setHealthCheckTimeoutSeconds(int healthCheckTimeoutSeconds) {
        this.healthCheckTimeoutSeconds = healthCheckTimeoutSeconds;
    }

    public int getHealthCheckRetries() {
        return this.healthCheckRetries > 0 ? this.healthCheckRetries : 3;
    }

    @DataBoundSetter
    public void setHealthCheckRetries(int healthCheckRetries) {
        this.healthCheckRetries = healthCheckRetries;
    }

    public boolean hasHealthCheck() {
        return this.healthCheckCommand != null && !this.healthCheckCommand.isBlank();
    }

    @NonNull
    public List<String> getCapAdd() {
        return this.capAdd != null ? Collections.unmodifiableList(this.capAdd) : Collections.emptyList();
    }

    @DataBoundSetter
    public void setCapAdd(List<String> capAdd) {
        this.capAdd = capAdd;
    }

    @DataBoundSetter
    public void setCapAddString(String caps) {
        this.capAdd = this.parseCommaSeparated(caps);
    }

    @Nullable
    public String getCapAddString() {
        return this.capAdd != null && !this.capAdd.isEmpty() ? String.join((CharSequence)", ", this.capAdd) : null;
    }

    @NonNull
    public List<String> getCapDrop() {
        return this.capDrop != null ? Collections.unmodifiableList(this.capDrop) : Collections.emptyList();
    }

    @DataBoundSetter
    public void setCapDrop(List<String> capDrop) {
        this.capDrop = capDrop;
    }

    @DataBoundSetter
    public void setCapDropString(String caps) {
        this.capDrop = this.parseCommaSeparated(caps);
    }

    @Nullable
    public String getCapDropString() {
        return this.capDrop != null && !this.capDrop.isEmpty() ? String.join((CharSequence)", ", this.capDrop) : null;
    }

    @NonNull
    public List<String> getSysctls() {
        return this.sysctls != null ? Collections.unmodifiableList(this.sysctls) : Collections.emptyList();
    }

    @DataBoundSetter
    public void setSysctls(List<String> sysctls) {
        this.sysctls = sysctls;
    }

    @DataBoundSetter
    public void setSysctlsString(String sysctlsStr) {
        this.sysctls = this.parseNewlineSeparated(sysctlsStr);
    }

    @Nullable
    public String getSysctlsString() {
        return this.sysctls != null && !this.sysctls.isEmpty() ? String.join((CharSequence)"\n", this.sysctls) : null;
    }

    public boolean isPrivileged() {
        return this.privileged;
    }

    @DataBoundSetter
    public void setPrivileged(boolean privileged) {
        this.privileged = privileged;
    }

    public boolean isDisableContainerArgs() {
        return this.disableContainerArgs;
    }

    @DataBoundSetter
    public void setDisableContainerArgs(boolean disableContainerArgs) {
        this.disableContainerArgs = disableContainerArgs;
    }

    @Nullable
    public String getUser() {
        return this.user;
    }

    @DataBoundSetter
    public void setUser(String user) {
        this.user = Util.fixEmptyAndTrim((String)user);
    }

    @Nullable
    public String getHostname() {
        return this.hostname;
    }

    @DataBoundSetter
    public void setHostname(String hostname) {
        this.hostname = Util.fixEmptyAndTrim((String)hostname);
    }

    @NonNull
    public List<String> getDnsServers() {
        return this.dnsServers != null ? Collections.unmodifiableList(this.dnsServers) : Collections.emptyList();
    }

    @DataBoundSetter
    public void setDnsServers(List<String> dnsServers) {
        this.dnsServers = dnsServers;
    }

    @DataBoundSetter
    public void setDnsServersString(String dns) {
        this.dnsServers = this.parseCommaSeparated(dns);
    }

    @Nullable
    public String getDnsServersString() {
        return this.dnsServers != null && !this.dnsServers.isEmpty() ? String.join((CharSequence)", ", this.dnsServers) : null;
    }

    @Nullable
    public String getDnsIps() {
        return this.getDnsServersString();
    }

    @DataBoundSetter
    public void setDnsIps(String dnsIps) {
        this.setDnsServersString(dnsIps);
    }

    @NonNull
    public List<String> getDnsOptions() {
        return this.dnsOptions != null ? Collections.unmodifiableList(this.dnsOptions) : Collections.emptyList();
    }

    @DataBoundSetter
    public void setDnsOptions(List<String> dnsOptions) {
        this.dnsOptions = dnsOptions;
    }

    @NonNull
    public List<String> getDnsSearch() {
        return this.dnsSearch != null ? Collections.unmodifiableList(this.dnsSearch) : Collections.emptyList();
    }

    @DataBoundSetter
    public void setDnsSearch(List<String> dnsSearch) {
        this.dnsSearch = dnsSearch;
    }

    @Nullable
    public String getStopSignal() {
        return this.stopSignal;
    }

    @DataBoundSetter
    public void setStopSignal(String stopSignal) {
        this.stopSignal = Util.fixEmptyAndTrim((String)stopSignal);
    }

    public long getStopGracePeriod() {
        return this.stopGracePeriod > 0L ? this.stopGracePeriod : 10L;
    }

    @DataBoundSetter
    public void setStopGracePeriod(long stopGracePeriod) {
        this.stopGracePeriod = stopGracePeriod;
    }

    @Nullable
    public String getInheritFrom() {
        return this.inheritFrom;
    }

    @DataBoundSetter
    public void setInheritFrom(String inheritFrom) {
        this.inheritFrom = Util.fixEmptyAndTrim((String)inheritFrom);
    }

    @NonNull
    public List<GenericResource> getGenericResources() {
        return this.genericResources != null ? Collections.unmodifiableList(this.genericResources) : Collections.emptyList();
    }

    @DataBoundSetter
    public void setGenericResources(List<GenericResource> genericResources) {
        this.genericResources = genericResources;
    }

    @Nullable
    public String getGenericResourcesString() {
        if (this.genericResources == null || this.genericResources.isEmpty()) {
            return null;
        }
        return this.genericResources.stream().map(r -> r.getKind() + "=" + r.getValue()).collect(Collectors.joining(", "));
    }

    @DataBoundSetter
    public void setGenericResourcesString(String str) {
        if (str == null || str.isBlank()) {
            this.genericResources = null;
            return;
        }
        this.genericResources = Arrays.stream(str.split(",")).map(String::trim).filter(s -> s.contains("=")).map(s -> {
            String[] parts = s.split("=", 2);
            return new GenericResource(parts[0].trim(), Long.parseLong(parts[1].trim()));
        }).collect(Collectors.toList());
    }

    @Nullable
    public String getSeccompProfile() {
        return this.seccompProfile;
    }

    @DataBoundSetter
    public void setSeccompProfile(String seccompProfile) {
        this.seccompProfile = Util.fixEmptyAndTrim((String)seccompProfile);
    }

    @Nullable
    public String getApparmorProfile() {
        return this.apparmorProfile;
    }

    @DataBoundSetter
    public void setApparmorProfile(String apparmorProfile) {
        this.apparmorProfile = Util.fixEmptyAndTrim((String)apparmorProfile);
    }

    public int getConnectionTimeoutSeconds() {
        return this.connectionTimeoutSeconds > 0 ? this.connectionTimeoutSeconds : 300;
    }

    @DataBoundSetter
    public void setConnectionTimeoutSeconds(int connectionTimeoutSeconds) {
        this.connectionTimeoutSeconds = connectionTimeoutSeconds;
    }

    public int getIdleTimeoutMinutes() {
        return this.idleTimeoutMinutes > 0 ? this.idleTimeoutMinutes : 30;
    }

    @DataBoundSetter
    public void setIdleTimeoutMinutes(int idleTimeoutMinutes) {
        this.idleTimeoutMinutes = idleTimeoutMinutes;
    }

    public int getProvisionRetryCount() {
        return this.provisionRetryCount > 0 ? this.provisionRetryCount : 3;
    }

    @DataBoundSetter
    public void setProvisionRetryCount(int provisionRetryCount) {
        this.provisionRetryCount = provisionRetryCount;
    }

    public long getProvisionRetryDelayMs() {
        return this.provisionRetryDelayMs > 0L ? this.provisionRetryDelayMs : 1000L;
    }

    @DataBoundSetter
    public void setProvisionRetryDelayMs(long provisionRetryDelayMs) {
        this.provisionRetryDelayMs = provisionRetryDelayMs;
    }

    @NonNull
    public List<PortBinding> getPortBindings() {
        return this.portBindings != null ? Collections.unmodifiableList(this.portBindings) : Collections.emptyList();
    }

    @DataBoundSetter
    public void setPortBindings(List<PortBinding> portBindings) {
        this.portBindings = portBindings;
    }

    @Nullable
    public String getPortBindingsString() {
        if (this.portBindings == null || this.portBindings.isEmpty()) {
            return null;
        }
        return this.portBindings.stream().map(PortBinding::toString).collect(Collectors.joining("\n"));
    }

    @DataBoundSetter
    public void setPortBindingsString(String str) {
        if (str == null || str.isBlank()) {
            this.portBindings = null;
            return;
        }
        this.portBindings = Arrays.stream(str.split("\\n")).map(String::trim).filter(s -> !s.isEmpty()).map(PortBinding::parse).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    public String getPortBinds() {
        return this.getPortBindingsString();
    }

    @DataBoundSetter
    public void setPortBinds(String portBinds) {
        this.setPortBindingsString(portBinds);
    }

    @NonNull
    public SwarmAgentTemplate resolve() {
        if (this.inheritFrom == null || this.inheritFrom.isBlank() || this.parent == null) {
            return this;
        }
        SwarmAgentTemplate parentTemplate = this.parent.getTemplateByName(this.inheritFrom);
        if (parentTemplate == null) {
            LOGGER.warning("Parent template '" + this.inheritFrom + "' not found, using current template as-is");
            return this;
        }
        SwarmAgentTemplate resolved = new SwarmAgentTemplate(this.name);
        resolved.setParent(this.parent);
        resolved.setImage(this.image != null ? this.image : parentTemplate.getImage());
        resolved.setLabelString(this.mergeLabelStrings(parentTemplate.getLabelString(), this.labelString));
        resolved.setCommand(this.command != null ? this.command : parentTemplate.getCommand());
        resolved.setRemoteFs(this.remoteFs != null ? this.remoteFs : parentTemplate.getRemoteFs());
        resolved.setNumExecutors(this.numExecutors > 0 ? this.numExecutors : parentTemplate.getNumExecutors());
        resolved.setMaxInstances(this.maxInstances > 0 ? this.maxInstances : parentTemplate.getMaxInstances());
        resolved.setMode(this.mode != null ? this.mode : parentTemplate.getMode());
        resolved.setCpuLimit(this.cpuLimit != null ? this.cpuLimit : parentTemplate.getCpuLimit());
        resolved.setMemoryLimit(this.memoryLimit != null ? this.memoryLimit : parentTemplate.getMemoryLimit());
        resolved.setCpuReservation(this.cpuReservation != null ? this.cpuReservation : parentTemplate.getCpuReservation());
        resolved.setMemoryReservation(this.memoryReservation != null ? this.memoryReservation : parentTemplate.getMemoryReservation());
        resolved.setMounts(this.mergeLists(parentTemplate.getMounts(), this.mounts));
        resolved.setEnvironmentVariables(this.mergeLists(parentTemplate.getEnvironmentVariables(), this.environmentVariables));
        resolved.setSecrets(this.mergeLists(parentTemplate.getSecrets(), this.secrets));
        resolved.setConfigs(this.mergeLists(parentTemplate.getConfigs(), this.configs));
        resolved.setCacheDirs(this.mergeLists(parentTemplate.getCacheDirs(), this.cacheDirs));
        resolved.setPlacementConstraints(this.mergeLists(parentTemplate.getPlacementConstraints(), this.placementConstraints));
        resolved.setNetworkAliases(this.mergeLists(parentTemplate.getNetworkAliases(), this.networkAliases));
        resolved.setHealthCheckCommand(this.healthCheckCommand != null ? this.healthCheckCommand : parentTemplate.getHealthCheckCommand());
        resolved.setHealthCheckIntervalSeconds(this.healthCheckIntervalSeconds > 0 ? this.healthCheckIntervalSeconds : parentTemplate.getHealthCheckIntervalSeconds());
        resolved.setHealthCheckTimeoutSeconds(this.healthCheckTimeoutSeconds > 0 ? this.healthCheckTimeoutSeconds : parentTemplate.getHealthCheckTimeoutSeconds());
        resolved.setHealthCheckRetries(this.healthCheckRetries > 0 ? this.healthCheckRetries : parentTemplate.getHealthCheckRetries());
        resolved.setCapAdd(this.mergeLists(parentTemplate.getCapAdd(), this.capAdd));
        resolved.setCapDrop(this.mergeLists(parentTemplate.getCapDrop(), this.capDrop));
        resolved.setSysctls(this.mergeLists(parentTemplate.getSysctls(), this.sysctls));
        resolved.setPrivileged(this.privileged || parentTemplate.isPrivileged());
        resolved.setUser(this.user != null ? this.user : parentTemplate.getUser());
        resolved.setHostname(this.hostname != null ? this.hostname : parentTemplate.getHostname());
        resolved.setDnsServers(this.mergeLists(parentTemplate.getDnsServers(), this.dnsServers));
        resolved.setDnsOptions(this.mergeLists(parentTemplate.getDnsOptions(), this.dnsOptions));
        resolved.setDnsSearch(this.mergeLists(parentTemplate.getDnsSearch(), this.dnsSearch));
        resolved.setStopSignal(this.stopSignal != null ? this.stopSignal : parentTemplate.getStopSignal());
        resolved.setStopGracePeriod(this.stopGracePeriod > 0L ? this.stopGracePeriod : parentTemplate.getStopGracePeriod());
        resolved.setGenericResources(this.mergeLists(parentTemplate.getGenericResources(), this.genericResources));
        resolved.setSeccompProfile(this.seccompProfile != null ? this.seccompProfile : parentTemplate.getSeccompProfile());
        resolved.setApparmorProfile(this.apparmorProfile != null ? this.apparmorProfile : parentTemplate.getApparmorProfile());
        resolved.setConnectionTimeoutSeconds(this.connectionTimeoutSeconds > 0 ? this.connectionTimeoutSeconds : parentTemplate.getConnectionTimeoutSeconds());
        resolved.setIdleTimeoutMinutes(this.idleTimeoutMinutes > 0 ? this.idleTimeoutMinutes : parentTemplate.getIdleTimeoutMinutes());
        resolved.setProvisionRetryCount(this.provisionRetryCount > 0 ? this.provisionRetryCount : parentTemplate.getProvisionRetryCount());
        resolved.setProvisionRetryDelayMs(this.provisionRetryDelayMs > 0L ? this.provisionRetryDelayMs : parentTemplate.getProvisionRetryDelayMs());
        resolved.setPortBindings(this.mergeLists(parentTemplate.getPortBindings(), this.portBindings));
        return resolved;
    }

    private String mergeLabelStrings(String parent, String child) {
        if (child == null || child.isBlank()) {
            return parent;
        }
        if (parent == null || parent.isBlank()) {
            return child;
        }
        LinkedHashSet<String> labels = new LinkedHashSet<String>();
        labels.addAll(Arrays.asList(parent.split("\\s+")));
        labels.addAll(Arrays.asList(child.split("\\s+")));
        return String.join((CharSequence)" ", labels);
    }

    private <T> List<T> mergeLists(List<T> parent, List<T> child) {
        if (child != null && !child.isEmpty()) {
            if (parent == null || parent.isEmpty()) {
                return new ArrayList<T>(child);
            }
            ArrayList<T> merged = new ArrayList<T>(parent);
            merged.addAll(child);
            return merged;
        }
        return parent != null ? new ArrayList<T>(parent) : Collections.emptyList();
    }

    private List<String> parseCommaSeparated(String str) {
        if (str == null || str.isBlank()) {
            return null;
        }
        return Arrays.stream(str.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    private List<String> parseNewlineSeparated(String str) {
        if (str == null || str.isBlank()) {
            return null;
        }
        return Arrays.stream(str.split("\\n")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    public void setParent(SwarmCloud parent) {
        this.parent = parent;
    }

    @Nullable
    public SwarmCloud getParent() {
        return this.parent;
    }

    @NonNull
    public Set<LabelAtom> getLabelSet() {
        if (this.labelString == null || this.labelString.isBlank()) {
            return Collections.emptySet();
        }
        return Label.parse((String)this.labelString);
    }

    public boolean matches(@Nullable Label label) {
        if (label == null) {
            return this.mode == Node.Mode.NORMAL;
        }
        if (this.labelString == null || this.labelString.isBlank()) {
            return this.mode == Node.Mode.NORMAL;
        }
        return label.matches(this.getLabelSet());
    }

    @NonNull
    public String generateAgentName() {
        String shortUuid = UUID.randomUUID().toString().substring(0, 8);
        return String.format("swarm-%s-%d-%s", this.name.toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9]", "-"), AGENT_COUNTER.incrementAndGet(), shortUuid);
    }

    public int getAvailableCapacity() {
        return Math.max(0, this.maxInstances - this.getCurrentInstancesCounter().get());
    }

    public void incrementInstances() {
        this.getCurrentInstancesCounter().incrementAndGet();
    }

    public void decrementInstances() {
        this.getCurrentInstancesCounter().updateAndGet(current -> Math.max(0, current - 1));
    }

    public int getCurrentInstances() {
        return this.getCurrentInstancesCounter().get();
    }

    public void setCurrentInstances(int count) {
        this.getCurrentInstancesCounter().set(Math.max(0, count));
    }

    public static class GenericResource
    extends AbstractDescribableImpl<GenericResource> {
        private final String kind;
        private final long value;

        @DataBoundConstructor
        public GenericResource(String kind, long value) {
            this.kind = kind;
            this.value = value;
        }

        public String getKind() {
            return this.kind;
        }

        public long getValue() {
            return this.value;
        }

        public String toString() {
            return this.kind + "=" + this.value;
        }

        @Extension
        @Symbol(value={"swarmGenericResource"})
        public static class DescriptorImpl
        extends Descriptor<GenericResource> {
            @NonNull
            public String getDisplayName() {
                return "Generic Resource";
            }
        }
    }

    @Extension
    @Symbol(value={"swarmAgentTemplate"})
    public static class DescriptorImpl
    extends Descriptor<SwarmAgentTemplate> {
        @NonNull
        public String getDisplayName() {
            return "Docker Swarm Agent Template";
        }

        @POST
        public FormValidation doCheckName(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.error((String)"Name is required");
            }
            if (!value.matches("[a-zA-Z0-9_-]+")) {
                return FormValidation.error((String)"Name must contain only letters, numbers, hyphens, and underscores");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckImage(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.error((String)"Docker image is required");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckMaxInstances(@QueryParameter int value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (value <= 0) {
                return FormValidation.error((String)"Max instances must be greater than 0");
            }
            if (value > 100) {
                return FormValidation.warning((String)"High max instances value. Consider the cluster capacity.");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckMemoryLimit(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.ok();
            }
            if (!value.matches("\\d+[bkmgBKMG]?")) {
                return FormValidation.error((String)"Invalid memory format. Use formats like: 512m, 1g, 2048m");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckCpuLimit(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.ok();
            }
            try {
                double cpu = Double.parseDouble(value);
                if (cpu <= 0.0) {
                    return FormValidation.error((String)"CPU limit must be positive");
                }
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Invalid CPU format. Use decimal number like: 0.5, 1.0, 2.0");
            }
            return FormValidation.ok();
        }
    }

    public static class PortBinding
    extends AbstractDescribableImpl<PortBinding> {
        private final int publishedPort;
        private final int targetPort;
        private final String protocol;

        @DataBoundConstructor
        public PortBinding(int publishedPort, int targetPort, String protocol) {
            this.publishedPort = publishedPort;
            this.targetPort = targetPort;
            this.protocol = protocol != null && !protocol.isBlank() ? protocol.toLowerCase(Locale.ROOT) : "tcp";
        }

        public int getPublishedPort() {
            return this.publishedPort;
        }

        public int getTargetPort() {
            return this.targetPort;
        }

        public String getProtocol() {
            return this.protocol != null ? this.protocol : "tcp";
        }

        @Nullable
        public static PortBinding parse(String str) {
            int colonIdx;
            if (str == null || str.isBlank()) {
                return null;
            }
            str = str.trim();
            String protocol = "tcp";
            int slashIdx = str.indexOf(47);
            if (slashIdx > 0) {
                protocol = str.substring(slashIdx + 1).toLowerCase(Locale.ROOT);
                str = str.substring(0, slashIdx);
            }
            if ((colonIdx = str.indexOf(58)) < 0) {
                try {
                    int targetPort = Integer.parseInt(str);
                    return new PortBinding(0, targetPort, protocol);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            String hostPart = str.substring(0, colonIdx).trim();
            String containerPart = str.substring(colonIdx + 1).trim();
            try {
                int publishedPort = hostPart.isEmpty() ? 0 : Integer.parseInt(hostPart);
                int targetPort = Integer.parseInt(containerPart);
                return new PortBinding(publishedPort, targetPort, protocol);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.publishedPort > 0) {
                sb.append(this.publishedPort);
            }
            sb.append(':').append(this.targetPort);
            if (!"tcp".equalsIgnoreCase(this.protocol)) {
                sb.append('/').append(this.protocol);
            }
            return sb.toString();
        }

        @Extension
        @Symbol(value={"swarmPortBinding"})
        public static class DescriptorImpl
        extends Descriptor<PortBinding> {
            @NonNull
            public String getDisplayName() {
                return "Port Binding";
            }
        }
    }

    public static class EnvironmentVariable
    extends AbstractDescribableImpl<EnvironmentVariable> {
        private final String name;
        private final String value;

        @DataBoundConstructor
        public EnvironmentVariable(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        @Extension
        @Symbol(value={"swarmEnvVar"})
        public static class DescriptorImpl
        extends Descriptor<EnvironmentVariable> {
            @NonNull
            public String getDisplayName() {
                return "Environment Variable";
            }
        }
    }

    public static class MountConfig
    extends AbstractDescribableImpl<MountConfig> {
        private final SwarmMountType type;
        private final String source;
        private final String target;
        private boolean readOnly;

        @DataBoundConstructor
        public MountConfig(SwarmMountType type, String source, String target) {
            this.type = type;
            this.source = source;
            this.target = target;
        }

        public SwarmMountType getType() {
            return this.type;
        }

        public String getSource() {
            return this.source;
        }

        public String getTarget() {
            return this.target;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        @DataBoundSetter
        public void setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
        }

        @Extension
        @Symbol(value={"swarmMount"})
        public static class DescriptorImpl
        extends Descriptor<MountConfig> {
            @NonNull
            public String getDisplayName() {
                return "Mount Configuration";
            }

            public ListBoxModel doFillTypeItems() {
                ListBoxModel items = new ListBoxModel();
                for (SwarmMountType type : SwarmMountType.values()) {
                    items.add(type.getValue(), type.name());
                }
                return items;
            }
        }
    }

    public static enum SwarmMountType {
        BIND("bind"),
        VOLUME("volume"),
        TMPFS("tmpfs");

        private final String value;

        private SwarmMountType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }
}

