/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.CloudRunExecutor;
import io.jenkins.plugins.LocalRunExecutor;
import java.io.IOException;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class SedStartBuilder
extends Builder
implements SimpleBuildStep {
    private final Mode mode;
    private final String name;
    private Integer projectId;
    private Integer suiteId;
    private Integer testId;
    private Integer profileId;
    private String browser = "chrome";
    private boolean headless = false;
    private String environment = "PROD";

    @DataBoundConstructor
    public SedStartBuilder(Mode mode, String name) {
        this.mode = mode == null ? Mode.CLOUD : mode;
        this.name = name;
    }

    public Mode getMode() {
        return this.mode;
    }

    public String getName() {
        return this.name;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    @DataBoundSetter
    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public Integer getSuiteId() {
        return this.suiteId;
    }

    @DataBoundSetter
    public void setSuiteId(Integer suiteId) {
        this.suiteId = suiteId;
    }

    public Integer getTestId() {
        return this.testId;
    }

    @DataBoundSetter
    public void setTestId(Integer testId) {
        this.testId = testId;
    }

    public Integer getProfileId() {
        return this.profileId;
    }

    @DataBoundSetter
    public void setProfileId(Integer profileId) {
        this.profileId = profileId;
    }

    public String getBrowser() {
        return this.browser;
    }

    @DataBoundSetter
    public void setBrowser(String browser) {
        this.browser = browser;
    }

    public boolean isHeadless() {
        return this.headless;
    }

    @DataBoundSetter
    public void setHeadless(boolean headless) {
        this.headless = headless;
    }

    public String getEnvironment() {
        return this.environment;
    }

    @DataBoundSetter
    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void perform(Run<?, ?> run, FilePath workspace, EnvVars env, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        if (this.mode == Mode.CLOUD) {
            new CloudRunExecutor().execute(run, workspace, env, launcher, listener, this.projectId, this.suiteId, this.testId, this.profileId, this.browser, this.headless, this.environment);
        } else {
            new LocalRunExecutor().execute(run, workspace, env, launcher, listener, this.projectId, this.suiteId, this.testId, this.profileId, this.browser, this.headless, this.environment);
        }
    }

    public static enum Mode {
        CLOUD,
        LOCAL;

    }

    @Extension
    @Symbol(value={"sedStart"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class jobType) {
            return true;
        }

        public String getDisplayName() {
            return "SedStart Runner";
        }

        public ListBoxModel doFillModeItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Local", "LOCAL");
            items.add("Cloud", "CLOUD");
            return items;
        }

        @RequirePOST
        public FormValidation doCheckSuiteId(@QueryParameter String value, @QueryParameter(value="testId") String testId) {
            Jenkins.get().checkPermission(Item.CONFIGURE);
            return DescriptorImpl.xorNumeric(value, testId, "Suite ID", "Test ID");
        }

        @RequirePOST
        public FormValidation doCheckTestId(@QueryParameter String value, @QueryParameter(value="suiteId") String suiteId) {
            Jenkins.get().checkPermission(Item.CONFIGURE);
            return DescriptorImpl.xorNumeric(value, suiteId, "Test ID", "Suite ID");
        }

        private static FormValidation xorNumeric(String primary, String other, String primaryName, String otherName) {
            boolean otherEmpty;
            boolean primaryEmpty = primary == null || primary.trim().isEmpty();
            boolean bl = otherEmpty = other == null || other.trim().isEmpty();
            if (primaryEmpty && otherEmpty) {
                return FormValidation.error((String)("Provide either " + primaryName + " or " + otherName));
            }
            if (!primaryEmpty && !otherEmpty) {
                return FormValidation.error((String)("Provide only one of " + primaryName + " or " + otherName));
            }
            if (!primaryEmpty) {
                try {
                    int v = Integer.parseInt(primary.trim());
                    if (v <= 0) {
                        return FormValidation.error((String)(primaryName + " must be a positive number"));
                    }
                }
                catch (NumberFormatException e) {
                    return FormValidation.error((String)(primaryName + " must be numeric"));
                }
            }
            return FormValidation.ok();
        }
    }
}

