/*
 * Decompiled with CFR 0.152.
 */
package com.cloudogu.scmmanager.scm.api;

import com.cloudogu.scmmanager.scm.PluginNotUpToDateException;
import com.cloudogu.scmmanager.scm.api.ApiClient;
import com.cloudogu.scmmanager.scm.api.Branch;
import com.cloudogu.scmmanager.scm.api.Changeset;
import com.cloudogu.scmmanager.scm.api.IllegalReturnStatusException;
import com.cloudogu.scmmanager.scm.api.PullRequest;
import com.cloudogu.scmmanager.scm.api.Repository;
import com.cloudogu.scmmanager.scm.api.ScmManagerFile;
import com.cloudogu.scmmanager.scm.api.Tag;
import de.otto.edison.hal.HalRepresentation;
import de.otto.edison.hal.Link;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import jenkins.scm.api.SCMFile;

public class ScmManagerApi {
    private final ApiClient client;

    public ScmManagerApi(ApiClient client) {
        this.client = client;
    }

    public CompletableFuture<HalRepresentation> index() {
        return this.client.get("/api/v2", "application/vnd.scmm-index+json;v=2", HalRepresentation.class);
    }

    public CompletableFuture<List<Repository>> getRepositories() {
        return this.client.get("/api/v2/repositories?pageSize=2000&sortBy=namespace&sortBy=name", "application/vnd.scmm-repositoryCollection+json;v=2", RepositoryCollection.class).thenApply(collection -> collection.get_embedded().getRepositories());
    }

    public CompletableFuture<Repository> getRepository(String namespace, String name) {
        String url = String.format("/api/v2/repositories/%s/%s", namespace, name);
        return this.client.get(url, "application/vnd.scmm-repository+json;v=2", Repository.class);
    }

    public CompletableFuture<List<Branch>> getBranches(Repository repository) {
        Optional branchesLink = repository.getLinks().getLinkBy("branches");
        if (branchesLink.isPresent()) {
            return ((CompletableFuture)this.client.get(((Link)branchesLink.get()).getHref(), "application/vnd.scmm-branchCollection+json;v=2", BranchCollection.class).thenApply(branchCollection -> branchCollection.get_embedded().getBranches())).thenApply(branches -> {
                branches.forEach(branch -> branch.setCloneInformation(repository.getCloneInformation()));
                return branches;
            });
        }
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    public CompletableFuture<List<Tag>> getTags(Repository repository) {
        Optional tagsLink = repository.getLinks().getLinkBy("tags");
        if (tagsLink.isPresent()) {
            return ((CompletableFuture)this.client.get(((Link)tagsLink.get()).getHref(), "application/vnd.scmm-tagCollection+json;v=2", TagCollection.class).thenApply(tags -> tags.get_embedded().getTags().stream().map(this.prepareTag(repository)).collect(Collectors.toList()))).thenCompose(completableFutures -> CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).thenApply(future -> completableFutures.stream().filter(cf -> !cf.isCompletedExceptionally()).map(CompletableFuture::join).collect(Collectors.toList())));
        }
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    private Function<Tag, CompletableFuture<Tag>> prepareTag(Repository repository) {
        return tag -> {
            Optional changesetLink = tag.getLinks().getLinkBy("changeset");
            if (changesetLink.isPresent()) {
                return this.client.get(((Link)changesetLink.get()).getHref(), "application/vnd.scmm-changeset+json;v=2", Changeset.class).thenApply(changeset -> {
                    tag.setCloneInformation(repository.getCloneInformation());
                    tag.setChangeset((Changeset)changeset);
                    return tag;
                });
            }
            throw new IllegalStateException("could not find changeset link on tag " + tag.getName());
        };
    }

    public CompletableFuture<Changeset> getChangeset(Repository repository, String revision) {
        Optional changesetsLink = repository.getLinks().getLinkBy("changesets");
        if (changesetsLink.isPresent()) {
            return this.client.get(this.concat((Link)changesetsLink.get(), revision), "application/vnd.scmm-changeset+json;v=2", Changeset.class);
        }
        throw new IllegalStateException("could not find changesets link on repository " + repository.getName());
    }

    public CompletableFuture<List<PullRequest>> getPullRequests(Repository repository) {
        Optional pullRequestLink = repository.getLinks().getLinkBy("pullRequest");
        if (pullRequestLink.isPresent()) {
            return ((CompletableFuture)this.client.get(((Link)pullRequestLink.get()).getHref() + "?status=OPEN", "application/vnd.scmm-pullRequestCollection+json;v=2", PullRequestCollection.class).thenApply(pullRequestCollection -> pullRequestCollection.get_embedded().getPullRequests().stream().map(this.preparePullRequest(repository)).collect(Collectors.toList()))).thenCompose(completableFutures -> CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).thenApply(future -> completableFutures.stream().filter(cf -> !cf.isCompletedExceptionally()).map(CompletableFuture::join).collect(Collectors.toList())));
        }
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    private Function<PullRequest, CompletableFuture<PullRequest>> preparePullRequest(Repository repository) {
        return pullRequest -> {
            pullRequest.setCloneInformation(repository.getCloneInformation());
            CompletionStage source = this.client.get(this.getPullRequestLink((HalRepresentation)pullRequest, "sourceBranch"), "application/vnd.scmm-branch+json;v=2", Branch.class).thenAccept(pullRequest::setSourceBranch);
            CompletionStage target = this.client.get(this.getPullRequestLink((HalRepresentation)pullRequest, "targetBranch"), "application/vnd.scmm-branch+json;v=2", Branch.class).thenAccept(pullRequest::setTargetBranch);
            return CompletableFuture.allOf(new CompletableFuture[]{source, target}).thenApply(v -> pullRequest);
        };
    }

    private String getPullRequestLink(HalRepresentation hal, String linkName) {
        return ((Link)hal.getLinks().getLinkBy(linkName).orElseThrow(() -> new PluginNotUpToDateException("could not find link '" + linkName + "', ensure the scm-review-plugin is up-to-date"))).getHref();
    }

    public CompletableFuture<Tag> getTag(Repository repository, String tagName) {
        Optional link = repository.getLinks().getLinkBy("tags");
        return link.map(value -> this.client.get(this.concat((Link)value, tagName), "application/vnd.scmm-tag+json;v=2", Tag.class).thenCompose(this.prepareTag(repository))).orElse(null);
    }

    public CompletableFuture<PullRequest> getPullRequest(Repository repository, String id) {
        Optional pullRequestLink = repository.getLinks().getLinkBy("pullRequest");
        return pullRequestLink.map(link -> this.client.get(this.concat((Link)link, id), "application/vnd.scmm-pullRequest+json;v=2", PullRequest.class).thenCompose(this.preparePullRequest(repository))).orElse(null);
    }

    public CompletableFuture<Branch> getBranch(Repository repository, String name) {
        Optional link = repository.getLinks().getLinkBy("branches");
        return link.map(value -> this.client.get(this.concat((Link)value, name), "application/vnd.scmm-branch+json;v=2", Branch.class).thenApply(branch -> {
            branch.setCloneInformation(repository.getCloneInformation());
            return branch;
        })).orElse(null);
    }

    public CompletableFuture<ScmManagerFile> getFileObject(Repository repository, String revision, String path) {
        Optional sourcesLink = repository.getLinks().getLinkBy("sources");
        if (sourcesLink.isPresent()) {
            return ((CompletableFuture)this.client.get(this.concat((Link)sourcesLink.get(), revision, path), "application/vnd.scmm-source+json;v=2", FileObject.class).thenApply(fileObject -> new ScmManagerFile(fileObject.getPath(), fileObject.isDirectory() ? SCMFile.Type.DIRECTORY : SCMFile.Type.REGULAR_FILE))).exceptionally(ex -> {
                int statusCode;
                if (ex.getCause() instanceof IllegalReturnStatusException && (statusCode = ((IllegalReturnStatusException)ex.getCause()).getStatusCode()) == 404) {
                    return new ScmManagerFile(path, SCMFile.Type.NONEXISTENT);
                }
                throw new IllegalStateException("failed to get file object", (Throwable)ex);
            });
        }
        throw new IllegalStateException("could not find changesets link on repository " + repository.getName());
    }

    private String concat(Link link, String ... suffix) {
        StringBuilder builder = new StringBuilder();
        String href = link.getHref();
        if (href.endsWith("/")) {
            href = href.substring(0, href.length() - 1);
        }
        builder.append(href);
        for (String s : suffix) {
            builder.append("/").append(s);
        }
        return builder.toString();
    }

    private static class EmbeddedPullRequests {
        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"})
        private List<PullRequest> pullRequests;

        private EmbeddedPullRequests() {
        }

        public List<PullRequest> getPullRequests() {
            return this.pullRequests;
        }
    }

    private static class PullRequestCollection {
        private EmbeddedPullRequests _embedded;

        private PullRequestCollection() {
        }

        public EmbeddedPullRequests get_embedded() {
            return this._embedded;
        }
    }

    private static class EmbeddedTags {
        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"})
        private List<Tag> tags;

        private EmbeddedTags() {
        }

        public List<Tag> getTags() {
            return this.tags;
        }
    }

    private static class TagCollection {
        private EmbeddedTags _embedded;

        private TagCollection() {
        }

        public EmbeddedTags get_embedded() {
            return this._embedded;
        }
    }

    private static class EmbeddedBranches {
        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"})
        private List<Branch> branches;

        private EmbeddedBranches() {
        }

        public List<Branch> getBranches() {
            return this.branches;
        }
    }

    private static class BranchCollection {
        private EmbeddedBranches _embedded;

        private BranchCollection() {
        }

        public EmbeddedBranches get_embedded() {
            return this._embedded;
        }
    }

    private static class EmbeddedRepositories {
        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"})
        private List<Repository> repositories;

        private EmbeddedRepositories() {
        }

        public List<Repository> getRepositories() {
            return this.repositories;
        }
    }

    private static class RepositoryCollection {
        private EmbeddedRepositories _embedded;

        private RepositoryCollection() {
        }

        public EmbeddedRepositories get_embedded() {
            return this._embedded;
        }
    }

    private static class FileObject {
        private String path;
        private boolean directory;

        private FileObject() {
        }

        public String getPath() {
            return this.path;
        }

        public boolean isDirectory() {
            return this.directory;
        }
    }
}

