/*
 * Decompiled with CFR 0.152.
 */
package com.cloudogu.scmmanager.scm.api;

import com.cloudogu.scmmanager.scm.api.Branch;
import com.cloudogu.scmmanager.scm.api.CloneInformation;
import com.cloudogu.scmmanager.scm.api.ScmManagerHead;
import com.cloudogu.scmmanager.scm.api.ScmManagerObservable;
import com.cloudogu.scmmanager.scm.api.ScmManagerPullRequestHead;
import com.cloudogu.scmmanager.scm.api.ScmManagerPullRequestRevision;
import de.otto.edison.hal.HalRepresentation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;

public class PullRequest
extends HalRepresentation
implements ScmManagerObservable {
    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"})
    private String id;
    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"})
    private String source;
    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"})
    private String target;
    private CloneInformation cloneInformation;
    private Branch sourceBranch;
    private Branch targetBranch;
    private ScmManagerPullRequestHead head;

    PullRequest() {
    }

    public PullRequest(String id, Branch targetBranch, Branch sourceBranch, CloneInformation cloneInformation) {
        this.id = id;
        this.targetBranch = targetBranch;
        this.target = targetBranch.getName();
        this.sourceBranch = sourceBranch;
        this.source = sourceBranch.getName();
        this.cloneInformation = cloneInformation;
    }

    void setCloneInformation(CloneInformation cloneInformation) {
        this.cloneInformation = cloneInformation;
    }

    void setSourceBranch(Branch sourceBranch) {
        this.sourceBranch = sourceBranch;
    }

    void setTargetBranch(Branch targetBranch) {
        this.targetBranch = targetBranch;
    }

    public String getId() {
        return this.id;
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    @Override
    public ScmManagerPullRequestHead head() {
        if (this.head == null) {
            this.head = new ScmManagerPullRequestHead(this.cloneInformation, this.id, new ScmManagerHead(this.cloneInformation, this.target), new ScmManagerHead(this.cloneInformation, this.source));
        }
        return this.head;
    }

    public ScmManagerPullRequestRevision revision() {
        return new ScmManagerPullRequestRevision(this.head(), this.targetBranch.revision(), this.sourceBranch.revision());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PullRequest that = (PullRequest)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.source, that.source) && Objects.equals(this.target, that.target) && Objects.equals(this.cloneInformation, that.cloneInformation) && Objects.equals(this.sourceBranch, that.sourceBranch) && Objects.equals(this.targetBranch, that.targetBranch) && Objects.equals((Object)this.head, (Object)that.head);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.id, this.source, this.target, this.cloneInformation, this.sourceBranch, this.targetBranch, this.head});
    }
}

