/*
 * Decompiled with CFR 0.152.
 */
package com.cloudogu.scmmanager.scm.api;

import com.cloudogu.scmmanager.HttpAuthentication;
import com.cloudogu.scmmanager.scm.api.IllegalReturnStatusException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Response;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.UnaryOperator;
import jenkins.plugins.asynchttpclient.AHC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApiClient {
    private static final Logger LOG = LoggerFactory.getLogger(ApiClient.class);
    private final AsyncHttpClient client;
    private final HttpAuthentication authentication;
    private final ObjectMapper objectMapper;
    private final UnaryOperator<String> urlModifier;

    public ApiClient(String serverUrl, HttpAuthentication authentication) {
        this(AHC.instance(), serverUrl, authentication);
    }

    public ApiClient(AsyncHttpClient client, String serverUrl, HttpAuthentication authentication) {
        this(client, authentication, ApiClient.fixServerUrl(serverUrl));
    }

    @VisibleForTesting
    static UnaryOperator<String> fixServerUrl(String serverUrl) {
        String trimmedServerUrl = serverUrl.trim();
        String fixedServerUrl = trimmedServerUrl.endsWith("/") ? trimmedServerUrl.substring(0, trimmedServerUrl.length() - 1) : trimmedServerUrl;
        return url -> {
            if (url.contains("://")) {
                return url;
            }
            return fixedServerUrl + url;
        };
    }

    @VisibleForTesting
    ApiClient(AsyncHttpClient client, HttpAuthentication authentication, UnaryOperator<String> urlModifier) {
        this.client = client;
        this.authentication = authentication;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.urlModifier = urlModifier;
    }

    public static void handleException(ExecutionException e) {
        Throwable cause = e.getCause();
        if (cause instanceof JsonParseException || cause instanceof JsonMappingException) {
            LOG.warn("could not parse response for request", (Throwable)e);
        } else if (cause instanceof IllegalReturnStatusException) {
            LOG.warn("got error in request: {}", (Object)e.getMessage());
        } else if (cause instanceof TimeoutException) {
            LOG.warn("request timed out: {}", (Object)e.getMessage());
        } else {
            LOG.warn("got unknown exception in request", (Throwable)e);
        }
    }

    public <T> CompletableFuture<T> get(String url, String contentType, final Class<T> type) {
        LOG.info("get {} from {}", (Object)type.getName(), (Object)url);
        AsyncHttpClient.BoundRequestBuilder requestBuilder = this.client.prepareGet((String)this.urlModifier.apply(url));
        this.authentication.authenticate(requestBuilder);
        requestBuilder.addHeader("Accept", contentType);
        final CompletableFuture future = new CompletableFuture();
        requestBuilder.execute((AsyncHandler)new AsyncCompletionHandler<Response>(){

            public void onThrowable(Throwable ex) {
                future.completeExceptionally(ex);
            }

            public Response onCompleted(Response response) {
                if (response.getStatusCode() == 200) {
                    try {
                        Object t = ApiClient.this.objectMapper.readValue(response.getResponseBodyAsBytes(), type);
                        future.complete(t);
                    }
                    catch (Exception ex) {
                        future.completeExceptionally(ex);
                    }
                } else {
                    future.completeExceptionally(new IllegalReturnStatusException(response.getStatusCode()));
                }
                return response;
            }
        });
        return future;
    }
}

