/*
 * Decompiled with CFR 0.152.
 */
package com.cloudogu.scmmanager.scm;

import com.cloudogu.scmmanager.scm.ScmManagerBranchEvent;
import com.cloudogu.scmmanager.scm.ScmManagerHeadEvent;
import com.cloudogu.scmmanager.scm.ScmManagerPullRequestEvent;
import com.cloudogu.scmmanager.scm.ScmManagerTagEvent;
import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import hudson.security.csrf.CrumbExclusion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHeadEvent;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class ScmManagerWebHook
implements UnprotectedRootAction {
    public static final String URL_NAME = "scm-manager-hook";
    public static final String ENDPOINT = "notify";

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return URL_NAME;
    }

    @RequirePOST
    public HttpResponse doNotify(StaplerRequest request) throws ServletException {
        JSONObject form = request.getSubmittedForm();
        if (!this.verifyParameters(form, "namespace", "name", "type", "server")) {
            return HttpResponses.errorWithoutStack((int)400, (String)"requires values for 'namespace', 'name', 'type', 'server'");
        }
        this.fireIfPresent(form, "deletedBranches", branches -> new ScmManagerBranchEvent(SCMEvent.Type.REMOVED, form, (Collection<JSONObject>)branches));
        this.fireIfPresent(form, "createdOrModifiedBranches", branches -> new ScmManagerBranchEvent(SCMEvent.Type.UPDATED, form, (Collection<JSONObject>)branches));
        this.fireIfPresent(form, "deletedTags", tags -> new ScmManagerTagEvent(SCMEvent.Type.REMOVED, form, (Collection<JSONObject>)tags));
        this.fireIfPresent(form, "createOrModifiedTags", tags -> new ScmManagerTagEvent(SCMEvent.Type.UPDATED, form, (Collection<JSONObject>)tags));
        this.fireIfPresent(form, "deletedPullRequests", pullRequests -> new ScmManagerPullRequestEvent(SCMEvent.Type.REMOVED, form, (Collection<JSONObject>)pullRequests));
        this.fireIfPresent(form, "createOrModifiedPullRequests", pullRequests -> new ScmManagerPullRequestEvent(SCMEvent.Type.UPDATED, form, (Collection<JSONObject>)pullRequests));
        return HttpResponses.ok();
    }

    void fireIfPresent(JSONObject form, String arrayName, Function<Collection<JSONObject>, ScmManagerHeadEvent> eventProvider) {
        JSONArray array;
        if (form.containsKey((Object)arrayName) && (array = form.optJSONArray(arrayName)) != null && !array.isEmpty()) {
            ArrayList<JSONObject> objects = new ArrayList<JSONObject>();
            for (int i = 0; i < array.size(); ++i) {
                objects.add(array.getJSONObject(i));
            }
            this.fireNow(eventProvider.apply(objects));
        }
    }

    @VisibleForTesting
    void fireNow(ScmManagerHeadEvent event) {
        SCMHeadEvent.fireNow((SCMHeadEvent)event);
    }

    private boolean verifyParameters(JSONObject form, String ... keys) {
        return Arrays.stream(keys).allMatch(arg_0 -> ((JSONObject)form).containsKey(arg_0));
    }

    @Extension
    public static class CrumbExclusionImpl
    extends CrumbExclusion {
        public boolean process(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
            String pathInfo = req.getPathInfo();
            if (pathInfo != null && pathInfo.equals("/scm-manager-hook/notify")) {
                chain.doFilter((ServletRequest)req, (ServletResponse)resp);
                return true;
            }
            return false;
        }
    }
}

