/*
 * Decompiled with CFR 0.152.
 */
package com.cloudogu.scmmanager.scm;

import com.cloudogu.scmmanager.scm.ScmManagerApiProbe;
import com.cloudogu.scmmanager.scm.ScmManagerSourceRequest;
import com.cloudogu.scmmanager.scm.api.ApiClient;
import com.cloudogu.scmmanager.scm.api.Futures;
import com.cloudogu.scmmanager.scm.api.Repository;
import com.cloudogu.scmmanager.scm.api.ScmManagerApi;
import com.cloudogu.scmmanager.scm.api.ScmManagerHead;
import com.cloudogu.scmmanager.scm.api.ScmManagerObservable;
import com.cloudogu.scmmanager.scm.api.ScmManagerPullRequestHead;
import com.cloudogu.scmmanager.scm.api.ScmManagerPullRequestRevision;
import com.cloudogu.scmmanager.scm.api.ScmManagerRevision;
import com.cloudogu.scmmanager.scm.api.ScmManagerTag;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;

public class ScmManagerSourceRetriever {
    private final ScmManagerApi api;
    private final Repository repository;

    private ScmManagerSourceRetriever(ScmManagerApi api, Repository repository) {
        this.api = api;
        this.repository = repository;
    }

    public Iterable<ScmManagerObservable> getSpecificCandidatesFromSourceControl(ScmManagerSourceRequest request, SCMHead head) throws InterruptedException {
        try {
            CompletableFuture<? extends ScmManagerObservable> candidate = this.getSpecificCandidateFromSourceControl(request, head);
            if (candidate != null) {
                return Collections.singleton(candidate.get());
            }
        }
        catch (ExecutionException e) {
            ApiClient.handleException(e);
            throw new UncheckedIOException(new IOException("failed to load repository"));
        }
        return Collections.emptySet();
    }

    private CompletableFuture<? extends ScmManagerObservable> getSpecificCandidateFromSourceControl(ScmManagerSourceRequest request, SCMHead head) {
        if (head instanceof ScmManagerTag) {
            if (request.isFetchTags()) {
                return this.api.getTag(this.repository, head.getName());
            }
        } else if (head instanceof ScmManagerPullRequestHead) {
            if (request.isFetchPullRequests()) {
                return this.api.getPullRequest(this.repository, ((ScmManagerPullRequestHead)head).getId());
            }
        } else if (head instanceof ScmManagerHead && request.isFetchBranches()) {
            return this.api.getBranch(this.repository, head.getName());
        }
        return null;
    }

    public Iterable<ScmManagerObservable> getAllCandidatesFromSourceControl(ScmManagerSourceRequest request) throws InterruptedException {
        try {
            CompletableFuture branchesFuture = request.isFetchBranches() ? this.api.getBranches(this.repository) : CompletableFuture.completedFuture(Collections.emptyList());
            CompletableFuture tagsFuture = request.isFetchTags() ? this.api.getTags(this.repository) : CompletableFuture.completedFuture(Collections.emptyList());
            CompletableFuture pullRequestFuture = request.isFetchPullRequests() ? this.api.getPullRequests(this.repository) : CompletableFuture.completedFuture(Collections.emptyList());
            CompletableFuture.allOf(branchesFuture, tagsFuture, pullRequestFuture).join();
            ArrayList<ScmManagerObservable> observables = new ArrayList<ScmManagerObservable>();
            observables.addAll(branchesFuture.get());
            observables.addAll(tagsFuture.get());
            observables.addAll(pullRequestFuture.get());
            return observables;
        }
        catch (ExecutionException e) {
            ApiClient.handleException(e);
            throw new UncheckedIOException(new IOException("failed to load repository"));
        }
    }

    public ScmManagerApiProbe probe(@NonNull SCMHead head, @CheckForNull SCMRevision revision) {
        ScmManagerRevision rev = null;
        if (revision instanceof ScmManagerPullRequestRevision) {
            rev = ((ScmManagerPullRequestRevision)revision).getSourceRevision();
        } else if (revision instanceof ScmManagerRevision) {
            rev = (ScmManagerRevision)revision;
        } else {
            throw new IllegalArgumentException("unknown type of revision " + revision);
        }
        return new ScmManagerApiProbe(this.api, this.repository, head, rev);
    }

    static ScmManagerSourceRetriever create(ScmManagerApi api, String namespace, String name) {
        return new ScmManagerSourceRetriever(api, Futures.resolveUnchecked(api.getRepository(namespace, name)));
    }
}

