/*
 * Decompiled with CFR 0.152.
 */
package com.cloudogu.scmmanager.scm;

import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.cloudogu.scmmanager.HttpAuthentication;
import com.cloudogu.scmmanager.scm.BranchDiscoveryTrait;
import com.cloudogu.scmmanager.scm.Icons;
import com.cloudogu.scmmanager.scm.LinkBuilder;
import com.cloudogu.scmmanager.scm.PullRequestDiscoveryTrait;
import com.cloudogu.scmmanager.scm.SCMBuilderProvider;
import com.cloudogu.scmmanager.scm.ScmManagerLink;
import com.cloudogu.scmmanager.scm.ScmManagerSourceContext;
import com.cloudogu.scmmanager.scm.ScmManagerSourceRequest;
import com.cloudogu.scmmanager.scm.ScmManagerSourceRetriever;
import com.cloudogu.scmmanager.scm.api.ApiClient;
import com.cloudogu.scmmanager.scm.api.Authentications;
import com.cloudogu.scmmanager.scm.api.Repository;
import com.cloudogu.scmmanager.scm.api.ScmManagerApi;
import com.cloudogu.scmmanager.scm.api.ScmManagerHead;
import com.cloudogu.scmmanager.scm.api.ScmManagerObservable;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import de.otto.edison.hal.HalRepresentation;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMProbe;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceEvent;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.trait.SCMSourceRequest;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.impl.ChangeRequestSCMHeadCategory;
import jenkins.scm.impl.TagSCMHeadCategory;
import jenkins.scm.impl.UncategorizedSCMHeadCategory;
import jenkins.util.NonLocalizable;
import org.acegisecurity.Authentication;
import org.jenkinsci.Symbol;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ScmManagerSource
extends SCMSource {
    private final String serverUrl;
    private final String namespace;
    private final String name;
    private final String type;
    private final String credentialsId;
    private final LinkBuilder linkBuilder;
    @NonNull
    private List<SCMSourceTrait> traits = new ArrayList<SCMSourceTrait>();
    private BiFunction<String, HttpAuthentication, ScmManagerApi> apiFactory;
    private Function<SCMSourceOwner, Authentications> authenticationsProvider;

    @DataBoundConstructor
    public ScmManagerSource(String serverUrl, String repository, String credentialsId) {
        this(serverUrl, repository, credentialsId, ScmManagerSource::createHttpClient, Authentications::new);
    }

    ScmManagerSource(String serverUrl, String repository, String credentialsId, BiFunction<String, HttpAuthentication, ScmManagerApi> apiFactory, Function<SCMSourceOwner, Authentications> authenticationsProvider) {
        this.serverUrl = serverUrl;
        this.credentialsId = credentialsId;
        String[] parts = repository.split("/");
        this.namespace = parts[0];
        this.name = parts[1];
        this.type = parts[2];
        this.apiFactory = apiFactory;
        this.authenticationsProvider = authenticationsProvider;
        this.linkBuilder = new LinkBuilder(serverUrl, this.namespace, this.name);
    }

    @NonNull
    public List<SCMSourceTrait> getTraits() {
        return Collections.unmodifiableList(this.traits);
    }

    @DataBoundSetter
    public void setTraits(@CheckForNull List<SCMSourceTrait> traits) {
        this.traits = new ArrayList<SCMSourceTrait>(Util.fixNull(traits));
    }

    String getNamespace() {
        return this.namespace;
    }

    String getName() {
        return this.name;
    }

    String getType() {
        return this.type;
    }

    protected void retrieve(SCMSourceCriteria criteria, @NonNull SCMHeadObserver observer, SCMHeadEvent<?> event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        try (ScmManagerSourceRequest request = ((ScmManagerSourceContext)new ScmManagerSourceContext(criteria, observer).withTraits(this.traits)).newRequest(this, listener);){
            this.handleRequest(observer, event, request);
        }
    }

    @VisibleForTesting
    void handleRequest(@NonNull SCMHeadObserver observer, SCMHeadEvent<?> event, ScmManagerSourceRequest request) throws InterruptedException, IOException {
        Set includes;
        Iterable<ScmManagerObservable> candidates = null;
        ScmManagerSourceRetriever handler = ScmManagerSourceRetriever.create(this.createApi(), this.namespace, this.name);
        if ((event == null || event.getType() != SCMEvent.Type.REMOVED) && (includes = observer.getIncludes()) != null && includes.size() == 1) {
            candidates = handler.getSpecificCandidatesFromSourceControl(request, (SCMHead)includes.iterator().next());
        }
        if (candidates == null) {
            candidates = handler.getAllCandidatesFromSourceControl(request);
        }
        for (ScmManagerObservable candidate : candidates) {
            if (!request.process(candidate.head(), candidate.revision(), handler::probe, new SCMSourceRequest.Witness[]{new CriteriaWitness(request)})) continue;
            return;
        }
    }

    @NonNull
    protected SCMProbe createProbe(@NonNull SCMHead head, @CheckForNull SCMRevision revision) {
        ScmManagerSourceRetriever handler = ScmManagerSourceRetriever.create(this.createApi(), this.namespace, this.name);
        return handler.probe(head, revision);
    }

    private ScmManagerApi createApi() {
        HttpAuthentication authentication = this.getAuthenticationsProvider().apply(this.getOwner()).from(this.serverUrl, this.credentialsId);
        return this.getApiFactory().apply(this.serverUrl, authentication);
    }

    @NonNull
    public SCM build(@NonNull SCMHead head, SCMRevision revision) {
        if (head instanceof ScmManagerHead) {
            SCMBuilderProvider.Context ctx = new SCMBuilderProvider.Context(this.linkBuilder, (ScmManagerHead)head, revision, this.credentialsId);
            return SCMBuilderProvider.from(ctx).build();
        }
        throw new IllegalArgumentException("Could not handle unknown SCMHead: " + head);
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getRepository() {
        return String.format("%s/%s/%s", this.namespace, this.name, this.type);
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    private BiFunction<String, HttpAuthentication, ScmManagerApi> getApiFactory() {
        if (this.apiFactory == null) {
            this.apiFactory = ScmManagerSource::createHttpClient;
        }
        return this.apiFactory;
    }

    private Function<SCMSourceOwner, Authentications> getAuthenticationsProvider() {
        if (this.authenticationsProvider == null) {
            this.authenticationsProvider = Authentications::new;
        }
        return this.authenticationsProvider;
    }

    private static ScmManagerApi createHttpClient(String value, HttpAuthentication authentication) {
        return new ScmManagerApi(new ApiClient(value, authentication));
    }

    @NonNull
    protected List<Action> retrieveActions(@NonNull SCMRevision revision, SCMHeadEvent event, @NonNull TaskListener listener) {
        return Collections.singletonList(new ScmManagerLink("icon-scm-manager-link", this.linkBuilder.create(revision)));
    }

    @NonNull
    protected List<Action> retrieveActions(@NonNull SCMHead head, SCMHeadEvent event, @NonNull TaskListener listener) {
        return Collections.singletonList(new ScmManagerLink("icon-scm-manager-link", this.linkBuilder.create(head)));
    }

    @NonNull
    protected List<Action> retrieveActions(@CheckForNull SCMSourceEvent event, @NonNull TaskListener listener) {
        return Collections.singletonList(new ScmManagerLink("icon-scm-manager-link", this.linkBuilder.repo()));
    }

    static {
        Icons.register("icon-scm-manager-link");
    }

    private static class CriteriaWitness
    implements SCMSourceRequest.Witness {
        private final ScmManagerSourceRequest request;

        public CriteriaWitness(ScmManagerSourceRequest request) {
            this.request = request;
        }

        public void record(@NonNull SCMHead scmHead, SCMRevision revision, boolean isMatch) {
            PrintStream logger = this.request.listener().getLogger();
            logger.append("    ").append(scmHead.getName()).append(": ");
            if (revision == null) {
                logger.println("Skipped");
            } else if (isMatch) {
                logger.println("Met criteria");
            } else {
                logger.println("Does not meet criteria");
            }
        }
    }

    @Extension
    @Symbol(value={"scm-manager"})
    public static class DescriptorImpl
    extends SCMSourceDescriptor {
        private final BiFunction<String, HttpAuthentication, ScmManagerApi> apiFactory;
        private final Predicate<Repository> repositoryPredicate;

        public DescriptorImpl() {
            this((x$0, x$1) -> ScmManagerSource.createHttpClient(x$0, x$1), SCMBuilderProvider::isSupported);
        }

        public DescriptorImpl(BiFunction<String, HttpAuthentication, ScmManagerApi> apiFactory, Predicate<Repository> repositoryPredicate) {
            this.apiFactory = apiFactory;
            this.repositoryPredicate = repositoryPredicate;
        }

        @Nonnull
        public String getDisplayName() {
            return "SCM-Manager";
        }

        public FormValidation doCheckServerUrl(@QueryParameter String value) throws InterruptedException, ExecutionException {
            String trimmedValue = value.trim();
            if (Strings.isNullOrEmpty((String)trimmedValue)) {
                return FormValidation.error((String)"server url is required");
            }
            try {
                URI uri = new URI(value);
                if (!uri.isAbsolute()) {
                    return FormValidation.error((String)"illegal URL format");
                }
                if (!uri.getScheme().startsWith("http")) {
                    return FormValidation.error((String)"Only http or https urls accepted");
                }
            }
            catch (URISyntaxException e2) {
                return FormValidation.error((String)"illegal URL format");
            }
            ScmManagerApi api = this.apiFactory.apply(value, x -> {});
            CompletableFuture<HalRepresentation> future = api.index();
            return (FormValidation)((CompletableFuture)((CompletableFuture)future.thenApply(index -> {
                if (index.getLinks().getLinkBy("login").isPresent()) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)"api has no login link");
            })).exceptionally(e -> FormValidation.error((String)e.getMessage()))).get();
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath SCMSourceOwner context, @QueryParameter String serverUrl, @QueryParameter String value) throws InterruptedException, ExecutionException {
            return this.validateCredentialsId(context, serverUrl, value, Authentications::new);
        }

        @VisibleForTesting
        FormValidation validateCredentialsId(@AncestorInPath SCMSourceOwner context, @QueryParameter String serverUrl, @QueryParameter String value, Function<SCMSourceOwner, Authentications> authenticationsProvider) throws InterruptedException, ExecutionException {
            if (this.doCheckServerUrl((String)serverUrl).kind != FormValidation.Kind.OK) {
                return FormValidation.error((String)"server url is required");
            }
            if (Strings.isNullOrEmpty((String)value)) {
                return FormValidation.error((String)"credentials are required");
            }
            Authentications authentications = authenticationsProvider.apply(context);
            ScmManagerApi client = this.apiFactory.apply(serverUrl, authentications.from(serverUrl, value));
            CompletableFuture<HalRepresentation> future = client.index();
            return (FormValidation)((CompletableFuture)((CompletableFuture)future.thenApply(index -> {
                if (index.getLinks().getLinkBy("me").isPresent()) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)"login failed");
            })).exceptionally(e -> FormValidation.error((String)e.getMessage()))).get();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String value) {
            if (context == null || !context.hasPermission(Item.CONFIGURE)) {
                return new StandardUsernameListBoxModel().includeCurrentValue(value);
            }
            Authentication authentication = context instanceof Queue.Task ? ((Queue.Task)context).getDefaultAuthentication() : ACL.SYSTEM;
            return new StandardUsernameListBoxModel().includeEmptyValue().includeAs(authentication, (Item)context, StandardUsernameCredentials.class, URIRequirementBuilder.fromUri((String)value).build()).includeCurrentValue(value);
        }

        public ListBoxModel doFillRepositoryItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String serverUrl, @QueryParameter String credentialsId, @QueryParameter String value) throws InterruptedException, ExecutionException {
            return this.fillRepositoryItems(context, serverUrl, credentialsId, value, Authentications::new);
        }

        public ListBoxModel fillRepositoryItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String serverUrl, @QueryParameter String credentialsId, @QueryParameter String value, Function<SCMSourceOwner, Authentications> authenticationsProvider) throws InterruptedException, ExecutionException {
            ListBoxModel model = new ListBoxModel();
            if (Strings.isNullOrEmpty((String)serverUrl) || Strings.isNullOrEmpty((String)credentialsId)) {
                if (!Strings.isNullOrEmpty((String)value)) {
                    model.add(value);
                }
                return model;
            }
            Authentications authentications = authenticationsProvider.apply(context);
            ScmManagerApi api = this.apiFactory.apply(serverUrl, authentications.from(serverUrl, credentialsId));
            List repositories = (List)((CompletableFuture)api.getRepositories().exceptionally(e -> Collections.emptyList())).get();
            for (Repository repository : repositories) {
                if (!this.repositoryPredicate.test(repository)) continue;
                String displayName = String.format("%s/%s (%s)", repository.getNamespace(), repository.getName(), repository.getType());
                String v = String.format("%s/%s/%s", repository.getNamespace(), repository.getName(), repository.getType());
                model.add(displayName, v);
            }
            return model;
        }

        public List<SCMSourceTraitDescriptor> getTraitsDescriptors() {
            LinkedHashSet<SCMSourceTraitDescriptor> traitDescriptors = new LinkedHashSet<SCMSourceTraitDescriptor>();
            traitDescriptors.addAll(SCMSourceTrait._for((SCMSourceDescriptor)this, ScmManagerSourceContext.class, null));
            for (SCMBuilderProvider provider : SCMBuilderProvider.all()) {
                traitDescriptors.addAll(provider.getTraitDescriptors(this));
            }
            return new ArrayList<SCMSourceTraitDescriptor>(traitDescriptors);
        }

        @NonNull
        public List<SCMSourceTrait> getTraitsDefaults() {
            return Arrays.asList(new SCMSourceTrait[]{new BranchDiscoveryTrait(), new PullRequestDiscoveryTrait()});
        }

        @NonNull
        protected SCMHeadCategory[] createCategories() {
            return new SCMHeadCategory[]{UncategorizedSCMHeadCategory.DEFAULT, new ChangeRequestSCMHeadCategory((Localizable)new NonLocalizable("Pull Requests")), TagSCMHeadCategory.DEFAULT};
        }

        public String getIconClassName() {
            return "icon-scm-manager-source";
        }

        static {
            Icons.register("icon-scm-manager-source");
        }
    }
}

