/*
 * Decompiled with CFR 0.152.
 */
package com.cloudogu.scmmanager.scm;

import com.cloudogu.scmmanager.scm.ScmManagerHeadEvent;
import com.cloudogu.scmmanager.scm.api.CloneInformation;
import com.cloudogu.scmmanager.scm.api.ScmManagerHead;
import com.cloudogu.scmmanager.scm.api.ScmManagerPullRequestHead;
import java.util.Collection;
import java.util.stream.Collectors;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import net.sf.json.JSONObject;

public class ScmManagerPullRequestEvent
extends ScmManagerHeadEvent {
    private Collection<PullRequestFromJson> pullRequests;

    public ScmManagerPullRequestEvent(SCMEvent.Type type, JSONObject form, Collection<JSONObject> pullRequests) {
        super(type, form);
        this.pullRequests = pullRequests.stream().map(PullRequestFromJson::new).collect(Collectors.toList());
    }

    @Override
    Collection<SCMHead> heads(CloneInformation cloneInformation) {
        return this.pullRequests.stream().map(pullRequest -> new ScmManagerPullRequestHead(cloneInformation, ((PullRequestFromJson)pullRequest).id, new ScmManagerHead(cloneInformation, ((PullRequestFromJson)pullRequest).target), new ScmManagerHead(cloneInformation, ((PullRequestFromJson)pullRequest).source))).collect(Collectors.toList());
    }

    private static class PullRequestFromJson {
        private final String id;
        private final String source;
        private final String target;

        public PullRequestFromJson(JSONObject json) {
            this.id = json.getString("id");
            this.source = json.getString("source");
            this.target = json.getString("target");
        }
    }
}

