/*
 * Decompiled with CFR 0.152.
 */
package com.cloudogu.scmmanager.scm;

import com.google.common.base.MoreObjects;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Action;
import java.util.Objects;
import jenkins.model.Jenkins;
import org.apache.commons.jelly.JellyContext;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkins.ui.icon.IconSpec;
import org.kohsuke.stapler.Stapler;

public class ScmManagerLink
implements Action,
IconSpec {
    @NonNull
    private final String iconClassName;
    @NonNull
    private final String url;

    public ScmManagerLink(@NonNull String iconClassName, @NonNull String url) {
        this.iconClassName = iconClassName;
        this.url = url;
    }

    public String getIconFileName() {
        Icon icon;
        String className = this.getIconClassName();
        if (className != null && (icon = IconSet.icons.getIconByClassSpec((Object)(className + " icon-md"))) != null) {
            JellyContext ctx = new JellyContext();
            ctx.setVariable("resURL", (Object)(Stapler.getCurrentRequest().getContextPath() + Jenkins.RESOURCE_PATH));
            return icon.getQualifiedUrl(ctx);
        }
        return null;
    }

    @NonNull
    public String getDisplayName() {
        return "SCM-Manager";
    }

    @NonNull
    public String getUrlName() {
        return this.url;
    }

    public String getIconClassName() {
        return this.iconClassName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScmManagerLink that = (ScmManagerLink)o;
        return this.iconClassName.equals(that.iconClassName) && this.url.equals(that.url);
    }

    public int hashCode() {
        return Objects.hash(this.iconClassName, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("iconClassName", (Object)this.iconClassName).add("url", (Object)this.url).toString();
    }
}

