/*
 * Decompiled with CFR 0.152.
 */
package com.cloudogu.scmmanager.scm;

import com.cloudogu.scmmanager.scm.ScmManagerSource;
import com.cloudogu.scmmanager.scm.api.CloneInformation;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.scm.SCM;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.Stapler;

abstract class ScmManagerHeadEvent
extends SCMHeadEvent<TriggerPayload> {
    private final String namespace;
    private final String name;
    private final String type;
    private final String serverUrl;

    ScmManagerHeadEvent(SCMEvent.Type changeType, JSONObject form) {
        this(changeType, form.getString("namespace"), form.getString("name"), form.getString("type"), form.getString("server"));
    }

    ScmManagerHeadEvent(SCMEvent.Type changeType, String namespace, String name, String type, String serverUrl) {
        super(changeType, (Object)new TriggerPayload(namespace, name), SCMEvent.originOf((HttpServletRequest)Stapler.getCurrentRequest()));
        this.namespace = namespace;
        this.name = name;
        this.type = type;
        this.serverUrl = serverUrl;
    }

    public boolean isMatch(@NonNull SCMNavigator navigator) {
        return false;
    }

    @NonNull
    public String getSourceName() {
        return "dummy";
    }

    @NonNull
    public Map<SCMHead, SCMRevision> heads(@NonNull SCMSource source) {
        ScmManagerSource scmManagerSource = (ScmManagerSource)source;
        CloneInformation cloneInformation = new CloneInformation(scmManagerSource.getType(), scmManagerSource.getServerUrl());
        Collection<SCMHead> heads = this.heads(cloneInformation);
        HashMap<SCMHead, SCMRevision> map = new HashMap<SCMHead, SCMRevision>();
        heads.forEach(head -> {
            SCMRevision cfr_ignored_0 = map.put((SCMHead)head, (SCMRevision)null);
        });
        return map;
    }

    abstract Collection<SCMHead> heads(CloneInformation var1);

    public boolean isMatch(@NonNull SCMSource source) {
        return source instanceof ScmManagerSource && this.isMatch((ScmManagerSource)source);
    }

    private boolean isMatch(@NonNull ScmManagerSource source) {
        return source.getRepository().equals(String.format("%s/%s/%s", this.namespace, this.name, this.type)) && source.getServerUrl().startsWith(this.serverUrl);
    }

    public boolean isMatch(@NonNull SCM scm) {
        return false;
    }

    public static class TriggerPayload {
        private final String namespace;
        private final String name;

        public TriggerPayload(String namespace, String name) {
            this.namespace = namespace;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TriggerPayload that = (TriggerPayload)o;
            return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.namespace, this.name);
        }
    }
}

