/*
 * Decompiled with CFR 0.152.
 */
package com.cloudogu.scmmanager.scm;

import com.cloudogu.scmmanager.scm.LinkBuilder;
import com.cloudogu.scmmanager.scm.ScmManagerGitRepositoryBrowser;
import com.cloudogu.scmmanager.scm.api.ScmManagerHead;
import com.cloudogu.scmmanager.scm.api.ScmManagerPullRequestHead;
import com.cloudogu.scmmanager.scm.api.ScmManagerPullRequestRevision;
import com.cloudogu.scmmanager.scm.api.ScmManagerTag;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.plugins.git.UserMergeOptions;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.impl.PreBuildMerge;
import java.util.Arrays;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import org.jenkinsci.plugins.gitclient.MergeCommand;

public class ScmManagerGitSCMBuilder
extends GitSCMBuilder<ScmManagerGitSCMBuilder> {
    public ScmManagerGitSCMBuilder(@NonNull LinkBuilder linkBuilder, @NonNull ScmManagerHead head, SCMRevision revision, String credentialsId) {
        super((SCMHead)head, revision, head.getCloneInformation().getUrl(), credentialsId);
        this.withoutRefSpecs();
        this.withBrowser(new ScmManagerGitRepositoryBrowser(linkBuilder));
        if (head instanceof ScmManagerTag) {
            this.withRefSpec("+refs/tags/" + head.getName() + ":refs/tags/" + head.getName());
        } else if (head instanceof ScmManagerPullRequestHead) {
            ScmManagerPullRequestHead prHead = (ScmManagerPullRequestHead)head;
            ScmManagerHead source = prHead.getSource();
            this.withHead(source);
            ScmManagerHead target = prHead.getTarget();
            this.withRefSpecs(Arrays.asList("+refs/heads/" + source.getName() + ":refs/remotes/origin/" + source.getName(), "+refs/heads/" + target.getName() + ":refs/remotes/origin/" + target.getName()));
            if (revision != null) {
                ScmManagerPullRequestRevision prRevision = (ScmManagerPullRequestRevision)revision;
                this.withRevision(prRevision.getSourceRevision());
            }
            this.withExtension((GitSCMExtension)new PreBuildMerge(new UserMergeOptions("origin", target.getName(), "resolve", MergeCommand.GitPluginFastForwardMode.NO_FF)));
        } else {
            this.withRefSpec("+refs/heads/" + head.getName() + ":refs/remotes/@{remote}/" + head.getName());
        }
    }
}

