/*
 * Decompiled with CFR 0.152.
 */
package com.cloudogu.scmmanager.scm;

import com.cloudogu.scmmanager.scm.LinkBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import java.io.IOException;
import java.net.URL;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class ScmManagerGitRepositoryBrowser
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;
    private final LinkBuilder linkBuilder;

    @DataBoundConstructor
    public ScmManagerGitRepositoryBrowser(String repoUrl) {
        this(new LinkBuilder(repoUrl));
    }

    ScmManagerGitRepositoryBrowser(LinkBuilder linkBuilder) {
        super(linkBuilder.repo());
        this.linkBuilder = linkBuilder;
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        return new URL(this.linkBuilder.changeset(changeSet.getId()));
    }

    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType() != EditType.EDIT || path.getSrc() == null || path.getDst() == null || path.getChangeSet().getParentCommit() == null) {
            return null;
        }
        return new URL(this.linkBuilder.diff(path.getChangeSet().getId(), path.getPath()));
    }

    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType().equals(EditType.DELETE)) {
            return new URL(this.linkBuilder.diff(path.getChangeSet().getId(), path.getPath()));
        }
        return new URL(this.linkBuilder.source(path.getChangeSet().getId(), path.getPath()));
    }

    @Extension
    public static class ScmManagerGitRepositoryBrowserDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        @NonNull
        public String getDisplayName() {
            return "SCM-Manager";
        }

        public ScmManagerGitRepositoryBrowser newInstance(StaplerRequest req, @NonNull JSONObject jsonObject) throws Descriptor.FormException {
            assert (req != null);
            return (ScmManagerGitRepositoryBrowser)((Object)req.bindJSON(ScmManagerGitRepositoryBrowser.class, jsonObject));
        }
    }
}

