/*
 * Decompiled with CFR 0.152.
 */
package com.cloudogu.scmmanager.scm;

import com.cloudogu.scmmanager.scm.HeadResolver;
import com.cloudogu.scmmanager.scm.api.Changeset;
import com.cloudogu.scmmanager.scm.api.Futures;
import com.cloudogu.scmmanager.scm.api.Repository;
import com.cloudogu.scmmanager.scm.api.ScmManagerApi;
import com.cloudogu.scmmanager.scm.api.ScmManagerFile;
import com.cloudogu.scmmanager.scm.api.ScmManagerRevision;
import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMProbe;
import jenkins.scm.api.SCMProbeStat;

public class ScmManagerApiProbe
extends SCMProbe {
    private static final long serialVersionUID = -1L;
    private final transient ScmManagerApi api;
    private final Repository repository;
    private final SCMHead head;
    private transient CompletableFuture<ScmManagerRevision> revision;
    private Date lastModified;

    public ScmManagerApiProbe(@NonNull ScmManagerApi api, @NonNull Repository repository, @NonNull SCMHead head, @CheckForNull ScmManagerRevision revision) {
        this.api = api;
        this.repository = repository;
        this.head = head;
        if (revision != null) {
            this.revision = CompletableFuture.completedFuture(revision);
        }
    }

    @VisibleForTesting
    CompletableFuture<String> revision() {
        if (this.revision == null) {
            this.revision = new HeadResolver(this.api, this.repository).resolve(this.head);
        }
        return this.revision.thenApply(ScmManagerRevision::getRevision);
    }

    public String name() {
        return this.head.getName();
    }

    public long lastModified() {
        if (this.lastModified != null) {
            return this.lastModified.getTime();
        }
        CompletionStage future = this.revision().thenCompose(r -> this.api.getChangeset(this.repository, (String)r));
        Changeset changeset = (Changeset)Futures.resolveUnchecked(future);
        this.lastModified = changeset.getDate();
        return this.lastModified.getTime();
    }

    @NonNull
    public SCMProbeStat stat(@NonNull String path) throws IOException {
        CompletionStage future = this.revision().thenCompose(r -> this.api.getFileObject(this.repository, (String)r, path));
        ScmManagerFile file = (ScmManagerFile)Futures.resolveChecked(future);
        return SCMProbeStat.fromType((SCMFile.Type)file.getType());
    }

    public void close() {
    }
}

